/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import jakarta.persistence.EntityManager;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record1;
import org.jooq.Record3;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectOnConditionStep;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.WorkDeleteEntities;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.deletion.NodeScope;
import org.squashtest.tm.service.internal.deletion.helper.testcase.TestCaseNodeScopeQueryHelper;
import org.squashtest.tm.service.internal.deletion.jdbc.AbstractJdbcDeletionHandler;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcBatchReorderHelper;
import org.squashtest.tm.service.internal.helper.JooqUpdateHelper;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

public class JdbcTestCaseNodeDeletionHandler
extends AbstractJdbcDeletionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcTestCaseNodeDeletionHandler.class);
    private final NodeScope scope;
    private final boolean isBinFilterEnabled;
    private final Collection<Long> excludedIds;

    public JdbcTestCaseNodeDeletionHandler(NodeScope scope, DSLContext dslContext, EntityManager entityManager, AttachmentRepository attachmentRepository, JdbcBatchReorderHelper reorderHelper, String operationId, boolean isBinFilterEnabled, Collection<Long> excludedIds) {
        super(dslContext, attachmentRepository, reorderHelper, operationId, entityManager);
        this.scope = scope;
        this.isBinFilterEnabled = isBinFilterEnabled;
        this.excludedIds = excludedIds;
    }

    public OperationReport delete() {
        this.logStartProcess();
        this.clearPersistenceContext();
        this.storeEntitiesToDeleteIntoWorkingTable();
        this.nullify();
        this.performDeletions();
        OperationReport report = this.makeReport();
        this.cleanWorkingTable();
        this.logEndProcess();
        return report;
    }

    private OperationReport makeReport() {
        OperationReport report = new OperationReport();
        report.addRemoved(this.workingTables.selectIds(Tables.TEST_CASE_FOLDER.TCLN_ID), "folder");
        report.addRemoved(this.workingTables.selectIds(Tables.TEST_CASE.TCLN_ID), "test-case");
        return report;
    }

    private void performDeletions() {
        this.deleteCampaignItems();
        this.deleteTestPlanItems();
        this.deleteDatasetsAndParameters();
        this.deleteCoverage();
        this.deleteTestCaseMilestones();
        this.deleteSteps();
        this.deleteRelationShips();
        this.deleteTestAutomationCandidate();
        this.deleteNodes();
        this.deleteAutomationRequests();
        this.deleteCustomFieldValues();
        this.deleteAttachmentLists();
        this.deleteAttachmentContents();
    }

    private void deleteCampaignItems() {
        this.workingTables.delete(Tables.TEST_CASE.TCLN_ID, Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID);
        List<Long> campaignIds = this.workingTables.selectIds(Tables.CAMPAIGN.CLN_ID);
        this.reorderHelper.reorder(campaignIds, Tables.CAMPAIGN_TEST_PLAN_ITEM.CTPI_ID, (Field<Long>)Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID, (Field<Integer>)Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_PLAN_ORDER);
    }

    private void deleteTestPlanItems() {
        SelectConditionStep query = this.dslContext.selectDistinct((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID, (SelectField)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID).from((TableLike)Tables.WORK_DELETE_ENTITIES).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.WORK_DELETE_ENTITIES.ENTITY_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID).and(Tables.WORK_DELETE_ENTITIES.ENTITY_TYPE.eq((Object)Tables.TEST_PLAN_ITEM.getName()))).leftJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID)).where(Tables.WORK_DELETE_ENTITIES.OPERATION_ID.eq((Object)this.operationId));
        HashSet<Long> testPlanIds = new HashSet<Long>();
        HashSet<Long> suiteIds = new HashSet<Long>();
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream stream = query.fetchStream();){
            stream.forEach(record -> {
                testPlanIds.add((Long)record.value1());
                Long suiteId = (Long)record.value2();
                if (suiteId != null) {
                    suiteIds.add(suiteId);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.workingTables.delete(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID);
        this.workingTables.delete(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID);
        this.workingTables.delete(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID, Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID);
        this.reorderHelper.reorder(testPlanIds, Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (Field<Long>)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID, (Field<Integer>)Tables.TEST_PLAN_ITEM.ITEM_ORDER);
        this.reorderHelper.reorder((Collection<Long>)suiteIds, Tables.TEST_SUITE_TEST_PLAN_ITEM, (Field<Long>)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID, (Field<Long>)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID, (Field<Integer>)Tables.TEST_SUITE_TEST_PLAN_ITEM.TEST_PLAN_ORDER);
    }

    private void deleteDatasetsAndParameters() {
        this.workingTables.delete(Tables.DATASET.DATASET_ID, Tables.DATASET_PARAM_VALUE.DATASET_ID);
        this.workingTables.delete(Tables.DATASET.DATASET_ID, Tables.DATASET.DATASET_ID);
        this.workingTables.delete(Tables.TEST_CASE.TCLN_ID, Tables.PARAMETER.TEST_CASE_ID);
    }

    private void deleteCoverage() {
        this.workingTables.delete(Tables.TEST_STEP.TEST_STEP_ID, Tables.VERIFYING_STEPS.TEST_STEP_ID);
        this.workingTables.delete(Tables.TEST_CASE.TCLN_ID, Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID);
    }

    private void deleteTestCaseMilestones() {
        this.workingTables.delete(Tables.TEST_CASE.TCLN_ID, Tables.MILESTONE_TEST_CASE.TEST_CASE_ID);
        this.logDelete((Table<?>)Tables.MILESTONE_CAMPAIGN);
    }

    private void deleteSteps() {
        this.workingTables.delete(Tables.TEST_STEP.TEST_STEP_ID, Tables.ACTION_WORD_PARAMETER_VALUE.KEYWORD_TEST_STEP_ID);
        this.workingTables.delete(Tables.TEST_STEP.TEST_STEP_ID, Tables.TEST_CASE_STEPS.STEP_ID);
        this.workingTables.delete(Tables.TEST_STEP.TEST_STEP_ID, Tables.CALL_TEST_STEP.TEST_STEP_ID);
        this.workingTables.delete(Tables.TEST_STEP.TEST_STEP_ID, Tables.KEYWORD_TEST_STEP.TEST_STEP_ID);
        this.workingTables.delete(Tables.TEST_STEP.TEST_STEP_ID, Tables.ACTION_TEST_STEP.TEST_STEP_ID);
        this.workingTables.delete(Tables.TEST_STEP.TEST_STEP_ID, Tables.TEST_STEP.TEST_STEP_ID);
    }

    private void deleteRelationShips() {
        this.deleteRootRelationships();
        this.deleteNodeRelationships();
    }

    private void deleteTestAutomationCandidate() {
        this.workingTables.delete(Tables.TEST_CASE.TCLN_ID, Tables.TEST_AUTOMATION_CANDIDATE.TEST_CASE_ID);
        this.logDelete((Table<?>)Tables.TEST_AUTOMATION_CANDIDATE);
    }

    private void deleteRootRelationships() {
        Set parentLibraryIds = this.dslContext.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID).from((TableLike)Tables.WORK_DELETE_ENTITIES).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_CONTENT).on(Tables.WORK_DELETE_ENTITIES.ENTITY_ID.eq((Field)Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID)).where(Tables.WORK_DELETE_ENTITIES.ENTITY_TYPE.eq((Object)Tables.TEST_CASE_LIBRARY_NODE.getName()).and(Tables.WORK_DELETE_ENTITIES.OPERATION_ID.eq((Object)this.operationId))).fetchSet((Field)Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID);
        if (parentLibraryIds.isEmpty()) {
            return;
        }
        this.workingTables.delete(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID);
        this.reorderHelper.reorder(parentLibraryIds, Tables.TEST_CASE_LIBRARY_CONTENT);
        this.logDelete((Table<?>)Tables.TEST_CASE_LIBRARY_CONTENT);
    }

    private void deleteNodeRelationships() {
        Set<Long> parentIds = this.getAncestorsOfDeletedNodes();
        this.workingTables.delete(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TCLN_RELATIONSHIP.ANCESTOR_ID);
        this.workingTables.delete(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TCLN_RELATIONSHIP.DESCENDANT_ID);
        this.logDelete((Table<?>)Tables.TCLN_RELATIONSHIP);
        if (!parentIds.isEmpty()) {
            this.reorderHelper.reorder((Collection<Long>)parentIds, Tables.TCLN_RELATIONSHIP);
        }
    }

    private Set<Long> getAncestorsOfDeletedNodes() {
        WorkDeleteEntities deletedAncestor = Tables.WORK_DELETE_ENTITIES.as("deleted_ancestor");
        return this.dslContext.selectDistinct((SelectField)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID).from((TableLike)Tables.WORK_DELETE_ENTITIES).innerJoin((TableLike)Tables.TCLN_RELATIONSHIP).on(Tables.WORK_DELETE_ENTITIES.ENTITY_ID.eq((Field)Tables.TCLN_RELATIONSHIP.DESCENDANT_ID)).where(Tables.WORK_DELETE_ENTITIES.ENTITY_TYPE.eq((Object)Tables.TEST_CASE_LIBRARY_NODE.getName()).and(Tables.WORK_DELETE_ENTITIES.OPERATION_ID.eq((Object)this.operationId)).and(DSL.notExists((Select)DSL.selectOne().from((TableLike)deletedAncestor).where(deletedAncestor.ENTITY_ID.eq((Field)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID).and(deletedAncestor.OPERATION_ID.eq((Object)this.operationId)).and(deletedAncestor.ENTITY_TYPE.eq((Object)Tables.TEST_CASE_LIBRARY_NODE.getName())))))).fetchSet((Field)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID);
    }

    private void deleteNodes() {
        this.workingTables.delete(Tables.TEST_CASE.TCLN_ID, Tables.KEYWORD_TEST_CASE.TCLN_ID);
        this.workingTables.delete(Tables.TEST_CASE.TCLN_ID, Tables.EXPLORATORY_TEST_CASE.TCLN_ID);
        this.workingTables.delete(Tables.TEST_CASE.TCLN_ID, Tables.SCRIPTED_TEST_CASE.TCLN_ID);
        this.workingTables.delete(Tables.TEST_CASE.TCLN_ID, Tables.TEST_CASE.TCLN_ID);
        this.workingTables.delete(Tables.TEST_CASE_FOLDER.TCLN_ID, Tables.TEST_CASE_FOLDER.TCLN_ID);
        this.workingTables.delete(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID);
        this.workingTables.delete(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID);
    }

    private void deleteAutomationRequests() {
        this.workingTables.delete(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID, Tables.AUTOMATION_REQUEST_LIBRARY_CONTENT.CONTENT_ID);
        this.workingTables.delete(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID, Tables.REMOTE_AUTOMATION_REQUEST_EXTENDER.AUTOMATION_REQUEST_ID);
        this.workingTables.delete(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID, Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID);
    }

    private void nullify() {
        this.nullifyTestPlanItems();
        this.nullifyExecutions();
    }

    private void nullifyTestPlanItems() {
        Table testPlanItemTable = DSL.selectDistinct((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID).from((TableLike)Tables.WORK_DELETE_ENTITIES).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.WORK_DELETE_ENTITIES.ENTITY_ID.eq((Field)Tables.TEST_PLAN_ITEM.TCLN_ID).and(Tables.WORK_DELETE_ENTITIES.ENTITY_TYPE.eq((Object)Tables.TEST_CASE.getName()))).where(Tables.WORK_DELETE_ENTITIES.OPERATION_ID.eq((Object)this.operationId).andExists((Select)DSL.selectOne().from((TableLike)Tables.EXECUTION).where(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)))).asTable("tmp_safe_test_plan_items");
        JooqUpdateHelper.nullifyColumnsWithJoin(this.dslContext, testPlanItemTable, Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(testPlanItemTable.field("TEST_PLAN_ITEM_ID", Long.class)), Tables.TEST_PLAN_ITEM.TCLN_ID, Tables.TEST_PLAN_ITEM.DATASET_ID);
    }

    private void nullifyExecutions() {
        this.nullify(Tables.TEST_CASE.TCLN_ID, Tables.EXECUTION.TCLN_ID);
        this.nullify(Tables.TEST_STEP.TEST_STEP_ID, Tables.EXECUTION_STEP.TEST_STEP_ID);
    }

    private void storeEntitiesToDeleteIntoWorkingTable() {
        this.addLibraryNodes();
        this.addFolders();
        this.addTestCases();
        this.addTestAutomationCandidates();
        this.addTestSteps();
        this.addDatasets();
        this.addCampaigns();
        this.addTestPlanItems();
        this.addExploratorySessionOverview();
        this.addCustomFieldValues();
        this.addAttachmentList();
        this.addAutomationRequests();
    }

    private void addExploratorySessionOverview() {
        this.workingTables.addEntity(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID, () -> this.makeSelectJoin((TableField<?, Long>)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (TableField<?, Long>)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (TableField<?, Long>)Tables.TEST_PLAN_ITEM.OVERVIEW_ID, (Table<?>)Tables.EXPLORATORY_SESSION_OVERVIEW).where(Tables.TEST_PLAN_ITEM.OVERVIEW_ID.isNotNull()));
    }

    private void addLibraryNodes() {
        this.workingTables.addEntity(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, this::buildDeletableNodesQuery);
    }

    private void addFolders() {
        this.workingTables.addEntity(Tables.TEST_CASE_FOLDER.TCLN_ID, () -> this.makeSelectJoin(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TEST_CASE_FOLDER.TCLN_ID, Tables.TEST_CASE_FOLDER.TCLN_ID));
    }

    private Select<Record3<Long, String, String>> buildDeletableNodesQuery() {
        return TestCaseNodeScopeQueryHelper.buildTestCaseNodeScopeQuery(this.scope, this.makeSelectClause(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID), this.applyFilter());
    }

    private Select<Record1<Long>> buildSoftDeletableNodesQuery() {
        return TestCaseNodeScopeQueryHelper.buildTestCaseNodeScopeQuery(this.scope, DSL.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID), this.applyFilter());
    }

    private Condition applyFilter() {
        Condition condition = DSL.noCondition();
        if (this.isBinFilterEnabled) {
            condition = condition.and(ConditionsConstants.TCLN_IN_BIN);
        }
        if (!this.excludedIds.isEmpty()) {
            condition = condition.and(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.notIn(this.excludedIds));
        }
        return condition;
    }

    private void addTestCases() {
        this.workingTables.addEntity(Tables.TEST_CASE.TCLN_ID, () -> this.makeSelectJoin(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TEST_CASE.TCLN_ID, Tables.TEST_CASE.TCLN_ID));
    }

    private void addTestAutomationCandidates() {
        this.workingTables.addEntity(Tables.TEST_AUTOMATION_CANDIDATE.TEST_AUTOMATION_CANDIDATE_ID, () -> this.makeSelectJoin(Tables.TEST_CASE.TCLN_ID, Tables.TEST_AUTOMATION_CANDIDATE.TEST_CASE_ID, Tables.TEST_AUTOMATION_CANDIDATE.TEST_AUTOMATION_CANDIDATE_ID));
    }

    private void addTestPlanItems() {
        this.workingTables.addEntity(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, () -> this.makeSelectJoin(Tables.TEST_CASE.TCLN_ID, Tables.TEST_PLAN_ITEM.TCLN_ID, Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID).where(DSL.notExists((Select)DSL.selectOne().from((TableLike)Tables.EXECUTION).where(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)))));
    }

    private void addCampaigns() {
        this.workingTables.addEntity(Tables.CAMPAIGN.CLN_ID, () -> this.makeSelectJoin((TableField<?, Long>)Tables.TEST_CASE.TCLN_ID, (TableField<?, Long>)Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID, (TableField<?, Long>)Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID, (Table<?>)Tables.CAMPAIGN));
    }

    private void addAutomationRequests() {
        this.workingTables.addEntity(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID, () -> this.makeSelectJoin((TableField<?, Long>)Tables.TEST_CASE.TCLN_ID, (TableField<?, Long>)Tables.TEST_CASE.TCLN_ID, (TableField<?, Long>)Tables.TEST_CASE.AUTOMATION_REQUEST_ID, (Table<?>)Tables.AUTOMATION_REQUEST).where(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.isNotNull()));
    }

    private void addTestSteps() {
        this.workingTables.addEntity(Tables.TEST_STEP.TEST_STEP_ID, () -> this.makeSelectJoin((TableField<?, Long>)Tables.TEST_CASE.TCLN_ID, (TableField<?, Long>)Tables.TEST_CASE_STEPS.TEST_CASE_ID, (TableField<?, Long>)Tables.TEST_CASE_STEPS.STEP_ID, (Table<?>)Tables.TEST_STEP));
    }

    private void addDatasets() {
        this.workingTables.addEntity(Tables.DATASET.DATASET_ID, () -> this.makeSelectJoin(Tables.TEST_CASE.TCLN_ID, Tables.DATASET.TEST_CASE_ID, Tables.DATASET.DATASET_ID));
    }

    private void addCustomFieldValues() {
        this.workingTables.addEntity(Tables.CUSTOM_FIELD_VALUE.CFV_ID, () -> this.makeSelectCustomFieldValues(Tables.TEST_CASE.TCLN_ID, BindableEntity.TEST_CASE).union(this.makeSelectCustomFieldValues(Tables.TEST_STEP.TEST_STEP_ID, BindableEntity.TEST_STEP)).union(this.makeSelectCustomFieldValues(Tables.TEST_CASE_FOLDER.TCLN_ID, BindableEntity.TESTCASE_FOLDER)));
    }

    private void addAttachmentList() {
        this.workingTables.addEntity(Tables.ATTACHMENT_LIST.ATTACHMENT_LIST_ID, () -> this.makeSelectJoinAttachmentList(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TEST_CASE_LIBRARY_NODE.ATTACHMENT_LIST_ID).union(this.makeSelectJoinAttachmentList(Tables.TEST_STEP.TEST_STEP_ID, Tables.ACTION_TEST_STEP.TEST_STEP_ID, Tables.ACTION_TEST_STEP.ATTACHMENT_LIST_ID)).union(this.makeSelectJoinAttachmentList(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID, Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID, Tables.EXPLORATORY_SESSION_OVERVIEW.ATTACHMENT_LIST_ID)));
    }

    public OperationReport softDeleteNodes() {
        this.logStartProcess();
        this.clearPersistenceContext();
        Table deletebleNodeTable = this.buildSoftDeletableNodesQuery().asTable("soft_deletable_node");
        this.performSoftDeletions((Table<Record1<Long>>)deletebleNodeTable);
        OperationReport report = this.buildSoftDeleteOperationReport(deletebleNodeTable);
        this.logEndProcess();
        return report;
    }

    private void performSoftDeletions(Table<Record1<Long>> deletableNodeTable) {
        JooqUpdateHelper.updateColumnsWithJoin(this.dslContext, deletableNodeTable, Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(deletableNodeTable.field("TCLN_ID", Long.class)), Map.of(Tables.TEST_CASE_LIBRARY_NODE.DELETED_BY, UserContextHolder.getUsername(), Tables.TEST_CASE_LIBRARY_NODE.DELETED_ON, Timestamp.valueOf(LocalDateTime.now())));
        Condition notExecutedTestPlanItemCondition = Tables.TEST_PLAN_ITEM.TCLN_ID.eq(deletableNodeTable.field("TCLN_ID", Long.class)).andNotExists((Select)DSL.selectOne().from((TableLike)Tables.EXECUTION).where(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.EXECUTION.TCLN_ID)));
        JooqUpdateHelper.updateColumnsWithJoin(this.dslContext, deletableNodeTable, notExecutedTestPlanItemCondition, Map.of(Tables.TEST_PLAN_ITEM.DELETED, true));
    }

    private OperationReport buildSoftDeleteOperationReport(Table<?> deletebleNodeTable) {
        OperationReport report = new OperationReport();
        SelectOnConditionStep query = this.dslContext.select((SelectField)deletebleNodeTable.field("TCLN_ID", Long.class), (SelectField)Tables.TEST_CASE_FOLDER.TCLN_ID.isNotNull().as("IS_FOLDER")).from(deletebleNodeTable).leftJoin((TableLike)Tables.TEST_CASE_FOLDER).on(deletebleNodeTable.field("TCLN_ID", Long.class).eq((Field)Tables.TEST_CASE_FOLDER.TCLN_ID));
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream stream = query.fetchStream();){
            Map partitioned = stream.collect(Collectors.partitioningBy(tuple -> (Boolean)tuple.get("IS_FOLDER", Boolean.class), Collectors.mapping(tuple -> (Long)tuple.get("TCLN_ID", Long.class), Collectors.toList())));
            report.addRemoved(partitioned.getOrDefault(true, Collections.emptyList()), "folder");
            report.addRemoved(partitioned.getOrDefault(false, Collections.emptyList()), "test-case");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return report;
    }

    private void logStartProcess() {
        LOGGER.debug(String.format("Init deletion process of test case nodes. Scope %s. Operation:  %s", this.scope.summary(), this.operationId), new Object[0]);
    }

    private void logEndProcess() {
        LOGGER.info(String.format("Deleted test case nodes in scope %s. Time elapsed %s", this.scope.summary(), this.startDate.until(LocalDateTime.now(), ChronoUnit.MILLIS)), new Object[0]);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

