/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectOrderByStep;
import org.jooq.SelectSeekStep1;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.deletion.RequirementDeletionNode;
import org.squashtest.tm.service.internal.repository.RequirementDeletionDao;
import org.squashtest.tm.service.internal.repository.hibernate.AbstractHibernateDeletionDao;

@Repository
public class HibernateRequirementDeletionDao
extends AbstractHibernateDeletionDao
implements RequirementDeletionDao {
    private static final String CHILD_TYPE = "CHILD_TYPE";

    public HibernateRequirementDeletionDao(DSLContext dsl) {
        super(dsl);
    }

    @Override
    public void removeEntities(List<Long> entityIds) {
        throw new UnsupportedOperationException("No longer supported");
    }

    @Override
    public Map<String, List<Long>> separateFolderFromRequirementIds(List<Long> originalIds) {
        Field typeField = DSL.when((Condition)Tables.REQUIREMENT_FOLDER.RLN_ID.isNotNull(), (Object)"folderIds").otherwise((Object)"nodeIds");
        return this.dsl.select((SelectField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, (SelectField)typeField).from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).leftJoin((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.in(originalIds)).groupBy(new GroupField[]{Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, Tables.REQUIREMENT_FOLDER.RLN_ID}).fetchGroups(typeField, (Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID);
    }

    @Override
    public List<Long> filterRequirementsIdsWhichMilestonesForbidsDeletion(List<Long> requirementIds) {
        if (!requirementIds.isEmpty()) {
            MilestoneStatus[] blockingStatuses = new MilestoneStatus[MilestoneStatus.MILESTONE_BLOCKING_STATUSES.size()];
            MilestoneStatus.MILESTONE_BLOCKING_STATUSES.toArray(blockingStatuses);
            return this.em.createQuery("select distinct r.id from Requirement r\ninner join r.versions v\ninner join v.milestones lockedMilestones\nwhere r.id in (:requirementIds) and lockedMilestones.status in (:lockedStatuses)", Long.class).setParameter("requirementIds", requirementIds).setParameter("lockedStatuses", Arrays.asList(blockingStatuses)).getResultList();
        }
        return new ArrayList<Long>(0);
    }

    @Override
    public List<Long> filterRequirementHavingMultipleMilestones(List<Long> requirementIds) {
        if (requirementIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.em.createQuery("select r.id from Requirement r\njoin r.versions v\njoin v.milestones stones\nwhere r.id in (:requirementIds)\ngroup by r.id, v.id\nhaving count(stones) > 1", Long.class).setParameter("requirementIds", requirementIds).getResultList();
    }

    @Override
    public List<Long> findVersionIdsForMilestone(List<Long> requirementIds, Long milestoneId) {
        if (!requirementIds.isEmpty()) {
            return this.em.createQuery("select v.id from Requirement r\njoin r.versions v\njoin v.milestones m\nwhere r.id in (:nodeIds) and m.id = :milestoneId", Long.class).setParameter("nodeIds", requirementIds).setParameter("milestoneId", (Object)milestoneId).getResultList();
        }
        return new ArrayList<Long>(0);
    }

    @Override
    public void unbindFromMilestone(List<Long> requirementIds, Long milestoneId) {
        if (requirementIds.isEmpty()) {
            return;
        }
        this.em.createNativeQuery("delete from MILESTONE_REQ_VERSION\nwhere MILESTONE_ID = :milestoneId\nand REQ_VERSION_ID in (select v.RES_ID from REQUIREMENT_VERSION v where v.REQUIREMENT_ID in :requirementIds)", Long.class).setParameter("requirementIds", requirementIds).setParameter("milestoneId", (Object)milestoneId).executeUpdate();
    }

    @Override
    public Map<Long, List<EntityReference>> findRecursiveContentsIdsByNodeIds(Collection<Long> nodeIds) {
        if (nodeIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Field nodeTypeField = DSL.when((Condition)Tables.REQUIREMENT_FOLDER.RLN_ID.isNotNull(), (Object)EntityType.REQUIREMENT_FOLDER.name()).otherwise((Object)EntityType.REQUIREMENT.name()).as("ENTITY_TYPE");
        CommonTableExpression cte = DSL.name((String)"TCLN_HIERARCHY").fields("ANCESTOR_ID", "DESCENDANT_ID", "ENTITY_TYPE", "CONTENT_ORDER").as((ResultQuery)DSL.select((SelectField)Tables.RLN_RELATIONSHIP.ANCESTOR_ID, (SelectField)Tables.RLN_RELATIONSHIP.DESCENDANT_ID, (SelectField)nodeTypeField, (SelectField)Tables.RLN_RELATIONSHIP.CONTENT_ORDER).from((TableLike)Tables.RLN_RELATIONSHIP).leftJoin((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.RLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).where(Tables.RLN_RELATIONSHIP.ANCESTOR_ID.in(nodeIds)).union((Select)DSL.select((SelectField)Tables.RLN_RELATIONSHIP.ANCESTOR_ID, (SelectField)Tables.RLN_RELATIONSHIP.DESCENDANT_ID, (SelectField)nodeTypeField, (SelectField)Tables.RLN_RELATIONSHIP.CONTENT_ORDER).from(DSL.name((String)"TCLN_HIERARCHY")).innerJoin((TableLike)Tables.RLN_RELATIONSHIP).on(DSL.field((Name)DSL.name((String[])new String[]{"TCLN_HIERARCHY", "DESCENDANT_ID"})).eq((Object)Tables.RLN_RELATIONSHIP.ANCESTOR_ID)).leftJoin((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.RLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID))));
        SelectSeekStep1 query = this.dsl.withRecursive(new CommonTableExpression[]{cte}).selectFrom((TableLike)cte).orderBy((OrderField)DSL.field((String)"CONTENT_ORDER"));
        Throwable throwable = null;
        Object var6_7 = null;
        try (Stream stream = query.fetchStream();){
            return stream.collect(Collectors.groupingBy(r -> (Long)r.get("ANCESTOR_ID", Long.class), Collectors.mapping(r -> new EntityReference(EntityType.valueOf((String)((String)r.get("ENTITY_TYPE", String.class))), (Long)r.get("DESCENDANT_ID", Long.class)), Collectors.toList())));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public List<RequirementDeletionNode> findParentNode(Collection<Long> nodeIds) {
        Field nodeTypeField = DSL.when((Condition)Tables.REQUIREMENT_FOLDER.RLN_ID.isNotNull(), (Object)EntityType.REQUIREMENT_FOLDER.name()).otherwise((Object)EntityType.REQUIREMENT.name()).as("ENTITY_TYPE");
        SelectOrderByStep query = this.dsl.select((SelectField)Tables.RLN_RELATIONSHIP.ANCESTOR_ID, (SelectField)nodeTypeField, (SelectField)Tables.RLN_RELATIONSHIP.DESCENDANT_ID, (SelectField)DSL.when((Condition)Tables.REQUIREMENT.RLN_ID.isNotNull(), (Object)EntityType.REQUIREMENT.name()).otherwise((Object)EntityType.REQUIREMENT_FOLDER.name()).as(CHILD_TYPE)).from((TableLike)Tables.RLN_RELATIONSHIP).leftJoin((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.RLN_RELATIONSHIP.ANCESTOR_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).leftJoin((TableLike)Tables.REQUIREMENT).on(Tables.RLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).where(Tables.RLN_RELATIONSHIP.DESCENDANT_ID.in(nodeIds)).union((Select)DSL.select((SelectField)Tables.REQUIREMENT_LIBRARY_CONTENT.LIBRARY_ID.as("ANCESTOR_ID"), (SelectField)DSL.val((String)EntityType.REQUIREMENT_LIBRARY.name()).as("ENTITY_TYPE"), (SelectField)Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ID.as("DESCENDANT_ID"), (SelectField)nodeTypeField.as(CHILD_TYPE)).from((TableLike)Tables.REQUIREMENT_LIBRARY_CONTENT).leftJoin((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).where(Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ID.in(nodeIds)));
        HashSet parents = new HashSet();
        ArrayList<RequirementDeletionNode> nodes = new ArrayList<RequirementDeletionNode>(nodeIds.size());
        Throwable throwable = null;
        Object var7_8 = null;
        try (Stream stream = query.fetchStream();){
            stream.forEach(record -> {
                RequirementDeletionNode parent = this.getOrCreateParent(parents, (Long)record.get("ANCESTOR_ID", Long.class), EntityType.valueOf((String)((String)record.get("ENTITY_TYPE", String.class))));
                nodes.add(new RequirementDeletionNode((Long)record.get("DESCENDANT_ID", Long.class), parent, EntityType.valueOf((String)((String)record.get(CHILD_TYPE, String.class)))));
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return nodes;
    }

    @Override
    public void deleteOrphanLinks(List<Long> orphans) {
        if (orphans.isEmpty()) {
            return;
        }
        this.dsl.deleteFrom((Table)Tables.RLN_RELATIONSHIP).where(Tables.RLN_RELATIONSHIP.DESCENDANT_ID.in(orphans)).execute();
        this.dsl.deleteFrom((Table)Tables.RLN_RELATIONSHIP_CLOSURE).where(Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.in(orphans)).execute();
    }

    private RequirementDeletionNode getOrCreateParent(Set<RequirementDeletionNode> parents, Long id, EntityType type) {
        for (RequirementDeletionNode node : parents) {
            if (!node.getId().equals(id) || !node.getType().equals((Object)type)) continue;
            return node;
        }
        RequirementDeletionNode parent = new RequirementDeletionNode(id, type);
        parents.add(parent);
        return parent;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Long[]> findPairedNodeHierarchy(List<Long> nodeIds) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<Long> findNodeHierarchy(List<Long> nodeIds) {
        return this.dsl.selectDistinct((SelectField)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, (SelectField)Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH).from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).where(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(nodeIds).and(Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.notEqual((Object)0))).orderBy((OrderField)Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH).fetch((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID);
    }
}

