/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.plugin;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.plugin.ConfigurablePlugin;
import org.squashtest.tm.api.plugin.EntityReference;
import org.squashtest.tm.api.plugin.EntityType;
import org.squashtest.tm.api.plugin.PluginValidationException;
import org.squashtest.tm.api.template.TemplateConfigurablePlugin;
import org.squashtest.tm.api.wizard.SynchronisationPlugin;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.project.GenericLibrary;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.LibraryPluginBinding;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.synchronisation.SynchronisationKind;
import org.squashtest.tm.exception.sync.SynchronizedFieldException;
import org.squashtest.tm.service.internal.display.dto.ProjectPluginDto;
import org.squashtest.tm.service.internal.plugin.ConfigurablePluginBinding;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.internal.utils.JSONUtils;
import org.squashtest.tm.service.plugin.ConfigurablePluginManager;
import org.squashtest.tm.service.project.GenericProjectFinder;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.templateplugin.TemplateConfigurablePluginBindingService;

@Service
@Transactional
public class ConfigurablePluginManagerImpl
implements ConfigurablePluginManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurablePluginManagerImpl.class);
    private final GenericProjectFinder projectFinder;
    private final GenericProjectManagerService projectManager;
    private final TemplateConfigurablePluginBindingService templateConfigurablePluginBindingService;
    private final GenericProjectDao genericProjectDao;
    private final RequirementVersionDao requirementVersionDao;
    @Autowired(required=false)
    private final List<SynchronisationPlugin> syncPlugins = Collections.emptyList();
    @Autowired(required=false)
    private final Collection<ConfigurablePlugin> configurablePlugins = Collections.emptyList();
    @Autowired(required=false)
    private final Collection<TemplateConfigurablePlugin> templatePlugins = Collections.emptyList();

    public ConfigurablePluginManagerImpl(GenericProjectFinder projectFinder, GenericProjectManagerService projectManager, TemplateConfigurablePluginBindingService templateConfigurablePluginBindingService, GenericProjectDao genericProjectDao, RequirementVersionDao requirementVersionDao) {
        this.projectFinder = projectFinder;
        this.projectManager = projectManager;
        this.templateConfigurablePluginBindingService = templateConfigurablePluginBindingService;
        this.genericProjectDao = genericProjectDao;
        this.requirementVersionDao = requirementVersionDao;
    }

    @Override
    public boolean isPluginBindingValid(String pluginId, long projectId) {
        ConfigurablePlugin configurablePlugin = this.findByIdOrThrow(pluginId);
        EntityReference context = new EntityReference(EntityType.PROJECT, Long.valueOf(projectId));
        return this.isPluginValid(configurablePlugin, context);
    }

    @Override
    public List<ProjectPluginDto> getAvailablePlugins(long projectId) {
        boolean isTemplate = this.projectManager.isProjectTemplate(projectId);
        return this.toPluginDtos(projectId, this.getBindings(projectId), isTemplate);
    }

    private List<ProjectPluginDto> toPluginDtos(long projectId, Collection<ConfigurablePluginBinding> pluginBindings, boolean isTemplate) {
        return IntStream.range(0, pluginBindings.size()).mapToObj(index -> this.toPluginDto(projectId, (ConfigurablePluginBinding)Iterables.get((Iterable)pluginBindings, (int)index), index + 1, isTemplate)).toList();
    }

    private ProjectPluginDto toPluginDto(Long projectId, ConfigurablePluginBinding pluginBinding, int pluginIndex, boolean isTemplate) {
        EntityReference context = new EntityReference(EntityType.PROJECT, projectId);
        ProjectPluginDto projectPluginDto = new ProjectPluginDto(pluginBinding.plugin());
        projectPluginDto.setIndex(pluginIndex);
        projectPluginDto.setEnabled(pluginBinding.isActive());
        boolean hasValidConfiguration = pluginBinding.hasConfiguration() && this.isPluginValid(pluginBinding.plugin(), context);
        projectPluginDto.setHasValidConfiguration(hasValidConfiguration);
        this.updateConfigUrl(pluginBinding.plugin(), isTemplate, context, projectPluginDto);
        return projectPluginDto;
    }

    private void updateConfigUrl(ConfigurablePlugin plugin, boolean isTemplate, EntityReference context, ProjectPluginDto projectPluginDto) {
        if (isTemplate) {
            Optional<TemplateConfigurablePlugin> templatePlugin = this.findTemplatePlugin(plugin.getId());
            templatePlugin.ifPresent(templateConfigurablePlugin -> projectPluginDto.setConfigUrl(templateConfigurablePlugin.getTemplateConfigurationPath(context)));
        } else {
            projectPluginDto.setConfigUrl(plugin.getConfigurationPath(context));
        }
    }

    private Optional<TemplateConfigurablePlugin> findTemplatePlugin(String pluginId) {
        return this.templatePlugins.stream().filter(tp -> tp.getId().equals(pluginId)).findFirst();
    }

    private boolean isPluginValid(ConfigurablePlugin plugin, EntityReference context) {
        try {
            plugin.validate(context);
            return true;
        }
        catch (PluginValidationException ex) {
            LOGGER.debug("Plugin validation failed for plugin '{}'", new Object[]{plugin.getName(), ex});
            return false;
        }
    }

    public Collection<ConfigurablePluginBinding> getBindings(long projectId) {
        return this.configurablePlugins.stream().map(plugin -> new ConfigurablePluginBinding((ConfigurablePlugin)plugin, projectId, this.isActive((ConfigurablePlugin)plugin, projectId), this.hasConfiguration((ConfigurablePlugin)plugin, projectId))).toList();
    }

    @Override
    public Optional<ConfigurablePlugin> findById(String pluginId) {
        return this.configurablePlugins.stream().filter(plugin -> plugin.getId().equals(pluginId)).findFirst();
    }

    private ConfigurablePlugin findByIdOrThrow(String pluginId) {
        return this.findById(pluginId).orElseThrow(() -> new IllegalArgumentException("Could not find plugin with ID " + pluginId));
    }

    private boolean isActive(ConfigurablePlugin plugin, long projectId) {
        GenericLibrary<? extends LibraryNode> library = this.findLibrary(projectId, plugin.getConfiguringWorkspace());
        LibraryPluginBinding binding = library.getPluginBinding(plugin.getId());
        return binding != null && binding.getActive() != false;
    }

    private boolean hasConfiguration(ConfigurablePlugin plugin, long projectId) {
        return this.projectManager.pluginHasConfigurationOrSynchronisations(plugin, projectId);
    }

    private GenericLibrary<? extends LibraryNode> findLibrary(long projectId, WorkspaceType workspace) {
        GenericProject project = this.projectFinder.findById(projectId);
        return switch (workspace) {
            case WorkspaceType.TEST_CASE_WORKSPACE -> project.getTestCaseLibrary();
            case WorkspaceType.REQUIREMENT_WORKSPACE -> project.getRequirementLibrary();
            case WorkspaceType.CAMPAIGN_WORKSPACE -> project.getCampaignLibrary();
            default -> throw new IllegalArgumentException("WorkspaceType " + String.valueOf(workspace) + " is unknown and not covered by this class");
        };
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void disableConfigurablePlugin(String pluginId, long projectId, Boolean saveConf) {
        ConfigurablePlugin plugin = this.findByIdOrThrow(pluginId);
        List workspaceTypes = plugin.getWorkspaces();
        if (Boolean.TRUE.equals(saveConf)) {
            this.projectManager.disablePluginAndKeepConfiguration(projectId, workspaceTypes, plugin.getId());
            this.projectManager.disableSynchronisations(projectId, pluginId);
        } else {
            if (pluginId.equals(SynchronisationKind.AUTOM_JIRA.getName())) {
                this.projectManager.deleteAllRemoteAutomationRequestExtenders(projectId);
            }
            boolean isProjectBound = this.templateConfigurablePluginBindingService.isProjectConfigurationBoundToTemplate(projectId);
            boolean isProjectTemplate = this.projectManager.isProjectTemplate(projectId);
            if (isProjectTemplate) {
                this.projectManager.disablePluginAndRemoveConfiguration(projectId, workspaceTypes, pluginId);
                this.projectManager.synchronizeBoundPluginConfigurations(projectId, pluginId);
            } else if (isProjectBound) {
                this.projectManager.disablePluginAndKeepConfiguration(projectId, workspaceTypes, pluginId);
                this.projectManager.removeSynchronisations(projectId, pluginId);
            } else {
                this.projectManager.disablePluginAndRemoveConfiguration(projectId, workspaceTypes, pluginId);
                this.projectManager.removeSynchronisations(projectId, pluginId);
            }
        }
    }

    @Override
    @Transactional(noRollbackFor={SynchronizedFieldException.class})
    public void checkIfFieldIsSynchronized(RequirementVersion requirementVersion, String fieldName) {
        if (Objects.isNull(requirementVersion)) {
            return;
        }
        if (requirementVersion.getRequirement().isSynchronizedInCurrentPerimeter()) {
            String syncKind = requirementVersion.getRequirement().getSyncExtender().getRemoteSynchronisation().getKind();
            String attributeMappingsJson = this.getAttributeMappingsOrPluginDefault(requirementVersion.getProject().getId(), syncKind);
            if (Objects.isNull(attributeMappingsJson)) {
                return;
            }
            Iterator<JsonNode> attributeMappingNodes = JSONUtils.getElementsFromJsonArray(attributeMappingsJson);
            attributeMappingNodes.forEachRemaining(attributeMapping -> {
                if (fieldName.equals(attributeMapping.get("squashField").asText())) {
                    throw new SynchronizedFieldException(fieldName + " field can only be updated by synchronization.");
                }
            });
        }
    }

    @Override
    public void checkIfFieldIsSynchronized(Long requirementVersionId, String fieldName) {
        RequirementVersion requirementVersion = (RequirementVersion)this.requirementVersionDao.getReferenceById(requirementVersionId);
        this.checkIfFieldIsSynchronized(requirementVersion, fieldName);
    }

    @Override
    public String getAttributeMappingsOrPluginDefault(Long projectId, String syncPluginId) {
        if (!this.isPluginFoundAndActivated(projectId, syncPluginId)) {
            return null;
        }
        Map<String, String> pluginConfiguration = this.projectManager.getPluginConfiguration(projectId, WorkspaceType.REQUIREMENT_WORKSPACE, syncPluginId);
        String attributeMappings = pluginConfiguration.get("attributeMappings");
        if (Objects.nonNull(attributeMappings)) {
            return attributeMappings;
        }
        SynchronisationPlugin plugin = this.getSyncPlugin(syncPluginId);
        return plugin.getDefaultAttributeMappings();
    }

    private SynchronisationPlugin getSyncPlugin(String syncPluginId) {
        SynchronisationPlugin plugin = this.syncPlugins.stream().filter(syncPlugin -> syncPlugin.getId().equals(syncPluginId)).findFirst().orElse(null);
        if (Objects.isNull(plugin)) {
            throw new PluginValidationException("Plugin " + syncPluginId + " not found.");
        }
        return plugin;
    }

    @Override
    public boolean isPluginFoundAndActivated(Long projectId, String syncPluginId) {
        Optional<ConfigurablePlugin> optionalPlugin = this.findById(syncPluginId);
        if (optionalPlugin.isEmpty()) {
            return false;
        }
        GenericProject project = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        RequirementLibrary requirementLibrary = project.getRequirementLibrary();
        return requirementLibrary.isPluginEnabled(syncPluginId);
    }

    @Override
    public Map<String, String> fetchValueMappingsByNode(long projectId, String syncPluginId, String nodeName) {
        String yamlString = this.getValueMappingsOrPluginDefault(projectId, syncPluginId);
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            JsonNode rootNode = mapper.readTree(yamlString);
            JsonNode node = rootNode.path(nodeName);
            HashMap<String, String> mappedValueMap = new HashMap<String, String>();
            node.fields().forEachRemaining(field -> {
                String string = mappedValueMap.put((String)field.getKey(), ((JsonNode)field.getValue()).asText());
            });
            return mappedValueMap;
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Cannot parse the mapped values from plugin YAML configuration", (Throwable)e);
            return new HashMap<String, String>();
        }
    }

    private String getValueMappingsOrPluginDefault(long projectId, String syncPluginId) {
        if (!this.isPluginFoundAndActivated(projectId, syncPluginId)) {
            LOGGER.warn("Plugin with id {} not found or inactive for projectId={}", new Object[]{syncPluginId, projectId});
            return "";
        }
        Map<String, String> pluginConfiguration = this.projectManager.getPluginConfiguration(projectId, WorkspaceType.REQUIREMENT_WORKSPACE, syncPluginId);
        String valueMappings = pluginConfiguration.get("valuesMapping");
        if (Objects.nonNull(valueMappings)) {
            return valueMappings;
        }
        SynchronisationPlugin plugin = this.getSyncPlugin(syncPluginId);
        return plugin.getDefaultValueMappings();
    }
}

