/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.ServersPivot;
import org.squashtest.tm.service.internal.jooq.SubElementRecordProcessor;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.AbstractPivotDao;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.EntityBindingField;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.ServerPivotDao;

@Repository
public class ServerPivotDaoImpl
extends AbstractPivotDao<ServersPivot>
implements ServerPivotDao {
    ServerPivotDaoImpl(DSLContext dsl, AdminPivotConverterService adminPivotConverterService) {
        super(dsl, adminPivotConverterService);
    }

    @Override
    public boolean hasServerBindingByProjectId(Long projectId) {
        return this.dsl.fetchExists((Select)this.dsl.selectOne().from((TableLike)Tables.PROJECT).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).and(Tables.PROJECT.BUGTRACKER_ID.isNotNull()));
    }

    private ResultQuery<? extends Record> getServerQueryByProjectId(Long projectId) {
        return this.dsl.select((SelectField)Tables.THIRD_PARTY_SERVER.SERVER_ID, (SelectField)Tables.BUGTRACKER.KIND, (SelectField)Tables.THIRD_PARTY_SERVER.NAME, (SelectField)Tables.THIRD_PARTY_SERVER.URL).from((TableLike)Tables.THIRD_PARTY_SERVER).join((TableLike)Tables.BUGTRACKER).on(Tables.BUGTRACKER.BUGTRACKER_ID.eq((Field)Tables.THIRD_PARTY_SERVER.SERVER_ID)).join((TableLike)Tables.PROJECT).on(Tables.PROJECT.BUGTRACKER_ID.eq((Field)Tables.BUGTRACKER.BUGTRACKER_ID)).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId));
    }

    @Override
    public void getServerByProjectId(Long projectId, Consumer<ServersPivot> consumer) {
        this.convertRecordAndWritingPivot(this.getServerQueryByProjectId(projectId), projectId, EntityBindingField.SERVER, consumer, attachmentPivot -> {});
    }

    @Override
    protected ServersPivot getNewPivotObject(Record record, Long projectId, EntityBindingField entityBindingField) {
        return this.adminPivotConverterService.recordToServerPivot(record);
    }

    @Override
    protected void fillPivotObject(ServersPivot pivotObject, Record record) {
    }

    @Override
    protected List<SubElementRecordProcessor<? extends AbstractPivotObject>> getSubElementRecordProcessors(Long projectId, EntityBindingField entityBindingField) {
        return List.of();
    }

    @Override
    protected void appendSubElementsToPivotObject(ServersPivot pivotObject, Map<Class<? extends AbstractPivotObject>, List<? extends AbstractPivotObject>> subElementsByClazz, Consumer<AttachmentPivot> writingAttachmentConsumer) {
    }
}

