/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.trash;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.display.trash.TestCaseBinService;
import org.squashtest.tm.service.internal.deletion.NodeScope;
import org.squashtest.tm.service.internal.deletion.NodeScopeFactory;
import org.squashtest.tm.service.internal.deletion.restoration.testcase.JdbcTestCaseNodeRestorationFactory;
import org.squashtest.tm.service.internal.repository.hibernate.TestCaseBinDao;
import org.squashtest.tm.service.internal.testcase.TestCaseNodeDeletionHandler;
import org.squashtest.tm.service.project.CustomProjectFinder;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
@Transactional
public class TestCaseBinServiceImpl
implements TestCaseBinService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCaseBinServiceImpl.class);
    private static final String RESTORATION = "Restoration";
    private static final String HARD_DELETION = "Hard deletion";
    private final PermissionEvaluationService permissionEvaluationService;
    private final TestCaseNodeDeletionHandler deletionHandler;
    private final TestCaseBinDao testCaseBinDao;
    private final CustomProjectFinder projectFinder;
    private final NodeScopeFactory nodeScopeFactory;
    private final JdbcTestCaseNodeRestorationFactory restorationFactory;

    public TestCaseBinServiceImpl(PermissionEvaluationService permissionEvaluationService, TestCaseNodeDeletionHandler deletionHandler, TestCaseBinDao testCaseBinDao, CustomProjectFinder projectFinder, NodeScopeFactory nodeScopeFactory, JdbcTestCaseNodeRestorationFactory restorationFactory) {
        this.permissionEvaluationService = permissionEvaluationService;
        this.deletionHandler = deletionHandler;
        this.testCaseBinDao = testCaseBinDao;
        this.projectFinder = projectFinder;
        this.nodeScopeFactory = nodeScopeFactory;
        this.restorationFactory = restorationFactory;
    }

    @Override
    public List<String> emptyBin() {
        List<Long> projectIds = this.getManageableProjectIds();
        LOGGER.info("Test case bin emptying initiated by user '{}'", new Object[]{UserContextHolder.getUsername()});
        if (projectIds.isEmpty()) {
            return List.of();
        }
        Set<NodeReference> references = this.getProjectReferences(projectIds);
        OperationReport report = this.deletionHandler.hardDeleteNodes(NodeScope.of(references));
        LOGGER.info("Emptied test case bin, hard deleted {} nodes.", new Object[]{report.getRemoved().size()});
        return references.stream().map(NodeReference::toNodeId).toList();
    }

    private Set<NodeReference> getProjectReferences(List<Long> projectIds) {
        List<Long> testCaseLibraryIds = this.testCaseBinDao.findLibraryIdsByProjectIds(projectIds);
        return testCaseLibraryIds.stream().map(id -> new NodeReference(NodeType.TEST_CASE_LIBRARY, id)).collect(Collectors.toSet());
    }

    private List<Long> getManageableProjectIds() {
        List<Long> projectIds = this.projectFinder.findAllManageableIds();
        boolean isAdmin = this.permissionEvaluationService.hasRole("ROLE_ADMIN");
        if (projectIds.isEmpty() && !isAdmin) {
            throw new AccessDeniedException("Access denied: user '" + UserContextHolder.getUsername() + "' does not have the rights to empty the bin.");
        }
        return projectIds;
    }

    @Override
    public int countRestorableNodes(List<String> scopes) {
        NodeScope scope = this.buildNodeScope(scopes);
        return this.testCaseBinDao.countRestorableNodes(scope);
    }

    @Override
    public int countDeletedNodes(List<String> scopes) {
        NodeScope scope = this.buildNodeScope(scopes);
        return this.testCaseBinDao.countDeletableNodes(scope);
    }

    @Override
    public List<String> restoreDeletedNodes(List<String> scopes) {
        NodeScope scope = this.buildNodeScopeForOperation(scopes, RESTORATION);
        OperationReport report = this.restorationFactory.build(scope).restoreNodes();
        LOGGER.info("Restored {} nodes, {} renames.", new Object[]{report.getRestored().size(), report.getRenamed().size()});
        return this.findAncestorsToRefresh(scope, true);
    }

    @Override
    public List<String> hardDeleteNodes(List<String> scopes) {
        NodeScope scope = this.buildNodeScopeForOperation(scopes, HARD_DELETION);
        NodeScope parentScope = this.retrieveParentNodeScope(scope);
        OperationReport report = this.deletionHandler.hardDeleteNodes(scope);
        LOGGER.info("Hard deleted {} test case nodes.", new Object[]{report.getRemoved().size()});
        return this.findAncestorsToRefresh(parentScope, false);
    }

    private NodeScope retrieveParentNodeScope(NodeScope scope) {
        Set<NodeReference> parents = this.testCaseBinDao.getParentReferences(scope.getNodeIds());
        Set libraries = scope.getLibraryIds().stream().map(library -> new NodeReference(NodeType.TEST_CASE_LIBRARY, library)).collect(Collectors.toSet());
        parents.addAll(libraries);
        return this.nodeScopeFactory.fromNodeReferences(parents);
    }

    private List<String> findAncestorsToRefresh(NodeScope scope, boolean isRestore) {
        Set<Long> nodeIds = scope.getNodeIds();
        Map<Long, Long> ancestorHavingDeletedNodeByNodeId = this.testCaseBinDao.findFirstAncestorsWithDeletedDescendants(nodeIds, isRestore);
        Set<Long> nodesWithAncestorHavingDeletedNodes = ancestorHavingDeletedNodeByNodeId.keySet();
        List<Long> nodesWithoutAncestorHavingDeletedNodes = nodeIds.stream().filter(id -> !nodesWithAncestorHavingDeletedNodes.contains(id)).toList();
        HashSet<Long> libraryIds = new HashSet<Long>(scope.getLibraryIds());
        if (!nodesWithoutAncestorHavingDeletedNodes.isEmpty()) {
            libraryIds.addAll(this.testCaseBinDao.findLibraryIdsByNodeIds(nodesWithoutAncestorHavingDeletedNodes));
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Long libraryId : libraryIds) {
            result.add(TestCaseLibrary.class.getSimpleName() + "-" + String.valueOf(libraryId));
        }
        for (Long folderId : ancestorHavingDeletedNodeByNodeId.values()) {
            result.add(TestCaseFolder.class.getSimpleName() + "-" + String.valueOf(folderId));
        }
        return result;
    }

    private void checkPermission(NodeScope scope) {
        List<Long> projectIds = this.testCaseBinDao.getProjectIdsFromScope(scope);
        if (projectIds.isEmpty()) {
            throw new IllegalArgumentException("No project found for the given scope.");
        }
        this.permissionEvaluationService.checkPermission(projectIds, Permissions.MANAGE_PROJECT.name(), Project.class.getName());
    }

    private NodeScope buildNodeScopeForOperation(List<String> scopes, String operation) {
        NodeScope nodeScope = this.buildNodeScope(scopes);
        LOGGER.debug(" {} initiated by user: {} | Scope: {}", new Object[]{operation, UserContextHolder.getUsername(), String.join((CharSequence)", ", scopes)});
        return nodeScope;
    }

    private NodeScope buildNodeScope(List<String> scopes) {
        NodeScope nodeScope = this.nodeScopeFactory.fromNodeIds(scopes);
        this.checkPermission(nodeScope);
        return nodeScope;
    }
}

