/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.annotation;

import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.jooq.tools.StringUtils;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.IdentifiedRestore;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.service.annotation.ClassType;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.Ids;
import org.squashtest.tm.service.annotation.Position;
import org.squashtest.tm.service.annotation.RestoreMode;
import org.squashtest.tm.service.annotation.TransientlyRestore;
import org.squashtest.tm.service.annotation.TransientlyRestores;
import org.squashtest.tm.service.internal.deletion.NodeScope;
import org.squashtest.tm.service.internal.deletion.NodeScopeType;
import org.squashtest.tm.service.internal.deletion.restoration.testcase.JdbcTestCaseNodeRestorationFactory;
import org.squashtest.tm.service.internal.deletion.restoration.testcase.JdbcTestCaseNodeRestorationHandler;

@Aspect
@Component
public class TransientNodeRestorationAspect {
    @Inject
    private JdbcTestCaseNodeRestorationFactory restorationFactory;

    @Around(value="execution(@org.squashtest.tm.service.annotation.TransientlyRestores * * (..)) && @annotation(transientlyRestores)")
    public Object aroundTransientlyRestoreNodes(ProceedingJoinPoint joinPoint, TransientlyRestores transientlyRestores) throws Throwable {
        NodeScope nodeScope = this.extractOrCreateNodeScope(joinPoint, transientlyRestores.value());
        return this.executeTransientlyRestore(joinPoint, nodeScope, transientlyRestores.mode());
    }

    @Around(value="execution(@org.squashtest.tm.service.annotation.TransientlyRestore * * (..)) && @annotation(transientlyRestore)")
    public Object aroundTransientlyRestoreNode(ProceedingJoinPoint joinPoint, TransientlyRestore transientlyRestore) throws Throwable {
        NodeScope nodeScope = this.extractOrCreateNodeScope(joinPoint, new TransientlyRestore[]{transientlyRestore});
        RestoreMode mode = this.deduceMode(joinPoint, transientlyRestore);
        return this.executeTransientlyRestore(joinPoint, nodeScope, mode);
    }

    private Object executeTransientlyRestore(ProceedingJoinPoint joinPoint, NodeScope nodeScope, RestoreMode mode) throws Throwable {
        if (nodeScope.isEmpty()) {
            return joinPoint.proceed();
        }
        JdbcTestCaseNodeRestorationHandler restorationHandler = this.restorationFactory.build(nodeScope);
        Map<Long, Timestamp> restoredNodes = switch (mode) {
            case RestoreMode.LAST -> restorationHandler.transientlyRestoreLastOrderNodes();
            case RestoreMode.NESTED -> restorationHandler.transientlyRestoreNestedeNodes();
            case RestoreMode.ALL -> restorationHandler.transientlyRestoreAllNodes();
            default -> throw new MatchException(null, null);
        };
        Object result = joinPoint.proceed();
        restorationHandler.softDeleteTransientNodes(restoredNodes);
        return result;
    }

    private NodeScope extractOrCreateNodeScope(ProceedingJoinPoint joinPoint, TransientlyRestore[] transientlyRestores) {
        NodeScope existingNodeScope = this.tryExtractNodeScope(joinPoint);
        if (existingNodeScope != null) {
            return existingNodeScope;
        }
        return this.createNodeScopeFromAnnotation(joinPoint, transientlyRestores);
    }

    private NodeScope tryExtractNodeScope(ProceedingJoinPoint joinPoint) {
        Object[] objectArray = joinPoint.getArgs();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (arg instanceof NodeScope) {
                return (NodeScope)arg;
            }
            ++n2;
        }
        return null;
    }

    private NodeScope createNodeScopeFromAnnotation(ProceedingJoinPoint joinPoint, TransientlyRestore[] transientlyRestores) {
        HashMap<NodeScopeType, Set<Long>> entityIdsByScopeType = new HashMap<NodeScopeType, Set<Long>>();
        TransientlyRestore[] transientlyRestoreArray = transientlyRestores;
        int n = transientlyRestores.length;
        int n2 = 0;
        while (n2 < n) {
            TransientlyRestore restore = transientlyRestoreArray[n2];
            this.getEntityIdsByScopeType(joinPoint, restore).forEach((key, value) -> {
                Set set = entityIdsByScopeType.merge((NodeScopeType)((Object)key), (Set<Long>)value, (existing, newSet) -> {
                    HashSet merged = new HashSet(existing);
                    merged.addAll(newSet);
                    return merged;
                });
            });
            ++n2;
        }
        return new NodeScope(entityIdsByScopeType);
    }

    private Map<NodeScopeType, Set<Long>> getEntityIdsByScopeType(ProceedingJoinPoint joinPoint, TransientlyRestore transientlyRestore) {
        Set<Long> entityIds = this.extractIdParameter(joinPoint, transientlyRestore);
        if (entityIds.isEmpty()) {
            return Map.of();
        }
        NodeScopeType scopeType = this.determineNodeScopeType(joinPoint, transientlyRestore);
        return Map.of(scopeType, entityIds);
    }

    private Set<Long> extractIdParameter(ProceedingJoinPoint joinPoint, TransientlyRestore transientlyRestore) {
        Integer argIndex = this.getParameterIndex(joinPoint, transientlyRestore, Id.class, Ids.class);
        if (Objects.isNull(argIndex)) {
            return Set.of();
        }
        Object arg = joinPoint.getArgs()[argIndex];
        if (arg instanceof Long) {
            Long longArg = (Long)arg;
            return Set.of(longArg);
        }
        if (arg instanceof IdentifiedRestore) {
            IdentifiedRestore identifiedRestore = (IdentifiedRestore)arg;
            return Set.of(identifiedRestore.getTestCaseLibraryId());
        }
        if (arg instanceof Long[]) {
            Long[] longArray = (Long[])arg;
            return Set.of(longArray);
        }
        if (arg instanceof long[]) {
            long[] primLongArray = (long[])arg;
            return Arrays.stream(primLongArray).boxed().collect(Collectors.toSet());
        }
        if (TransientNodeRestorationAspect.checkLongCollection(arg)) {
            return Set.copyOf((Collection)arg);
        }
        return Set.of();
    }

    @SafeVarargs
    private Integer getParameterIndex(ProceedingJoinPoint joinPoint, TransientlyRestore transientlyRestore, Class<? extends Annotation> ... annotationClassesRaw) {
        Set<Class<? extends Annotation>> annotationClasses = Set.copyOf(Arrays.asList(annotationClassesRaw));
        Map<Annotation, Integer> annotationIntegerMap = this.getIndexByAnnotationMap(joinPoint, annotationClasses);
        if (annotationIntegerMap.isEmpty()) {
            return null;
        }
        if (annotationIntegerMap.size() == 1) {
            return annotationIntegerMap.values().iterator().next();
        }
        String paramName = transientlyRestore.paramName();
        if (StringUtils.isBlank((String)paramName)) {
            throw new IllegalArgumentException("Multiple parameters found with annotations " + String.valueOf(annotationClasses) + ", but no paramName specified in @TransientlyRestore.");
        }
        for (Map.Entry<Annotation, Integer> entry : annotationIntegerMap.entrySet()) {
            Ids ids;
            Id id;
            Annotation annotation = entry.getKey();
            if (annotation instanceof Id && (id = (Id)annotation).value().equals(paramName)) {
                return entry.getValue();
            }
            Annotation annotation2 = entry.getKey();
            if (!(annotation2 instanceof Ids) || !(ids = (Ids)annotation2).value().equals(paramName)) continue;
            return entry.getValue();
        }
        throw new IllegalArgumentException("No parameter found with name " + paramName + " among parameters annotated with " + String.valueOf(annotationClasses) + ".");
    }

    private Map<Annotation, Integer> getIndexByAnnotationMap(ProceedingJoinPoint joinPoint, Set<Class<? extends Annotation>> annotationClasses) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Annotation[][] annotations = method.getParameterAnnotations();
        HashMap<Annotation, Integer> indexByAnnotationMap = new HashMap<Annotation, Integer>();
        int iArg = 0;
        while (iArg < annotations.length) {
            Annotation[] currentArgAnnotations;
            Annotation[] annotationArray = currentArgAnnotations = annotations[iArg];
            int n = currentArgAnnotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (annotationClasses.contains(annotation.annotationType())) {
                    indexByAnnotationMap.put(annotation, iArg);
                }
                ++n2;
            }
            ++iArg;
        }
        return indexByAnnotationMap;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean checkLongCollection(Object arg) {
        void collection;
        if (!(arg instanceof Collection)) {
            return false;
        }
        Collection collection2 = (Collection)arg;
        for (Object o : collection) {
            if (o == null || o instanceof Long) continue;
            return false;
        }
        return true;
    }

    private NodeScopeType determineNodeScopeType(ProceedingJoinPoint joinPoint, TransientlyRestore transientlyRestore) {
        Class<?> entityType = this.extractEntityTypeFromParameter(joinPoint, transientlyRestore);
        NodeType nodeType = NodeType.fromTypeName((String)entityType.getSimpleName());
        return NodeScopeType.fromNodeType(nodeType);
    }

    private Class<?> extractEntityTypeFromParameter(ProceedingJoinPoint joinPoint, TransientlyRestore transientlyRestore) {
        Class<?> entityType = transientlyRestore.entityType();
        if (entityType != Void.class) {
            return entityType;
        }
        Integer argIndex = this.getParameterIndex(joinPoint, transientlyRestore, ClassType.class);
        if (argIndex == null || joinPoint.getArgs()[argIndex] == null || !(joinPoint.getArgs()[argIndex] instanceof Class)) {
            throw new IllegalArgumentException("Entity type must be specified in @TransientlyRestore when no NodeScope parameter is provided.");
        }
        return (Class)joinPoint.getArgs()[argIndex];
    }

    private RestoreMode deduceMode(ProceedingJoinPoint joinPoint, TransientlyRestore transientlyRestore) {
        Integer argIndex = this.getParameterIndex(joinPoint, transientlyRestore, Position.class);
        if (argIndex == null) {
            return transientlyRestore.mode();
        }
        Object arg = joinPoint.getArgs()[argIndex];
        if (arg == null) {
            return RestoreMode.LAST;
        }
        return RestoreMode.NESTED;
    }
}

