/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.quicktestnote;

import java.util.Objects;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.quicktest.QuickTestNote;
import org.squashtest.tm.service.annotation.CheckEntityExists;
import org.squashtest.tm.service.internal.repository.QuickTestNoteDao;
import org.squashtest.tm.service.quicktestnote.QuickTestNoteDeletionService;

@Service
public class QuickTestNoteDeletionServiceImpl
implements QuickTestNoteDeletionService {
    private final QuickTestNoteDao quickTestNoteDao;

    public QuickTestNoteDeletionServiceImpl(QuickTestNoteDao quickTestNoteDao) {
        this.quickTestNoteDao = quickTestNoteDao;
    }

    @Override
    @CheckEntityExists(entityType=QuickTestNote.class)
    public void deleteQuickTestNote(long quickTestId, long quickTestNoteId) {
        QuickTestNote note = (QuickTestNote)this.quickTestNoteDao.getReferenceById(quickTestNoteId);
        if (!Objects.equals(note.getQuickTest().getId(), quickTestId)) {
            throw new IllegalArgumentException("Note does not belong to this QuickTest");
        }
        this.quickTestNoteDao.deleteById(quickTestNoteId);
    }
}

