/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.File;
import java.io.IOException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.stereotype.Service;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.LibraryPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.ProjectPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotMetaDataModel;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AttachmentPivotType;
import org.squashtest.tm.service.pivot.PivotFileManager;
import org.squashtest.tm.service.pivot.projectexporter.ProjectPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.ProjectPivotDao;

@Service
public class ProjectPivotExporterServiceImpl
implements ProjectPivotExporterService {
    private final ProjectPivotDao projectPivotDao;
    private final PivotFileManager pivotFileManager;

    public ProjectPivotExporterServiceImpl(ProjectPivotDao projectPivotDao, PivotFileManager pivotFileManager) {
        this.projectPivotDao = projectPivotDao;
        this.pivotFileManager = pivotFileManager;
    }

    @Override
    public void generateProjectJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, File tmpAttachmentDir, Long projectId, PivotMetaDataModel pivotMetaDataModel) throws IOException {
        ProjectPivot projectPivot = this.projectPivotDao.getProjectByProjectId(projectId);
        if (projectPivot != null) {
            File attachmentDir = this.pivotFileManager.createAttachmentDir(tmpAttachmentDir, AttachmentPivotType.PROJECT);
            this.pivotFileManager.writePivotObjectToZip(jsonFactory, jsonGenerator -> this.handleProject(projectPivot, (JsonGenerator)jsonGenerator, pivotMetaDataModel), JsonImportFile.PROJECTS, archive);
            projectPivot.getAttachments().forEach(attachmentPivot -> this.pivotFileManager.saveTmpSaveAttachment(attachmentDir, (AttachmentPivot)attachmentPivot));
            this.saveAttachmentLibraryToZip(attachmentDir, projectPivot.getRequirementLibrary());
            this.saveAttachmentLibraryToZip(attachmentDir, projectPivot.getTestCaseLibrary());
            this.saveAttachmentLibraryToZip(attachmentDir, projectPivot.getCampaignLibrary());
            this.pivotFileManager.addAttachmentsToZip(archive, tmpAttachmentDir, attachmentDir);
        }
    }

    private void handleProject(ProjectPivot projectPivot, JsonGenerator jsonGenerator, PivotMetaDataModel pivotMetaDataModel) {
        pivotMetaDataModel.getBindingTypeByPivotId().putAll(projectPivot.getBoundInfoLists());
        this.pivotFileManager.writePivotObject(projectPivot, jsonGenerator, JsonImportFile.PROJECTS);
    }

    private void saveAttachmentLibraryToZip(File attachmentDir, LibraryPivot libraryPivot) {
        if (libraryPivot == null) {
            return;
        }
        libraryPivot.getAttachments().forEach(attachmentPivot -> this.pivotFileManager.saveTmpSaveAttachment(attachmentDir, (AttachmentPivot)attachmentPivot));
    }
}

