/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LockedNodeInferenceTree {
    private final Map<Long, Node> nodes = new HashMap<Long, Node>();

    public LockedNodeInferenceTree(Map<Long, List<Long>> childrenByParentId, List<Long> sourceIds) {
        for (Long sourceId : sourceIds) {
            Node ancestor = new Node(sourceId, null);
            this.nodes.put(sourceId, ancestor);
            this.filterParent(childrenByParentId, ancestor);
        }
    }

    private void filterParent(Map<Long, List<Long>> childrenByParentId, Node parent) {
        List children = childrenByParentId.getOrDefault(parent.getId(), Collections.emptyList());
        for (Long childId : children) {
            Node node = new Node(childId, parent);
            this.nodes.put(childId, node);
            this.filterParent(childrenByParentId, node);
        }
    }

    public void markLockedNodes(List<Long> lockedNodeIds) {
        for (Long lockedNodeId : lockedNodeIds) {
            Node node = this.nodes.get(lockedNodeId);
            if (node == null) continue;
            node.notDeletable();
        }
    }

    public List<Long> collectIds() {
        return this.nodes.keySet().stream().toList();
    }

    public List<Long> collectLockedIds() {
        return this.nodes.values().stream().filter(node -> !node.deletable).map(Node::getId).toList();
    }

    private static class Node {
        private final long id;
        private final Node parent;
        private boolean deletable = true;

        public Node(long id, Node parent) {
            this.id = id;
            this.parent = parent;
        }

        public void notDeletable() {
            this.deletable = false;
            if (this.parent != null) {
                this.parent.notDeletable();
            }
        }

        public long getId() {
            return this.id;
        }

        public boolean isDeletable() {
            return this.deletable;
        }
    }
}

