/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign.export;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.Field;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportMode;
import org.squashtest.tm.service.internal.campaign.export.dao.AbstractCampaignExportDao;

public enum CampaignExportHeader {
    CPG_SCHEDULED_START_ON("CPG_SCHEDULED_START_ON", true, true, true, (Field<?>)Tables.CAMPAIGN.SCHEDULED_START_DATE, ""),
    CPG_SCHEDULED_END_ON("CPG_SCHEDULED_END_ON", true, true, true, (Field<?>)Tables.CAMPAIGN.SCHEDULED_END_DATE, ""),
    CPG_ACTUAL_START_ON("CPG_ACTUAL_START_ON", true, true, true, (Field<?>)Tables.CAMPAIGN.ACTUAL_START_DATE, ""),
    CPG_ACTUAL_END_ON("CPG_ACTUAL_END_ON", true, true, true, (Field<?>)Tables.CAMPAIGN.ACTUAL_END_DATE, ""),
    IT("ITERATION", true, false, false, AbstractCampaignExportDao.IT_STANDARD, "n/a"),
    IT_ID("IT_ID", false, true, true, (Field<?>)Tables.ITERATION.ITERATION_ID, "n/a"),
    IT_NUM("IT_NUM", false, true, true, (Field<?>)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER, "n/a"),
    IT_NAME("IT_NAME", false, true, true, (Field<?>)Tables.ITERATION.NAME, "n/a"),
    IT_MILESTONE("IT_MILESTONE", true, true, true, (Field<?>)Tables.MILESTONE.LABEL, "n/a"),
    IT_SCHEDULED_START_ON("IT_SCHEDULED_START_ON", true, true, true, (Field<?>)Tables.ITERATION.SCHEDULED_START_DATE, ""),
    IT_SCHEDULED_END_ON("IT_SCHEDULED_END_ON", true, true, true, (Field<?>)Tables.ITERATION.SCHEDULED_END_DATE, ""),
    IT_ACTUAL_START_ON("IT_ACTUAL_START_ON", true, true, true, (Field<?>)Tables.ITERATION.ACTUAL_START_DATE, ""),
    IT_ACTUAL_END_ON("IT_ACTUAL_END_ON", true, true, true, (Field<?>)Tables.ITERATION.ACTUAL_END_DATE, ""),
    TC("TEST_CASE", true, false, false, (Field<?>)Tables.TEST_CASE_LIBRARY_NODE.NAME, "n/a"),
    TC_ID("TC_ID", false, true, true, (Field<?>)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, "n/a"),
    TC_NAME("TC_NAME", false, true, true, (Field<?>)Tables.TEST_CASE_LIBRARY_NODE.NAME, "n/a"),
    TC_PROJECT_ID("TC_PROJECT_ID", false, false, true, (Field<?>)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID, "n/a"),
    TC_PROJECT("TC_PROJECT", true, true, true, (Field<?>)Tables.PROJECT.NAME, "n/a"),
    TC_MILESTONE("TC_MILESTONE", true, true, true, AbstractCampaignExportDao.TC_MILESTONE_LABELS, "n/a"),
    TC_WEIGHT("TC_WEIGHT", true, true, true, (Field<?>)Tables.TEST_CASE.IMPORTANCE, "n/a"),
    TEST_SUITE("TEST_SUITE", true, true, true, AbstractCampaignExportDao.SUITE_NAMES, ""),
    COUNT_EXECUTIONS("#_EXECUTIONS", true, true, true, AbstractCampaignExportDao.EXECUTION_COUNT, "n/a"),
    COUNT_TC_COVERAGE("#_REQUIREMENTS", true, true, true, AbstractCampaignExportDao.TC_COVERAGE_COUNT, "n/a"),
    COUNT_EXEC_ISSUES("#_ISSUES", true, true, true, AbstractCampaignExportDao.EXECUTION_ISSUE_COUNT, "n/a"),
    DATASET_NAME("DATASET", true, true, true, (Field<?>)Tables.DATASET.NAME, ""),
    EXEC_STATUS("EXEC_STATUS", true, true, true, (Field<?>)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS, "n/a"),
    EXEC_LOGIN("EXEC_LOGIN", true, true, true, (Field<?>)Tables.CORE_USER.LOGIN, ""),
    EXEC_SUCCESS_RATE("EXEC_SUCCESS_RATE", true, false, false, AbstractCampaignExportDao.EXECUTION_RATE, "n/a"),
    EXECUTION_DATE("EXECUTION_DATE", true, true, true, (Field<?>)Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON, ""),
    DESCRIPTION("DESCRIPTION", true, false, false, (Field<?>)Tables.TEST_CASE_LIBRARY_NODE.DESCRIPTION, "n/a"),
    TC_REF("TC_REF", true, true, true, (Field<?>)Tables.TEST_CASE.REFERENCE, "n/a"),
    TC_NATURE("TC_NATURE", true, true, true, AbstractCampaignExportDao.TC_NATURE_CODE, "n/a"),
    TC_TYPE("TC_TYPE", true, true, true, AbstractCampaignExportDao.TC_TYPE_CODE, "n/a"),
    TC_STATUS("TC_STATUS", true, true, true, (Field<?>)Tables.TEST_CASE.TC_STATUS, "n/a"),
    PREREQUISITE("PREREQUISITE", true, false, false, (Field<?>)Tables.TEST_CASE.PREREQUISITE, "n/a"),
    STEP_ID("STEP_ID", false, false, true, (Field<?>)Tables.EXECUTION_STEP.EXECUTION_STEP_ID, "n/a"),
    STEP_NUM("STEP_NUM", false, false, true, (Field<?>)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, "n/a"),
    COUNT_STEP_COVERAGE("STEP_#_REQ", false, false, true, AbstractCampaignExportDao.TS_COVERAGE_COUNT, "n/a"),
    EXEC_STEP_STATUS("EXEC_STEP_STATUS", false, false, true, (Field<?>)Tables.EXECUTION_STEP.EXECUTION_STATUS, "n/a"),
    EXEC_STEP_DATE("EXEC_STEP_DATE", false, false, true, (Field<?>)Tables.EXECUTION_STEP.LAST_EXECUTED_ON, ""),
    EXEC_STEP_USER("EXEC_STEP_EXECUTOR_LOGIN", false, false, true, (Field<?>)Tables.EXECUTION_STEP.LAST_EXECUTED_BY, ""),
    COUNT_EXEC_STEP_ISSUES("EXEC_STEP_#_ISSUES", false, false, true, AbstractCampaignExportDao.EXECUTION_STEP_ISSUE_COUNT, "n/a"),
    EXEC_STEP_COMMENT("EXEC_STEP_COMMENT", false, false, true, (Field<?>)Tables.EXECUTION_STEP.COMMENT, ""),
    CPG_CUF("CPG_CUF_", true, true, true, (Field<?>)Tables.CAMPAIGN.CLN_ID, ""),
    IT_CUF("IT_CUF_", true, true, true, (Field<?>)Tables.ITERATION.ITERATION_ID, ""),
    TC_CUF("TC_CUF_", true, true, true, (Field<?>)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, ""),
    EXEC_CUF("EXEC_CUF_", true, false, true, (Field<?>)Tables.EXECUTION.EXECUTION_ID, ""),
    STEP_CUF("STEP_CUF_", false, false, true, (Field<?>)Tables.EXECUTION_STEP.EXECUTION_STEP_ID, "");

    private final String headerName;
    private final boolean standardExport;
    private final boolean simpleExport;
    private final boolean fullExport;
    private final Field<?> field;
    private final String defaultValue;

    private CampaignExportHeader(String headerName, boolean standardExport, boolean simpleExport, boolean fullExport, Field<?> field, String defaultValue) {
        this.headerName = headerName;
        this.standardExport = standardExport;
        this.simpleExport = simpleExport;
        this.fullExport = fullExport;
        this.field = field;
        this.defaultValue = defaultValue;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public Field<?> getField() {
        return this.field;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public static List<CampaignExportHeader> getExportHeadersFromMode(CampaignExportMode mode, boolean milestoneEnabled) {
        Predicate<CampaignExportHeader> headerModePredicate = switch (mode) {
            case CampaignExportMode.STANDARD -> header -> header.standardExport;
            case CampaignExportMode.SIMPLE -> header -> header.simpleExport;
            case CampaignExportMode.FULL -> header -> header.fullExport;
            default -> throw new MatchException(null, null);
        };
        return CampaignExportHeader.getCampaignExportHeaders(headerModePredicate, milestoneEnabled);
    }

    private static List<CampaignExportHeader> getCampaignExportHeaders(Predicate<CampaignExportHeader> filterFunction, boolean milestoneEnabled) {
        return Stream.of(CampaignExportHeader.values()).filter(header -> filterFunction.test((CampaignExportHeader)((Object)header)) && (!CampaignExportHeader.isMilestoneHeader(header) || milestoneEnabled)).collect(Collectors.toCollection(LinkedList::new));
    }

    public static BindableEntity toBindableEntity(CampaignExportHeader header) {
        return switch (header) {
            case CPG_CUF -> BindableEntity.CAMPAIGN;
            case IT_CUF -> BindableEntity.ITERATION;
            case TC_CUF -> BindableEntity.TEST_CASE;
            case EXEC_CUF -> BindableEntity.EXECUTION;
            case STEP_CUF -> BindableEntity.EXECUTION_STEP;
            default -> throw new IllegalArgumentException("Header is not a CUF header: " + String.valueOf((Object)header));
        };
    }

    public static boolean isCufHeader(CampaignExportHeader header) {
        return CPG_CUF.equals((Object)header) || IT_CUF.equals((Object)header) || TC_CUF.equals((Object)header) || EXEC_CUF.equals((Object)header) || STEP_CUF.equals((Object)header);
    }

    public static boolean isMilestoneHeader(CampaignExportHeader header) {
        return IT_MILESTONE.equals((Object)header) || TC_MILESTONE.equals((Object)header);
    }
}

