/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.excel;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.persistence.EntityManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.service.annotation.CacheScope;
import org.squashtest.tm.service.importer.EntityType;
import org.squashtest.tm.service.importer.ImportLog;
import org.squashtest.tm.service.internal.batchimport.Facility;
import org.squashtest.tm.service.internal.batchimport.FacilityImpl;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.SimulationFacility;
import org.squashtest.tm.service.internal.batchimport.column.ExcelWorkbookParser;
import org.squashtest.tm.service.internal.batchimport.instruction.Instruction;
import org.squashtest.tm.service.internal.batchimport.instruction.container.Importer;
import org.squashtest.tm.service.internal.batchimport.instruction.container.InstructionContainer;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.hibernate.utils.HibernateConfig;

public abstract class ExcelBatchImporter {
    @Inject
    private Provider<SimulationFacility> simulatorProvider;
    @Inject
    private Provider<FacilityImpl> facilityImplProvider;
    @Inject
    private EntityManager entityManager;
    @Inject
    private ProjectDao projectDao;
    protected final Logger LOGGER;

    protected ExcelBatchImporter(Logger logger) {
        this.LOGGER = logger;
    }

    public ImportLog simulateImport(File excelFile) {
        this.LOGGER.debug("beginning import simulation", new Object[0]);
        ExcelWorkbookParser parser = this.getExcelWorkbookParser(excelFile);
        LogTrain unknownHeaders = parser.logUnknownHeaders();
        Importer containers = this.buildOrderedInstructionContainers(parser);
        this.LOGGER.trace("running import simulation", new Object[0]);
        ImportLog importLog = this.run(containers, this.simulatorProvider);
        importLog.appendLogTrain(unknownHeaders);
        this.LOGGER.trace("done", new Object[0]);
        return importLog;
    }

    private ExcelWorkbookParser getExcelWorkbookParser(File excelFile) {
        this.LOGGER.trace("parsing excel file", new Object[0]);
        ExcelWorkbookParser parser = ExcelWorkbookParser.createParser(excelFile);
        parser.parse().releaseResources();
        this.LOGGER.trace("parsing done", new Object[0]);
        return parser;
    }

    @CacheScope
    public ImportLog performImport(File excelFile) {
        this.LOGGER.debug("beginning import", new Object[0]);
        ExcelWorkbookParser parser = this.getExcelWorkbookParser(excelFile);
        LogTrain unknownHeaders = parser.logUnknownHeaders();
        Importer containers = this.buildOrderedInstructionContainers(parser);
        this.LOGGER.trace("running import", new Object[0]);
        ImportLog importLog = this.run(containers, this.facilityImplProvider);
        importLog.appendLogTrain(unknownHeaders);
        this.LOGGER.trace("done", new Object[0]);
        return importLog;
    }

    private <T extends Facility> ImportLog run(Importer importer, Provider<T> facility) {
        HibernateConfig.enableBatch(this.entityManager, 30);
        return importer.performImport(facility, this.projectDao);
    }

    public Importer buildOrderedInstructionContainers(ExcelWorkbookParser parser) {
        return this.buildImporter(parser);
    }

    private Importer buildImporter(ExcelWorkbookParser parser) {
        Importer importer = new Importer();
        for (EntityType entity : this.getEntityType()) {
            this.addInstructionsByEntity(parser, entity, importer);
        }
        return importer;
    }

    protected <T extends Instruction<?>> void addInstructionsToImporter(List<T> instructions, Importer importer, Function<List<T>, InstructionContainer<T>> containerCreator) {
        HashMap<String, List> instructionsMap = new HashMap<String, List>();
        for (Instruction instruction : instructions) {
            if (!instruction.canImport(this.isTcContext())) {
                importer.addErrorInstruction(instruction);
                continue;
            }
            String projectName = this.getProjectName(instruction);
            instructionsMap.computeIfAbsent(projectName, k -> new ArrayList()).add(instruction);
        }
        instructionsMap.forEach((project, container) -> importer.addInstructionContainer((String)project, (InstructionContainer)containerCreator.apply((List)container)));
    }

    private <T extends Instruction<?>> String getProjectName(T instruction) {
        String sourceProjectName = PathUtils.extractUnescapedProjectName((String)instruction.getSourcePath(this.isTcContext()));
        if (instruction.getLinkPath() != null) {
            String linkProjectName = PathUtils.extractUnescapedProjectName((String)instruction.getLinkPath());
            return StringUtils.compare((String)sourceProjectName, (String)linkProjectName) > 0 ? sourceProjectName : linkProjectName;
        }
        return sourceProjectName;
    }

    public abstract List<EntityType> getEntityType();

    public abstract void addInstructionsByEntity(ExcelWorkbookParser var1, EntityType var2, Importer var3);

    public abstract boolean isTcContext();
}

