/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.service.internal.repository.TestStepDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;

@Repository
public class HibernateTestStepDao
extends HibernateEntityDao<TestStep>
implements TestStepDao {
    @Override
    public List<TestStep> findListById(List<Long> testStepIds) {
        return this.entityManager.createQuery("select step\nfrom TestCase testCase\ninner join testCase.steps step\nwhere step.id in :ids order by index(step)", TestStep.class).setParameter("ids", testStepIds).getResultList();
    }

    @Override
    public int findPositionOfStep(Long testStepId) {
        return (Integer)this.entityManager.createQuery("select index(tsteps)\nfrom TestCase tc\njoin tc.steps tsteps\nwhere tsteps.id = :id", Integer.class).setParameter("id", (Object)testStepId).getSingleResult();
    }

    @Override
    public ActionTestStep findActionTestStepById(long testStepId) {
        return (ActionTestStep)this.entityManager.createQuery("select step\nfrom TestCase tc\njoin treat(tc.steps as ActionTestStep) step\nwhere step.id = :id", ActionTestStep.class).setParameter("id", (Object)testStepId).getSingleResult();
    }

    @Override
    public boolean stringIsFoundInStepsOfTestCase(String stringToFind, long testCaseId) {
        return (Boolean)this.entityManager.createQuery("select exists (\n    select 1\n    from TestCase tc\n    left join tc.steps steps\n    where tc.id = :id and (steps.action like :stringToFind or steps.expectedResult like :stringToFind or tc.prerequisite like :stringToFind))", Boolean.class).setParameter("id", (Object)testCaseId).setParameter("stringToFind", (Object)("%" + stringToFind + "%")).getSingleResult();
    }

    @Override
    public boolean stringIsFoundInStepsOfKeywordTestCase(String stringToFind, long testCaseId) {
        return (Boolean)this.entityManager.createQuery("select exists (\n    select 1\n    from TestCase tc\n    join tc.steps steps\n    join steps.paramValues values\n    where tc.id = :id and values.value = :stringToFind)", Boolean.class).setParameter("id", (Object)testCaseId).setParameter("stringToFind", (Object)stringToFind).getSingleResult();
    }

    @Override
    public List<TestStep> findByIdOrderedByIndex(List<Long> testStepIds) {
        return this.entityManager.createQuery("select st\nfrom TestCase tc\njoin tc.steps st\nwhere st.id in :ids order by index(st)", TestStep.class).setParameter("ids", testStepIds).getResultList();
    }

    @Override
    public TestCase findTestCaseFromActionTestStep(long testStepId) {
        return (TestCase)this.entityManager.createQuery("select ats.testCase\nfrom ActionTestStep ats\nwhere ats.id= :id\n", TestCase.class).setParameter("id", (Object)testStepId).getSingleResult();
    }

    @Override
    public List<Object[]> findTestStepsDetails(Collection<Long> testCaseIds) {
        return this.entityManager.createQuery("select tc.id,\n        case when st.class = ActionTestStep then 'ACTION' else 'CALL' end as steptype,\n        case when st.class = CallTestStep then st.calledTestCase.id else null end as calledTC,\n        case when st.class=CallTestStep then st.delegateParameterValues else false end as delegates\n        from TestCase tc join tc.steps st where tc.id in :ids order by index(st)", Object[].class).setParameter("ids", testCaseIds).getResultList();
    }

    @Override
    public TestStep findByTestCaseAndPosition(Long testCaseId, Integer index) {
        return (TestStep)this.entityManager.createQuery("select st from TestCase tc\njoin tc.steps st\nwhere tc.id = :testCaseId and index(st) = :position", TestStep.class).setParameter("testCaseId", (Object)testCaseId).setParameter("position", (Object)index).getSingleResult();
    }

    @Override
    public TestStep findById(long id) {
        return (TestStep)this.entityManager.createQuery("select step\nfrom TestCase tc\njoin tc.steps step\nwhere step.id = :id", TestStep.class).setParameter("id", (Object)id).getSingleResult();
    }

    @Override
    public List<TestStep> findAllByIds(Collection<Long> ids) {
        return this.entityManager.createQuery("select step\nfrom TestCase tc\njoin tc.steps step\nwhere step.id in :ids", TestStep.class).setParameter("ids", ids).getResultList();
    }
}

