/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.CommonTableExpression;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.Record9;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.RequirementLibraryNode;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.MilestonePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.PivotAttachmentEntity;
import org.squashtest.tm.service.internal.dto.pivotdefinition.requirementworkspace.RequirementPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.requirementworkspace.RequirementVersionLinkPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.requirementworkspace.RequirementVersionPivot;
import org.squashtest.tm.service.internal.jooq.SubElementRecordProcessor;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.AbstractPivotDao;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.EntityBindingField;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.converters.RequirementPivotConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.CustomFieldPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.RequirementPivotDao;

@Repository
public class RequirementPivotDaoImpl
extends AbstractPivotDao<RequirementPivot>
implements RequirementPivotDao {
    private static final String CTE_REQUIREMENT = "CTE_REQUIREMENT";
    private static final Field<Long> CTE_RLN_ID = DSL.field((Name)DSL.name((String[])new String[]{"CTE_REQUIREMENT", Tables.REQUIREMENT.RLN_ID.getName()}), Long.class);
    private final CustomFieldPivotDao customFieldPivotDao;
    private final RequirementPivotConverterService requirementPivotConverterService;

    public RequirementPivotDaoImpl(DSLContext dsl, AdminPivotConverterService adminPivotConverterService, CustomFieldPivotDao customFieldPivotDao, RequirementPivotConverterService requirementPivotConverterService) {
        super(dsl, adminPivotConverterService);
        this.customFieldPivotDao = customFieldPivotDao;
        this.requirementPivotConverterService = requirementPivotConverterService;
    }

    @Override
    public boolean hasRequirementByProjectId(Long projectId) {
        CommonTableExpression<Record1<Long>> requirementCte = this.getRequirementCte(projectId);
        return this.dsl.fetchExists((Select)DSL.with((CommonTableExpression[])new CommonTableExpression[]{requirementCte}).selectOne().from(requirementCte));
    }

    private CommonTableExpression<Record1<Long>> getRequirementCte(Long projectId) {
        return DSL.name((String)CTE_REQUIREMENT).fields(CTE_RLN_ID.getName()).as((ResultQuery)DSL.select((SelectField)Tables.REQUIREMENT.RLN_ID).from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).join((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).unionAll((Select)DSL.select((SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID)).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).and(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.notEqual((Object)projectId))));
    }

    private Table<Record2<Long, Short>> getMaxDepthRequirementRelationshipClosure() {
        return DSL.select((SelectField)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, (SelectField)DSL.max((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH).as(RequirementPivotDao.MAX_DEPTH)).from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).groupBy(new GroupField[]{Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID}).asTable();
    }

    private Table<Record2<Long, String>> getLinkedRequirementToHighLevelTable(Long projectId) {
        RequirementLibraryNode linkedRln = Tables.REQUIREMENT_LIBRARY_NODE.as("LINKED_RLN_ID_TO_HIGH_LEVEL");
        return DSL.select((SelectField)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID, (SelectField)DSL.groupConcat((Field)Tables.REQUIREMENT.RLN_ID).separator(",").as(RequirementPivotDao.RLN_ID_LINKED_HIGH_LEVEL)).from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).join((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID)).join((TableLike)linkedRln).on(Tables.REQUIREMENT.RLN_ID.eq((Field)linkedRln.RLN_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).and(linkedRln.PROJECT_ID.eq((Object)projectId)).groupBy(new GroupField[]{Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID}).asTable();
    }

    private ResultQuery<? extends Record> getAttachmentByProjectIdQuery(CommonTableExpression<Record1<Long>> requirementCte, Table<Record2<Long, Short>> maxDepthDescendantTable) {
        return this.dsl.with(new CommonTableExpression[]{requirementCte}).select(CTE_RLN_ID, (SelectField)Tables.REQUIREMENT_VERSION.RES_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_LIST_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_ID, (SelectField)Tables.ATTACHMENT.NAME, (SelectField)Tables.ATTACHMENT.TYPE, (SelectField)Tables.ATTACHMENT.ADDED_ON, (SelectField)Tables.ATTACHMENT.LAST_MODIFIED_ON, (SelectField)Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID, (SelectField)Tables.ATTACHMENT_CONTENT.STREAM_CONTENT).from(requirementCte).join((TableLike)Tables.REQUIREMENT_VERSION).on(CTE_RLN_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).join((TableLike)Tables.RESOURCE).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).join((TableLike)Tables.ATTACHMENT).on(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)Tables.RESOURCE.ATTACHMENT_LIST_ID)).join((TableLike)Tables.ATTACHMENT_CONTENT).on(Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID.eq((Field)Tables.ATTACHMENT.CONTENT_ID)).join(maxDepthDescendantTable).on(CTE_RLN_ID.eq(maxDepthDescendantTable.field((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID))).orderBy(RequirementPivotDao.MAX_DEPTH, CTE_RLN_ID, (OrderField)Tables.REQUIREMENT_VERSION.VERSION_NUMBER);
    }

    private ResultQuery<? extends Record> getMilestoneByProjectIdQuery(Long projectId, Table<Record2<Long, Short>> maxDepthDescendantTable) {
        return this.dsl.select((SelectField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, (SelectField)Tables.REQUIREMENT_VERSION.RES_ID, (SelectField)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID).from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).join((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID)).join(maxDepthDescendantTable).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq(maxDepthDescendantTable.field((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID))).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy(RequirementPivotDao.MAX_DEPTH, (OrderField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, (OrderField)Tables.REQUIREMENT_VERSION.VERSION_NUMBER);
    }

    private ResultQuery<? extends Record> getRequirementVersionLinkByProjectIdQuery(Long projectId, Table<Record2<Long, Short>> maxDepthDescendantTable) {
        Table linkTable = DSL.select((SelectField)Tables.REQUIREMENT_VERSION_LINK.LINK_ID, (SelectField)Tables.REQUIREMENT_VERSION_LINK.REQUIREMENT_VERSION_ID, (SelectField)Tables.REQUIREMENT_VERSION_LINK.RELATED_REQUIREMENT_VERSION_ID, (SelectField)Tables.REQUIREMENT_VERSION_LINK.LINK_TYPE_ID).from((TableLike)Tables.REQUIREMENT_VERSION_LINK).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION_LINK.RELATED_REQUIREMENT_VERSION_ID)).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).and(Tables.REQUIREMENT_VERSION_LINK.LINK_DIRECTION.isFalse()).asTable();
        return this.dsl.select((SelectField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, (SelectField)Tables.REQUIREMENT_VERSION.RES_ID, (SelectField)Objects.requireNonNull(linkTable.field((Field)Tables.REQUIREMENT_VERSION_LINK.LINK_ID)).as((Field)Tables.REQUIREMENT_VERSION_LINK.LINK_ID), (SelectField)Objects.requireNonNull(linkTable.field((Field)Tables.REQUIREMENT_VERSION_LINK.RELATED_REQUIREMENT_VERSION_ID)).as((Field)Tables.REQUIREMENT_VERSION_LINK.RELATED_REQUIREMENT_VERSION_ID), (SelectField)Objects.requireNonNull(linkTable.field((Field)Tables.REQUIREMENT_VERSION_LINK.LINK_TYPE_ID)).as((Field)Tables.REQUIREMENT_VERSION_LINK.LINK_TYPE_ID)).from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).join((TableLike)linkTable).on(Tables.REQUIREMENT_VERSION.RES_ID.eq(linkTable.field((Field)Tables.REQUIREMENT_VERSION_LINK.REQUIREMENT_VERSION_ID))).join(maxDepthDescendantTable).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq(maxDepthDescendantTable.field((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID))).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy(RequirementPivotDao.MAX_DEPTH, (OrderField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, (OrderField)Tables.REQUIREMENT_VERSION.VERSION_NUMBER);
    }

    @Override
    public void getRequirementByProjectId(Long projectId, Consumer<RequirementPivot> requirementPivotConsumer, Consumer<AttachmentPivot> attachmentPivotConsumer) {
        CommonTableExpression<Record1<Long>> requirementCte = this.getRequirementCte(projectId);
        Table<Record9<Long, Long, Long, String, String, String, String, String, String>> customFieldValuesTable = this.customFieldPivotDao.getCustomFieldValuesTableByProjectIdAndBindableEntity(projectId, BindableEntity.REQUIREMENT_VERSION);
        Table<Record2<Long, String>> linkedToHighLevelReq = this.getLinkedRequirementToHighLevelTable(projectId);
        Table<Record2<Long, Short>> maxDepthDescendantTable = this.getMaxDepthRequirementRelationshipClosure();
        ResultQuery resultQuery = this.dsl.with(new CommonTableExpression[]{requirementCte}).select(new SelectFieldOrAsterisk[]{Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID, Tables.REQUIREMENT_LIBRARY_NODE.CREATED_BY, Tables.REQUIREMENT_LIBRARY_NODE.CREATED_ON, Tables.REQUIREMENT_LIBRARY_NODE.LAST_MODIFIED_BY, Tables.REQUIREMENT_LIBRARY_NODE.LAST_MODIFIED_ON, Tables.RESOURCE.NAME, Tables.RESOURCE.DESCRIPTION, Tables.RESOURCE.CREATED_BY, Tables.RESOURCE.CREATED_ON, Tables.RESOURCE.LAST_MODIFIED_BY, Tables.RESOURCE.LAST_MODIFIED_ON, Tables.REQUIREMENT_VERSION.RES_ID, Tables.REQUIREMENT_VERSION.REFERENCE, Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS, Tables.REQUIREMENT_VERSION.CRITICALITY, Tables.INFO_LIST_ITEM.CODE, Tables.RLN_RELATIONSHIP.ANCESTOR_ID, Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.isNotNull().as(RequirementPivotDao.IS_HIGH_LEVEL), RequirementPivotDao.RLN_ID_LINKED_HIGH_LEVEL, Tables.REQUIREMENT_FOLDER.RLN_ID.isNotNull().as(RequirementPivotDao.IS_FOLDER), CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID, CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_TYPE, CustomFieldPivotDao.CFV_TABLE_CF_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE}).from(requirementCte).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(CTE_RLN_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).join((TableLike)Tables.REQUIREMENT).on(CTE_RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).join((TableLike)Tables.RESOURCE).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).leftJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).leftJoin(linkedToHighLevelReq).on(Tables.REQUIREMENT.RLN_ID.eq(linkedToHighLevelReq.field((Field)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID))).leftJoin((TableLike)Tables.INFO_LIST_ITEM).on(Tables.INFO_LIST_ITEM.ITEM_ID.eq((Field)Tables.REQUIREMENT_VERSION.CATEGORY)).leftJoin((TableLike)Tables.RLN_RELATIONSHIP).on(Tables.RLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).leftJoin((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.RLN_RELATIONSHIP.ANCESTOR_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).leftJoin(customFieldValuesTable).on(Tables.REQUIREMENT_VERSION.RES_ID.eq(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID)).join(maxDepthDescendantTable).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq(maxDepthDescendantTable.field((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID))).orderBy(RequirementPivotDao.MAX_DEPTH, (OrderField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, (OrderField)Tables.REQUIREMENT_VERSION.VERSION_NUMBER).fetchSize(50);
        this.convertRecordAndWritingPivot(resultQuery, projectId, EntityBindingField.REQUIREMENT, requirementPivotConsumer, attachmentPivotConsumer);
    }

    @Override
    protected RequirementPivot getNewPivotObject(Record record, Long projectId, EntityBindingField entityBindingField) {
        RequirementPivot requirementPivot = this.requirementPivotConverterService.requirementRecordToRequirementPivot(record, projectId);
        RequirementVersionPivot requirementVersionPivot = this.getNewRequirementVersionPivot(record);
        requirementPivot.getRequirementVersions().add(requirementVersionPivot);
        return requirementPivot;
    }

    private RequirementVersionPivot getNewRequirementVersionPivot(Record record) {
        RequirementVersionPivot requirementVersionPivot = this.requirementPivotConverterService.requirementVersionRecordToRequirementVersionPivot(record);
        this.customFieldPivotDao.appendCustomFieldValuesFromRecord(requirementVersionPivot.getCustomFields(), record);
        return requirementVersionPivot;
    }

    @Override
    protected void fillPivotObject(RequirementPivot pivotObject, Record record) {
        if (pivotObject.getRequirementVersions().isEmpty()) {
            return;
        }
        RequirementVersionPivot requirementVersionPivot = pivotObject.getRequirementVersions().getLast();
        this.fillExistingRequirement(pivotObject, requirementVersionPivot, record);
    }

    private void fillExistingRequirement(RequirementPivot requirementPivot, RequirementVersionPivot requirementVersionPivot, Record record) {
        if (!requirementVersionPivot.pivotIdToSquashId().equals(record.get((Field)Tables.REQUIREMENT_VERSION.RES_ID))) {
            requirementVersionPivot = this.requirementPivotConverterService.requirementVersionRecordToRequirementVersionPivot(record);
            this.customFieldPivotDao.appendCustomFieldValuesFromRecord(requirementVersionPivot.getCustomFields(), record);
            requirementPivot.getRequirementVersions().add(requirementVersionPivot);
        } else {
            this.customFieldPivotDao.appendCustomFieldValuesFromRecord(requirementVersionPivot.getCustomFields(), record);
        }
    }

    @Override
    protected List<SubElementRecordProcessor<? extends AbstractPivotObject>> getSubElementRecordProcessors(Long projectId, EntityBindingField entityBindingField) {
        return List.of(this.getAttachmentPivotContainer(projectId), this.getMilestoneContainer(projectId), this.getRequirementVersionLinkContainer(projectId));
    }

    private SubElementRecordProcessor<AttachmentPivot> getAttachmentPivotContainer(Long projectId) {
        CommonTableExpression<Record1<Long>> requirementCte = this.getRequirementCte(projectId);
        Table<Record2<Long, Short>> maxDepthDescendantTable = this.getMaxDepthRequirementRelationshipClosure();
        return new SubElementRecordProcessor<AttachmentPivot>(this.getAttachmentByProjectIdQuery(requirementCte, maxDepthDescendantTable), CTE_RLN_ID, (Field<Long>)Tables.ATTACHMENT.ATTACHMENT_ID, record -> this.adminPivotConverterService.recordToAttachmentPivot((Record)record, (Field<Long>)Tables.REQUIREMENT_VERSION.RES_ID), AttachmentPivot.class);
    }

    private SubElementRecordProcessor<MilestonePivot> getMilestoneContainer(Long projectId) {
        Table<Record2<Long, Short>> maxDepthDescendantTable = this.getMaxDepthRequirementRelationshipClosure();
        return new SubElementRecordProcessor<MilestonePivot>(this.getMilestoneByProjectIdQuery(projectId, maxDepthDescendantTable), (Field<Long>)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, (Field<Long>)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID, record -> this.adminPivotConverterService.recordToBindingMilestonePivot((Record)record, (Field<Long>)Tables.REQUIREMENT_VERSION.RES_ID, (Field<Long>)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID), MilestonePivot.class);
    }

    private SubElementRecordProcessor<RequirementVersionLinkPivot> getRequirementVersionLinkContainer(Long projectId) {
        Table<Record2<Long, Short>> maxDepthDescendantTable = this.getMaxDepthRequirementRelationshipClosure();
        return new SubElementRecordProcessor<RequirementVersionLinkPivot>(this.getRequirementVersionLinkByProjectIdQuery(projectId, maxDepthDescendantTable), (Field<Long>)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, (Field<Long>)Tables.REQUIREMENT_VERSION_LINK.LINK_ID, this.requirementPivotConverterService::recordToRequirementVersionLinkPivot, RequirementVersionLinkPivot.class);
    }

    @Override
    protected void appendSubElementsToPivotObject(RequirementPivot pivotObject, Map<Class<? extends AbstractPivotObject>, List<? extends AbstractPivotObject>> subElementsByClazz, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        List<RequirementVersionLinkPivot> requirementVersionLinkPivots = this.getSubElement(RequirementVersionLinkPivot.class, subElementsByClazz);
        List<AttachmentPivot> attachmentPivots = this.getSubElement(AttachmentPivot.class, subElementsByClazz);
        List<MilestonePivot> milestonePivots = this.getSubElement(MilestonePivot.class, subElementsByClazz);
        if (milestonePivots.isEmpty() && attachmentPivots.isEmpty() && requirementVersionLinkPivots.isEmpty()) {
            return;
        }
        Map<Long, RequirementVersionPivot> requirementVersionPivotById = pivotObject.getRequirementVersions().stream().collect(Collectors.toMap(AbstractPivotObject::pivotIdToSquashId, Function.identity()));
        this.addAndWriteAttachmentPivot(attachmentPivots, requirementVersionPivotById, writingAttachmentConsumer);
        this.addMilestonePivot(milestonePivots, requirementVersionPivotById);
        this.addRequirementLink(requirementVersionLinkPivots, requirementVersionPivotById);
    }

    private void addAndWriteAttachmentPivot(List<AttachmentPivot> attachmentPivots, Map<Long, RequirementVersionPivot> requirementVersionPivotById, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        attachmentPivots.forEach(attachment -> {
            RequirementVersionPivot requirementVersionPivot = requirementVersionPivotById.computeIfPresent(attachment.getHolderId(), (k, v) -> {
                this.addAndWriteAttachmentPivot((AttachmentPivot)attachment, (PivotAttachmentEntity)v, writingAttachmentConsumer);
                return v;
            });
        });
    }

    private void addMilestonePivot(List<MilestonePivot> milestonePivots, Map<Long, RequirementVersionPivot> requirementVersionPivotById) {
        milestonePivots.forEach(milestonePivot -> {
            RequirementVersionPivot requirementVersionPivot = requirementVersionPivotById.computeIfPresent(milestonePivot.getBindableId(), (k, v) -> {
                v.addMilestone(milestonePivot.getPivotId());
                return v;
            });
        });
    }

    private void addRequirementLink(List<RequirementVersionLinkPivot> requirementVersionLinkPivots, Map<Long, RequirementVersionPivot> requirementVersionPivotById) {
        requirementVersionLinkPivots.forEach(requirementVersionLinkPivot -> {
            RequirementVersionPivot requirementVersionPivot = requirementVersionPivotById.computeIfPresent(requirementVersionLinkPivot.getRequirementVersionId(), (k, v) -> {
                v.addRequirementVersionLink((RequirementVersionLinkPivot)requirementVersionLinkPivot);
                return v;
            });
        });
    }
}

