/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.filemanagement.writer;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.squashtest.tm.exception.filemanagement.WriterException;
import org.squashtest.tm.service.internal.filemanagement.writer.Writer;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;

public class CSVWriter
implements Writer {
    private static final char UTF8_BOM_UNICODE = '\ufeff';
    private final CSVPrinter csvPrinter;

    public CSVWriter(Appendable appendable, CSVFormat csvFormat) {
        this.csvPrinter = this.createCSVPrinter(appendable, csvFormat);
    }

    private CSVPrinter createCSVPrinter(Appendable appendable, CSVFormat csvFormat) {
        try {
            appendable.append('\ufeff');
            return new CSVPrinter(appendable, csvFormat);
        }
        catch (IOException e) {
            throw new WriterException((Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            this.csvPrinter.close();
        }
        catch (IOException e) {
            throw new WriterException((Throwable)e);
        }
    }

    @Override
    public void flush() {
        try {
            this.csvPrinter.flush();
        }
        catch (IOException e) {
            throw new WriterException((Throwable)e);
        }
    }

    @Override
    public void write(Collection<String> data) {
        List<String> cleanedValues = data.stream().map(HTMLCleanupUtils::cleanHtml).toList();
        try {
            this.csvPrinter.printRecord(cleanedValues);
        }
        catch (IOException e) {
            throw new WriterException((Throwable)e);
        }
    }
}

