/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.execution;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Date;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.lang.Wrapped;
import org.squashtest.tm.domain.campaign.ExploratorySessionOverview;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.ConsumerForExploratoryExecution;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionVisitor;
import org.squashtest.tm.domain.execution.ExploratoryExecution;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.campaign.SprintClosedException;
import org.squashtest.tm.exception.requirement.MilestoneForbidModificationException;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.campaign.ExecutionCreationService;
import org.squashtest.tm.service.execution.ExploratorySessionOverviewModificationService;
import org.squashtest.tm.service.internal.repository.MilestoneDao;
import org.squashtest.tm.service.internal.repository.TestPlanItemDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.internal.repository.display.SprintDisplayDao;
import org.squashtest.tm.service.security.UserContextService;

@Service(value="squashtest.tm.service.ExploratorySessionOverviewModificationService")
@Transactional
public class ExploratorySessionOverviewModificationServiceImpl
implements ExploratorySessionOverviewModificationService {
    private static final String EXECUTE_OVERVIEW_OR_ADMIN = "hasPermission(#overviewId, 'org.squashtest.tm.domain.campaign.ExploratorySessionOverview' ,'EXECUTE')  or hasRole('ROLE_ADMIN')";
    private final DSLContext dslContext;
    private final MilestoneDao milestoneDao;
    private final UserDao userDao;
    private final UserContextService userContextService;
    private final ExecutionCreationService executionCreationService;
    private final SprintDisplayDao sprintDisplayDao;
    private final CustomTestSuiteModificationService customTestSuiteModificationService;
    private final TestPlanItemDao testPlanItemDao;
    @PersistenceContext
    private EntityManager entityManager;

    public ExploratorySessionOverviewModificationServiceImpl(DSLContext dslContext, MilestoneDao milestoneDao, UserDao userDao, UserContextService userContextService, ExecutionCreationService executionCreationService, SprintDisplayDao sprintDisplayDao, CustomTestSuiteModificationService customTestSuiteModificationService, TestPlanItemDao testPlanItemDao) {
        this.dslContext = dslContext;
        this.milestoneDao = milestoneDao;
        this.userDao = userDao;
        this.userContextService = userContextService;
        this.executionCreationService = executionCreationService;
        this.sprintDisplayDao = sprintDisplayDao;
        this.customTestSuiteModificationService = customTestSuiteModificationService;
        this.testPlanItemDao = testPlanItemDao;
    }

    @Override
    @PreAuthorize(value="hasPermission(#overviewId, 'org.squashtest.tm.domain.campaign.ExploratorySessionOverview' ,'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public void updateDueDate(Long overviewId, Date dueDate) {
        ExploratorySessionOverview exploratorySessionOverview = (ExploratorySessionOverview)this.entityManager.find(ExploratorySessionOverview.class, (Object)overviewId);
        this.checkBlockingMilestoneOrClosedSprint(exploratorySessionOverview);
        exploratorySessionOverview.updateDueDate(dueDate);
    }

    @Override
    @PreAuthorize(value="hasPermission(#overviewId, 'org.squashtest.tm.domain.campaign.ExploratorySessionOverview' ,'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public void updateExecutionStatus(Long overviewId, String executionStatus) {
        TestPlanItem testPlanItem = this.testPlanItemDao.findByOverviewIdWithTestSuites(overviewId);
        ExploratorySessionOverview exploratorySessionOverview = testPlanItem.getExploratorySessionOverview();
        this.checkBlockingMilestoneOrClosedSprint(exploratorySessionOverview);
        User user = this.getCurrentUser();
        testPlanItem.applyFastPass(ExecutionStatus.valueOf((String)executionStatus), user);
        List testSuitesToUpdate = testPlanItem.getTestSuites();
        this.customTestSuiteModificationService.updateExecutionStatus(testSuitesToUpdate);
    }

    @Override
    @PreAuthorize(value="hasPermission(#overviewId, 'org.squashtest.tm.domain.campaign.ExploratorySessionOverview' ,'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public void updateSessionDuration(Long overviewId, Integer sessionDuration) {
        ExploratorySessionOverview exploratorySessionOverview = (ExploratorySessionOverview)this.entityManager.find(ExploratorySessionOverview.class, (Object)overviewId);
        this.checkBlockingMilestoneOrClosedSprint(exploratorySessionOverview);
        exploratorySessionOverview.updateSessionDuration(sessionDuration);
    }

    @Override
    @PreAuthorize(value="hasPermission(#overviewId, 'org.squashtest.tm.domain.campaign.ExploratorySessionOverview' ,'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public ExploratoryExecution addNewExecution(Long overviewId) {
        return this.addNewExecutionUnsecured(overviewId);
    }

    private ExploratoryExecution addNewExecutionUnsecured(Long overviewId) {
        ExploratorySessionOverview exploratorySessionOverview = (ExploratorySessionOverview)this.entityManager.find(ExploratorySessionOverview.class, (Object)overviewId);
        this.checkBlockingMilestoneOrClosedSprint(exploratorySessionOverview);
        Execution execution = this.executionCreationService.createManualExecution(exploratorySessionOverview.getTestPlanItem().getId());
        Wrapped exploratoryExecution = new Wrapped();
        ConsumerForExploratoryExecution consumer = new ConsumerForExploratoryExecution(arg_0 -> ((Wrapped)exploratoryExecution).setValue(arg_0));
        execution.accept((ExecutionVisitor)consumer);
        return (ExploratoryExecution)exploratoryExecution.getValue();
    }

    @Override
    @PreAuthorize(value="hasPermission(#overviewId, 'org.squashtest.tm.domain.campaign.ExploratorySessionOverview' ,'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public void startSessionAndUpdateExecutionStatus(Long overviewId) {
        ExploratorySessionOverview exploratorySessionOverview = (ExploratorySessionOverview)this.entityManager.find(ExploratorySessionOverview.class, (Object)overviewId);
        this.checkBlockingMilestoneOrClosedSprint(exploratorySessionOverview);
        exploratorySessionOverview.startSession(this.getCurrentUser());
    }

    @Override
    @PreAuthorize(value="hasPermission(#overviewId, 'org.squashtest.tm.domain.campaign.ExploratorySessionOverview' ,'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public void endSession(Long overviewId) {
        ExploratorySessionOverview exploratorySessionOverview = (ExploratorySessionOverview)this.entityManager.find(ExploratorySessionOverview.class, (Object)overviewId);
        this.checkBlockingMilestoneOrClosedSprint(exploratorySessionOverview);
        exploratorySessionOverview.endSession();
    }

    @Override
    @PreAuthorize(value="hasPermission(#overviewId, 'org.squashtest.tm.domain.campaign.ExploratorySessionOverview' ,'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public void updateComments(Long overviewId, String comments) {
        ExploratorySessionOverview exploratorySessionOverview = (ExploratorySessionOverview)this.entityManager.find(ExploratorySessionOverview.class, (Object)overviewId);
        this.checkBlockingMilestoneOrClosedSprint(exploratorySessionOverview);
        exploratorySessionOverview.updateComments(comments);
    }

    @Override
    @PreAuthorize(value="hasPermission(#overviewId, 'org.squashtest.tm.domain.campaign.ExploratorySessionOverview' ,'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public void addExecutionsWithUsers(Long overviewId, List<Long> userIds) {
        List users = this.userDao.findAllById(userIds);
        users.forEach(user -> this.addNewExecutionWithAssignee(overviewId, (User)user));
    }

    private void addNewExecutionWithAssignee(Long overviewId, User user) {
        ExploratoryExecution exploratoryExecution = this.addNewExecutionUnsecured(overviewId);
        exploratoryExecution.setAssigneeUser(user);
    }

    private void checkBlockingMilestoneOrClosedSprint(ExploratorySessionOverview overview) {
        Long testPlanItemId = this.findTestPlanItemId(overview.getId());
        if (this.milestoneDao.isTestPlanItemBoundToBlockingMilestone(testPlanItemId)) {
            throw new MilestoneForbidModificationException("This test plan item is linked to a blocking milestone and cannot be modified.");
        }
        if (SprintStatus.CLOSED.equals((Object)this.sprintDisplayDao.getSprintStatusBySessionOverviewId(overview.getId()))) {
            throw new SprintClosedException();
        }
    }

    private Long findTestPlanItemId(Long sessionOverviewId) {
        return (Long)this.dslContext.select((SelectField)org.squashtest.tm.jooq.domain.tables.TestPlanItem.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID).from((TableLike)org.squashtest.tm.jooq.domain.tables.TestPlanItem.TEST_PLAN_ITEM).where(org.squashtest.tm.jooq.domain.tables.TestPlanItem.TEST_PLAN_ITEM.OVERVIEW_ID.eq((Object)sessionOverviewId)).fetchOneInto(Long.class);
    }

    private User getCurrentUser() {
        String username = this.userContextService.getUsername();
        return this.userDao.findUserByLogin(username);
    }
}

