/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion.restoration.testcase;

import jakarta.persistence.EntityManager;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.BatchBindStep;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectOnConditionStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.Update;
import org.jooq.impl.DSL;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.TclnRelationship;
import org.squashtest.tm.jooq.domain.tables.TclnRelationshipClosure;
import org.squashtest.tm.jooq.domain.tables.TestCaseLibraryContent;
import org.squashtest.tm.service.deletion.NodeRenaming;
import org.squashtest.tm.service.deletion.NodeRestoreNameResolver;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.internal.deletion.NodeScope;
import org.squashtest.tm.service.internal.deletion.helper.testcase.TestCaseNodeScopeQueryHelper;
import org.squashtest.tm.service.internal.deletion.restoration.jdbc.AbstractJdbcRestorationHandler;
import org.squashtest.tm.service.internal.helper.JooqUpdateHelper;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

public class JdbcTestCaseNodeRestorationHandler
extends AbstractJdbcRestorationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcTestCaseNodeRestorationHandler.class);
    private static final String TEST_CASE_NODE = "test-case";
    private static final String FOLDER_NODE = "folder";
    private final NodeScope scope;
    private final NodeRestoreNameResolver nodeRestoreNameResolver;

    public JdbcTestCaseNodeRestorationHandler(EntityManager entityManager, DSLContext dslContext, NodeRestoreNameResolver nodeRestoreNameResolver, NodeScope scope) {
        super(entityManager, dslContext);
        this.nodeRestoreNameResolver = nodeRestoreNameResolver;
        this.scope = scope;
    }

    public OperationReport restoreNodes() {
        this.logStartProcess();
        List<NodeRenaming> renameNodes = this.renameRestoredNodes();
        Table<Record1<Long>> restorableNodesTable = this.buildRestorableNodesQuery();
        OperationReport report = this.buildRestoreOperationReport(restorableNodesTable, renameNodes);
        this.restoreTestPlanItems(restorableNodesTable);
        this.executeNodeRestoration(restorableNodesTable);
        this.logEndProcess();
        return report;
    }

    private Table<Record1<Long>> buildRestorableNodesQuery() {
        Object query = TestCaseNodeScopeQueryHelper.buildDeletedTestCaseNodeScopeQuery(this.scope, DSL.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID));
        if (this.scope.hasNodes()) {
            query = this.appendDeletedAncestorNodes((Select<Record1<Long>>)query);
        }
        return query.asTable("restorable_node");
    }

    private Select<Record1<Long>> appendDeletedAncestorNodes(Select<Record1<Long>> query) {
        return query.union((Select)DSL.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.in(this.scope.getNodeIds()).and(ConditionsConstants.TCLN_IN_BIN)));
    }

    private List<NodeRenaming> renameRestoredNodes() {
        Map<NodeType, List<NodeRenaming>> renamedNodes = this.nodeRestoreNameResolver.resolveDuplicateNamesInScope(this.scope);
        List<NodeRenaming> list = renamedNodes.values().stream().flatMap(Collection::stream).toList();
        if (list.isEmpty()) {
            return list;
        }
        BatchBindStep batch = this.dslContext.batch((Query)this.dslContext.update((Table)Tables.TEST_CASE_LIBRARY_NODE).set((Field)Tables.TEST_CASE_LIBRARY_NODE.NAME, null).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(null)));
        list.forEach(node -> {
            BatchBindStep batchBindStep2 = batch.bind(new Object[]{node.getName(), node.getNodeId()});
        });
        batch.execute();
        return list;
    }

    private OperationReport buildRestoreOperationReport(Table<Record1<Long>> restorableNodesTable, List<NodeRenaming> renamedNodes) {
        OperationReport report = new OperationReport();
        SelectOnConditionStep query = this.dslContext.select((SelectField)restorableNodesTable.field("TCLN_ID", Long.class).as("TCLN_ID"), (SelectField)Tables.TEST_CASE_FOLDER.TCLN_ID.isNotNull().as("IS_FOLDER")).from(restorableNodesTable).leftJoin((TableLike)Tables.TEST_CASE_FOLDER).on(restorableNodesTable.field("TCLN_ID", Long.class).eq((Field)Tables.TEST_CASE_FOLDER.TCLN_ID));
        Throwable throwable = null;
        Iterator<NodeRenaming> iterator = null;
        try (Stream stream = query.fetchStream();){
            Map partitioned = stream.collect(Collectors.partitioningBy(tuple -> (Boolean)tuple.get("IS_FOLDER", Boolean.class), Collectors.mapping(tuple -> (Long)tuple.get("TCLN_ID", Long.class), Collectors.toList())));
            report.addRestored(partitioned.getOrDefault(true, Collections.emptyList()), FOLDER_NODE);
            report.addRestored(partitioned.getOrDefault(false, Collections.emptyList()), TEST_CASE_NODE);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        for (NodeRenaming renaming : renamedNodes) {
            report.addRenamed(renaming);
        }
        return report;
    }

    private void restoreTestPlanItems(Table<Record1<Long>> restorableNodesTable) {
        JooqUpdateHelper.updateColumnsWithJoin(this.dslContext, restorableNodesTable, Tables.TEST_PLAN_ITEM.TCLN_ID.eq(restorableNodesTable.field("TCLN_ID", Long.class)), Map.of(Tables.TEST_PLAN_ITEM.DELETED, false));
    }

    private void executeNodeRestoration(Table<Record1<Long>> restorableNodesTable) {
        JooqUpdateHelper.nullifyColumnsWithJoin(this.dslContext, restorableNodesTable, Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(restorableNodesTable.field("TCLN_ID", Long.class)), Tables.TEST_CASE_LIBRARY_NODE.DELETED_ON, Tables.TEST_CASE_LIBRARY_NODE.DELETED_BY);
    }

    public Map<Long, Timestamp> transientlyRestoreLastOrderNodes() {
        Select<Record2<Long, Timestamp>> selectQuery = null;
        if (!this.scope.getLibraryIds().isEmpty()) {
            selectQuery = this.getLastOrderDeletedTclnOnLibrary(this.scope.getLibraryIds());
        }
        if (!this.scope.getNodeIds().isEmpty()) {
            Select<Record2<Long, Timestamp>> folderQuery = this.getLastOrderDeletedTclnOnFolder(this.scope.getNodeIds());
            Select<Record2<Long, Timestamp>> select = selectQuery = selectQuery == null ? folderQuery : selectQuery.union(folderQuery);
        }
        if (selectQuery == null) {
            return Collections.emptyMap();
        }
        return this.transientlyRestoreNodes(selectQuery);
    }

    public Map<Long, Timestamp> transientlyRestoreNestedeNodes() {
        Select selectQuery = this.getNestedDeletedTclnOnLibrary(this.scope.getLibraryIds(), this.scope.getNodeIds());
        if (!this.scope.getNodeIds().isEmpty()) {
            Select<Record2<Long, Timestamp>> folderQuery = this.getNestedDeletedTclnOnFolder(this.scope.getNodeIds());
            selectQuery = selectQuery.union(folderQuery);
        }
        return this.transientlyRestoreNodes(selectQuery);
    }

    public Map<Long, Timestamp> transientlyRestoreAllNodes() {
        Select selectQuery = this.getNestedDeletedTclnOnLibrary(this.scope.getLibraryIds(), this.scope.getNodeIds());
        if (!this.scope.getNodeIds().isEmpty()) {
            boolean isSameProject = this.sameProject();
            Select<Record2<Long, Timestamp>> folderQuery = isSameProject ? this.getNestedDeletedTclnOnFolder(this.scope.getNodeIds()) : this.getAllDeletedTclnOnFolder(this.scope.getNodeIds());
            selectQuery = selectQuery.union(folderQuery);
        }
        return this.transientlyRestoreNodes(selectQuery);
    }

    public void softDeleteTransientNodes(Map<Long, Timestamp> restoredNodes) {
        if (restoredNodes.isEmpty()) {
            return;
        }
        BatchBindStep batch = this.dslContext.batch((Query)this.dslContext.update((Table)Tables.TEST_CASE_LIBRARY_NODE).set((Field)Tables.TEST_CASE_LIBRARY_NODE.DELETED_ON, null).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(null)));
        restoredNodes.forEach((id, timestamp) -> {
            BatchBindStep batchBindStep2 = batch.bind(new Object[]{timestamp, id});
        });
        batch.execute();
    }

    private Map<Long, Timestamp> transientlyRestoreNodes(Select<Record2<Long, Timestamp>> selectQuery) {
        Map<Long, Timestamp> deletedOnByTclnId = selectQuery.fetch().stream().collect(Collectors.toMap(r -> (Long)r.get((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID), r -> (Timestamp)r.get((Field)Tables.TEST_CASE_LIBRARY_NODE.DELETED_ON)));
        if (deletedOnByTclnId.isEmpty()) {
            return deletedOnByTclnId;
        }
        Update<?> updateQuery = this.getRestoreTransientlyNodes(Objects.requireNonNull(selectQuery));
        updateQuery.execute();
        return deletedOnByTclnId;
    }

    private <R extends Record> Update<?> getRestoreTransientlyNodes(Select<R> restorableNodesQuery) {
        Table restorableNodesTable = restorableNodesQuery.asTable();
        return JooqUpdateHelper.getQueryNullifyColumnsWithJoin(this.dslContext, restorableNodesTable, Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(restorableNodesTable.field("TCLN_ID", Long.class)), Tables.TEST_CASE_LIBRARY_NODE.DELETED_ON);
    }

    private Select<Record2<Long, Timestamp>> getLastOrderDeletedTclnOnLibrary(Collection<Long> libraryIds) {
        Field order = DSL.field((String)"library_order_desc", Integer.class);
        SelectConditionStep contentMaxOrder = DSL.select((SelectField)Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID, (SelectField)DSL.rowNumber().over().partitionBy(new GroupField[]{Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID}).orderBy(new OrderField[]{Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ORDER.desc()}).as(order)).from((TableLike)Tables.TEST_CASE_LIBRARY_CONTENT).where(Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID.in(libraryIds));
        return this.dslContext.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.DELETED_ON).from((TableLike)contentMaxOrder).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(contentMaxOrder.field((Field)Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID))).where(Objects.requireNonNull(contentMaxOrder.field(order)).eq((Object)1)).and(ConditionsConstants.TCLN_IN_BIN);
    }

    private Select<Record2<Long, Timestamp>> getLastOrderDeletedTclnOnFolder(Collection<Long> nodeIds) {
        Field order = DSL.field((String)"closure_order_desc", Integer.class);
        SelectConditionStep relationshipMaxOrder = DSL.select((SelectField)Tables.TCLN_RELATIONSHIP.DESCENDANT_ID, (SelectField)DSL.rowNumber().over().partitionBy(new GroupField[]{Tables.TCLN_RELATIONSHIP.ANCESTOR_ID}).orderBy(new OrderField[]{Tables.TCLN_RELATIONSHIP.CONTENT_ORDER.desc()}).as(order)).from((TableLike)Tables.TCLN_RELATIONSHIP).where(Tables.TCLN_RELATIONSHIP.ANCESTOR_ID.in(nodeIds));
        return this.dslContext.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.DELETED_ON).from((TableLike)relationshipMaxOrder).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(relationshipMaxOrder.field((Field)Tables.TCLN_RELATIONSHIP.DESCENDANT_ID))).where(Objects.requireNonNull(relationshipMaxOrder.field(order)).eq((Object)1)).and(ConditionsConstants.TCLN_IN_BIN);
    }

    private Select<Record2<Long, Timestamp>> getNestedDeletedTclnOnLibrary(Set<Long> libraryIds, Set<Long> nodeIds) {
        TestCaseLibraryContent content = Tables.TEST_CASE_LIBRARY_CONTENT.as("tcln_content");
        return this.dslContext.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.DELETED_ON).from((TableLike)Tables.TEST_CASE_LIBRARY_CONTENT).join((TableLike)content).on(Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID.eq((Field)content.LIBRARY_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(content.CONTENT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(ConditionsConstants.TCLN_IN_BIN).and(Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID.in(libraryIds).or(Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID.in(nodeIds)));
    }

    private Select<Record2<Long, Timestamp>> getNestedDeletedTclnOnFolder(Collection<Long> tclnIds) {
        TclnRelationship closure = Tables.TCLN_RELATIONSHIP.as("tcln_closure");
        return this.dslContext.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.DELETED_ON).from((TableLike)Tables.TCLN_RELATIONSHIP).join((TableLike)closure).on(Tables.TCLN_RELATIONSHIP.ANCESTOR_ID.eq((Field)closure.ANCESTOR_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(closure.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(ConditionsConstants.TCLN_IN_BIN).and(Tables.TCLN_RELATIONSHIP.DESCENDANT_ID.in(tclnIds));
    }

    private Select<Record2<Long, Timestamp>> getAllDeletedTclnOnFolder(Collection<Long> tclnIds) {
        TclnRelationshipClosure closure = Tables.TCLN_RELATIONSHIP_CLOSURE.as("tcln_closure");
        return this.dslContext.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.DELETED_ON).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).join((TableLike)closure).on(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)closure.ANCESTOR_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(closure.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(ConditionsConstants.TCLN_IN_BIN).and(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.in(tclnIds));
    }

    private boolean sameProject() {
        SelectConditionStep projectIdTable = null;
        if (!this.scope.getLibraryIds().isEmpty()) {
            projectIdTable = DSL.select((SelectField)Tables.PROJECT.PROJECT_ID).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.TCL_ID.in(this.scope.getLibraryIds()));
        }
        if (!this.scope.getNodeIds().isEmpty()) {
            SelectConditionStep tclnProjectIdTable = DSL.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.in(this.scope.getNodeIds()));
            Object object = projectIdTable = projectIdTable == null ? tclnProjectIdTable : projectIdTable.union((Select)tclnProjectIdTable);
        }
        return this.dslContext.fetchCount(projectIdTable) == 1;
    }

    private void logStartProcess() {
        LOGGER.debug(String.format("Init restoration process of test case nodes. Scope %s. Operation:  %s", this.scope.summary(), this.operationId), new Object[0]);
    }

    private void logEndProcess() {
        LOGGER.info(String.format("Restored test case nodes in scope %s. Time elapsed %s", this.scope.summary(), this.startDate.until(LocalDateTime.now(), ChronoUnit.MILLIS)), new Object[0]);
    }
}

