/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.artificialintelligence.common;

import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.TextContent;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.squashtest.tm.service.internal.artificialintelligence.common.AbstractContentChunk;
import org.squashtest.tm.service.internal.artificialintelligence.common.ImageChunk;
import org.squashtest.tm.service.internal.artificialintelligence.common.TextChunk;

public final class ContentChunkConverter {
    private ContentChunkConverter() {
    }

    public static List<Content> convert(List<AbstractContentChunk> chunks) {
        return chunks.stream().flatMap(ContentChunkConverter::convertChunk).toList();
    }

    private static Stream<Content> convertChunk(AbstractContentChunk chunk) {
        if (chunk == null) {
            return Stream.empty();
        }
        AbstractContentChunk abstractContentChunk = chunk;
        Objects.requireNonNull(abstractContentChunk);
        AbstractContentChunk abstractContentChunk2 = abstractContentChunk;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextChunk.class, ImageChunk.class}, (Object)abstractContentChunk2, 0)) {
            case 0 -> {
                TextChunk textChunk = (TextChunk)abstractContentChunk2;
                yield ContentChunkConverter.convertTextChunk(textChunk);
            }
            case 1 -> {
                ImageChunk imageChunk = (ImageChunk)abstractContentChunk2;
                yield ContentChunkConverter.convertImageChunk(imageChunk);
            }
            default -> Stream.empty();
        };
    }

    private static Stream<Content> convertTextChunk(TextChunk chunk) {
        String cleanText = Jsoup.parse((String)(chunk.getText() != null ? chunk.getText() : "")).text();
        return cleanText.isEmpty() ? Stream.empty() : Stream.of(TextContent.from((String)cleanText));
    }

    private static Stream<Content> convertImageChunk(ImageChunk chunk) {
        String finalType = ContentChunkConverter.normalizeJpgToJpeg(chunk.getType());
        String cleanBase64 = chunk.getBase64().chars().filter(c -> !Character.isWhitespace(c)).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
        if (cleanBase64.isEmpty()) {
            return Stream.empty();
        }
        Image image = Image.builder().base64Data(cleanBase64).mimeType("image/" + finalType).build();
        return Stream.of(ImageContent.from((Image)image));
    }

    private static String normalizeJpgToJpeg(String value) {
        if (value == null) {
            return null;
        }
        return "jpg".equalsIgnoreCase(value) ? "jpeg" : value;
    }
}

