/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record1;
import org.jooq.Record3;
import org.jooq.Record5;
import org.jooq.Record6;
import org.jooq.Record7;
import org.jooq.Record8;
import org.jooq.Row1;
import org.jooq.Row2;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.Resource;
import org.squashtest.tm.jooq.domain.tables.RlnResource;
import org.squashtest.tm.service.internal.dto.ReqVersionMilestone;
import org.squashtest.tm.service.internal.repository.RequirementImportDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionCoverageDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;

@Repository
public class RequirementImportDaoImpl
implements RequirementImportDao {
    private static final RlnResource PARENT_RlN_RESOURCE = Tables.RLN_RESOURCE.as("PARENT_RLN_RESOURCE");
    private static final Resource PARENT_RESOURCE = Tables.RESOURCE.as("PARENT_RESOURCE");
    private static final String COMPUTED_PATH = "computedPath";
    private static final String COMPUTED_PATHS_TABLE = "computedPathsTable";
    private static final String INPUT_PATHS_TABLE = "inputPathsTable";
    private static final String NODE_NAMES = "nodeNames";
    private static final String PARENT_NODE = "parentNode";
    private final DSLContext dsl;
    private final RequirementVersionCoverageDao coverageDao;
    private final RequirementVersionDao requirementVersionDao;

    public RequirementImportDaoImpl(DSLContext dsl, RequirementVersionCoverageDao coverageDao, RequirementVersionDao requirementVersionDao) {
        this.dsl = dsl;
        this.coverageDao = coverageDao;
        this.requirementVersionDao = requirementVersionDao;
    }

    @Override
    public Stream<Record6<String, Long, Boolean, String, Long, String>> findRemoteSyncRequirements(Collection<String> remoteKeys, Collection<Long> remoteSyncId) {
        return this.dsl.select((SelectField)DSL.concat((Field[])new Field[]{Tables.PROJECT.NAME, DSL.value((String)"/"), DSL.groupConcat((Field)Tables.RESOURCE.NAME).orderBy(new OrderField[]{Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.desc()}).separator("/")}).cast(SQLDataType.VARCHAR((int)10000)), (SelectField)Tables.REQUIREMENT.RLN_ID.as("id"), (SelectField)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.isNotNull(), (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_PERIMETER_STATUS).from((TableLike)Tables.PROJECT).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID)).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).innerJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).innerJoin((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).innerJoin((TableLike)Tables.RLN_RESOURCE).on(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.RLN_RESOURCE.RLN_ID)).innerJoin((TableLike)Tables.RESOURCE).on(Tables.RLN_RESOURCE.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).leftJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID)).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.in(remoteKeys).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.in(remoteSyncId))).groupBy(new GroupField[]{Tables.PROJECT.NAME, Tables.REQUIREMENT.RLN_ID, Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID, Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID, Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_PERIMETER_STATUS}).fetchStream();
    }

    @Override
    public Stream<Record5<String, Long, Boolean, String, String>> findSyncRequirements(Collection<String> remoteKeys, String project) {
        return this.dsl.select((SelectField)DSL.concat((Field[])new Field[]{Tables.PROJECT.NAME, DSL.value((String)"/"), DSL.groupConcat((Field)Tables.RESOURCE.NAME).orderBy(new OrderField[]{Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.desc()}).separator("/")}).cast(SQLDataType.VARCHAR((int)10000)), (SelectField)Tables.REQUIREMENT.RLN_ID.as("id"), (SelectField)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.isNotNull(), (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_PERIMETER_STATUS).from((TableLike)Tables.PROJECT).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID)).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).innerJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).innerJoin((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).innerJoin((TableLike)Tables.RLN_RESOURCE).on(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.RLN_RESOURCE.RLN_ID)).innerJoin((TableLike)Tables.RESOURCE).on(Tables.RLN_RESOURCE.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).leftJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID)).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.in(remoteKeys).and(Tables.PROJECT.NAME.eq((Object)project)).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.isNull())).groupBy(new GroupField[]{Tables.PROJECT.NAME, Tables.REQUIREMENT.RLN_ID, Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID, Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_PERIMETER_STATUS}).fetchStream();
    }

    @Override
    public Stream<Record6<String, Long, Boolean, Boolean, String, Long>> findNodesByNamesAndProject(Collection<String> nodeNames, String projectName) {
        return this.dsl.select((SelectField)DSL.concat((Field[])new Field[]{Tables.PROJECT.NAME, DSL.value((String)"/"), DSL.groupConcat((Field)RequirementImportDaoImpl.PARENT_RESOURCE.NAME).orderBy(new OrderField[]{Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.desc()}).separator("/")}).cast(SQLDataType.VARCHAR((int)10000)), (SelectField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.as("id"), (SelectField)Tables.REQUIREMENT.RLN_ID.isNotNull(), (SelectField)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.isNotNull(), (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.as("SYNCHRONISATION_ID")).from((TableLike)Tables.PROJECT).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID)).innerJoin((TableLike)Tables.RLN_RESOURCE).on(Tables.RLN_RESOURCE.RLN_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).innerJoin((TableLike)Tables.RESOURCE).on(Tables.RLN_RESOURCE.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).innerJoin((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).innerJoin((TableLike)PARENT_RlN_RESOURCE).on(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)RequirementImportDaoImpl.PARENT_RlN_RESOURCE.RLN_ID)).innerJoin((TableLike)PARENT_RESOURCE).on(RequirementImportDaoImpl.PARENT_RlN_RESOURCE.RES_ID.eq((Field)RequirementImportDaoImpl.PARENT_RESOURCE.RES_ID)).leftJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).leftJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).leftJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID)).where(Tables.PROJECT.NAME.eq((Object)projectName).and(Tables.RESOURCE.NAME.in(nodeNames))).groupBy(new GroupField[]{Tables.PROJECT.NAME, Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, Tables.REQUIREMENT.RLN_ID, Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID, Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID}).fetchStream();
    }

    @Override
    public Stream<Record8<String, Long, Boolean, Boolean, String, Long, String, String>> findNodesByPathAndProject(Set<String> nodePaths, String projectName) {
        Table<Record1<String>> inputPaths = this.createInputPathsTable(nodePaths);
        Table<?> computedPaths = this.createComputedPathsTable(projectName);
        Field pathField = inputPaths.field("PATH", String.class);
        Field computedPathField = computedPaths.field(COMPUTED_PATH, String.class);
        Field computedRlnIdField = computedPaths.field("REQUIREMENT_LIBRARY_NODE_ID", Long.class);
        return this.dsl.select((SelectField)computedPathField, (SelectField)computedRlnIdField.as("id"), (SelectField)Tables.REQUIREMENT.RLN_ID.isNotNull(), (SelectField)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.isNotNull(), (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.as("SYNCHRONISATION_ID"), (SelectField)Tables.REMOTE_SYNCHRONISATION.KIND, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_PERIMETER_STATUS).from(inputPaths).innerJoin(computedPaths).on(pathField.eq(computedPathField)).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq(computedRlnIdField)).leftJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).leftJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID)).leftJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).leftJoin((TableLike)Tables.REMOTE_SYNCHRONISATION).on(Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID)).fetchStream();
    }

    private Table<?> createComputedPathsTable(String projectName) {
        Field computedPath = DSL.concat((Field[])new Field[]{Tables.PROJECT.NAME, DSL.val((String)"/"), DSL.groupConcat((Field)RequirementImportDaoImpl.PARENT_RESOURCE.NAME).orderBy(new OrderField[]{Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.desc()}).separator("/")}).cast(SQLDataType.VARCHAR((int)10000)).as(COMPUTED_PATH);
        return DSL.select((SelectField)computedPath, (SelectField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.as("REQUIREMENT_LIBRARY_NODE_ID")).from((TableLike)Tables.PROJECT).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID)).innerJoin((TableLike)Tables.RLN_RESOURCE).on(Tables.RLN_RESOURCE.RLN_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).innerJoin((TableLike)Tables.RESOURCE).on(Tables.RLN_RESOURCE.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).innerJoin((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).innerJoin((TableLike)PARENT_RlN_RESOURCE).on(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)RequirementImportDaoImpl.PARENT_RlN_RESOURCE.RLN_ID)).innerJoin((TableLike)PARENT_RESOURCE).on(RequirementImportDaoImpl.PARENT_RlN_RESOURCE.RES_ID.eq((Field)RequirementImportDaoImpl.PARENT_RESOURCE.RES_ID)).where(Tables.PROJECT.NAME.eq((Object)projectName)).groupBy(new GroupField[]{Tables.PROJECT.NAME, Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID}).asTable(COMPUTED_PATHS_TABLE);
    }

    private Table<Record1<String>> createInputPathsTable(Set<String> nodePaths) {
        Row1[] pathRows = (Row1[])nodePaths.stream().map(DSL::row).toArray(Row1[]::new);
        return DSL.values((Row1[])pathRows).as(INPUT_PATHS_TABLE, new String[]{"PATH"});
    }

    @Override
    public Stream<Record6<String, Long, Boolean, String, Long, String>> findRequirementsByNamesAndProjects(Collection<String> requirementNames, Collection<String> projects) {
        return this.dsl.select((SelectField)DSL.concat((Field[])new Field[]{Tables.PROJECT.NAME, DSL.value((String)"/"), DSL.groupConcat((Field)RequirementImportDaoImpl.PARENT_RESOURCE.NAME).orderBy(new OrderField[]{Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.desc()}).separator("/")}).cast(SQLDataType.VARCHAR((int)10000)), (SelectField)Tables.REQUIREMENT.RLN_ID.as("id"), (SelectField)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.isNotNull(), (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.as("SYNCHRONISATION_ID"), (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_PERIMETER_STATUS).from((TableLike)Tables.PROJECT).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID)).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).innerJoin((TableLike)Tables.RLN_RESOURCE).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.RLN_RESOURCE.RLN_ID)).innerJoin((TableLike)Tables.RESOURCE).on(Tables.RLN_RESOURCE.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).innerJoin((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).innerJoin((TableLike)PARENT_RlN_RESOURCE).on(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)RequirementImportDaoImpl.PARENT_RlN_RESOURCE.RLN_ID)).innerJoin((TableLike)PARENT_RESOURCE).on(RequirementImportDaoImpl.PARENT_RlN_RESOURCE.RES_ID.eq((Field)RequirementImportDaoImpl.PARENT_RESOURCE.RES_ID)).leftJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).leftJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID)).where(Tables.PROJECT.NAME.in(projects).and(Tables.RESOURCE.NAME.in(requirementNames))).groupBy(new GroupField[]{Tables.PROJECT.NAME, Tables.REQUIREMENT.RLN_ID, Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID, Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID, Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_PERIMETER_STATUS}).fetchStream();
    }

    @Override
    public Stream<Record7<String, Long, Boolean, String, Long, String, String>> findRequirementsByNamesParentNamesAndProject(Map<String, String> nodeNames, String project) {
        if (nodeNames == null || nodeNames.isEmpty()) {
            return Stream.empty();
        }
        Row2[] rows = (Row2[])nodeNames.entrySet().stream().map(entry -> DSL.row((Object)((String)entry.getKey()), (Object)((String)entry.getValue()))).toArray(Row2[]::new);
        Table nodeNamesTable = DSL.values((Row2[])rows).as(NODE_NAMES, new String[]{"NAME", PARENT_NODE});
        Field nameField = nodeNamesTable.field("NAME", String.class);
        Field parentField = nodeNamesTable.field(PARENT_NODE, String.class);
        return this.dsl.select((SelectField)DSL.concat((Field[])new Field[]{Tables.PROJECT.NAME, DSL.value((String)"/"), DSL.groupConcat((Field)RequirementImportDaoImpl.PARENT_RESOURCE.NAME).orderBy(new OrderField[]{Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.desc()}).separator("/")}).cast(SQLDataType.VARCHAR((int)10000)), (SelectField)Tables.REQUIREMENT.RLN_ID.as("id"), (SelectField)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.isNotNull(), (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.as("SYNCHRONISATION_ID"), (SelectField)Tables.REMOTE_SYNCHRONISATION.KIND, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_PERIMETER_STATUS).from((TableLike)Tables.PROJECT).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID)).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).innerJoin((TableLike)Tables.RLN_RESOURCE).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.RLN_RESOURCE.RLN_ID)).innerJoin((TableLike)Tables.RESOURCE).on(Tables.RLN_RESOURCE.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).innerJoin((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).innerJoin((TableLike)PARENT_RlN_RESOURCE).on(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)RequirementImportDaoImpl.PARENT_RlN_RESOURCE.RLN_ID)).innerJoin((TableLike)PARENT_RESOURCE).on(RequirementImportDaoImpl.PARENT_RlN_RESOURCE.RES_ID.eq((Field)RequirementImportDaoImpl.PARENT_RESOURCE.RES_ID)).leftJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).leftJoin((TableLike)Tables.REMOTE_SYNCHRONISATION).on(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Field)Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID)).leftJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID)).innerJoin((TableLike)nodeNamesTable).on(Tables.RESOURCE.NAME.eq(nameField)).and(RequirementImportDaoImpl.PARENT_RESOURCE.NAME.eq(parentField)).where(Tables.PROJECT.NAME.eq((Object)project)).groupBy(new GroupField[]{Tables.PROJECT.NAME, Tables.REQUIREMENT.RLN_ID, Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID, Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID, Tables.REMOTE_SYNCHRONISATION.KIND, Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_PERIMETER_STATUS}).fetchStream();
    }

    @Override
    public Map<Long, List<Long>> findVerifiedTestCaseIdsByVersionIds(Set<Long> versionIds) {
        if (versionIds.isEmpty()) {
            return new HashMap<Long, List<Long>>();
        }
        return this.coverageDao.findVerifiedTestCaseIdsByVersionIds(versionIds);
    }

    @Override
    public Map<Long, Map<Long, Long>> findExistingCoveragesByRequirementIds(Collection<Long> requirementIds) {
        if (requirementIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.coverageDao.findExistingCoveragesByRequirementIds(requirementIds);
    }

    @Override
    public Map<Long, RequirementStatus> findRequirementStatusesByVersionIds(Collection<Long> versionIds) {
        if (versionIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.requirementVersionDao.findRequirementStatusesByVersionIds(versionIds);
    }

    @Override
    public Map<Long, RequirementStatus> findRequirementStatusesByRequirementIds(Collection<Long> requirementIds) {
        if (requirementIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.requirementVersionDao.findRequirementStatusesByRequirementIds(requirementIds);
    }

    @Override
    public Map<Long, Map<Long, Long>> findExistingLinksByVersionIds(Collection<Long> versionIds) {
        if (versionIds.isEmpty()) {
            return Collections.emptyMap();
        }
        SelectConditionStep query = this.dsl.select((SelectField)Tables.REQUIREMENT_VERSION_LINK.REQUIREMENT_VERSION_ID, (SelectField)Tables.REQUIREMENT_VERSION_LINK.RELATED_REQUIREMENT_VERSION_ID, (SelectField)Tables.REQUIREMENT_VERSION_LINK.LINK_ID).from((TableLike)Tables.REQUIREMENT_VERSION_LINK).where(Tables.REQUIREMENT_VERSION_LINK.REQUIREMENT_VERSION_ID.in(versionIds).and(Tables.REQUIREMENT_VERSION_LINK.RELATED_REQUIREMENT_VERSION_ID.in(versionIds)));
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream stream = query.fetchStream();){
            return stream.collect(Collectors.groupingBy(Record3::value1, Collectors.toMap(Record3::value2, Record3::value3)));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Map<Long, Map<Integer, ReqVersionMilestone>> findReqVersionAndMilestonesByReqId(Collection<Long> requirementIds) {
        if (requirementIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Map<Integer, ReqVersionMilestone>> result = new HashMap<Long, Map<Integer, ReqVersionMilestone>>();
        SelectConditionStep query = this.dsl.select((SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID, (SelectField)Tables.REQUIREMENT_VERSION.RES_ID, (SelectField)Tables.REQUIREMENT_VERSION.VERSION_NUMBER, (SelectField)Tables.MILESTONE.LABEL, (SelectField)Tables.MILESTONE.STATUS).from((TableLike)Tables.REQUIREMENT_VERSION).leftJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.in(requirementIds));
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream stream = query.fetchStream();){
            stream.forEach(r -> {
                Long requirementId = (Long)r.value1();
                Long reqVersionId = (Long)r.value2();
                Integer versionNumber = (Integer)r.value3();
                String label = (String)r.value4();
                String status = (String)r.value5();
                Map reqVersionMilestoneByReq = result.computeIfAbsent(requirementId, k -> new HashMap());
                ReqVersionMilestone reqVersionMilestone = reqVersionMilestoneByReq.computeIfAbsent(versionNumber, k -> new ReqVersionMilestone(reqVersionId));
                if (label != null && status != null) {
                    reqVersionMilestone.addMilestone(label, status);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    @Override
    public String getDefaultRequirementVersionLinkRole() {
        return (String)this.dsl.select((SelectField)Tables.REQUIREMENT_VERSION_LINK_TYPE.ROLE_2_CODE).from((TableLike)Tables.REQUIREMENT_VERSION_LINK_TYPE).where(Tables.REQUIREMENT_VERSION_LINK_TYPE.IS_DEFAULT.eq((Object)true)).fetchOneInto(String.class);
    }

    @Override
    public Map<Long, Long> findExistingHighLevelLinksByRequirementIds(Collection<Long> requirementIds) {
        if (requirementIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.dsl.select((SelectField)Tables.REQUIREMENT.RLN_ID, (SelectField)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID).from((TableLike)Tables.REQUIREMENT).where(Tables.REQUIREMENT.RLN_ID.in(requirementIds)).fetchMap((Field)Tables.REQUIREMENT.RLN_ID, (Field)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID);
    }

    @Override
    public Set<Long> filterRequirementChild(Collection<Long> requirementIds) {
        if (requirementIds.isEmpty()) {
            return Collections.emptySet();
        }
        return this.dsl.select((SelectField)Tables.RLN_RELATIONSHIP.DESCENDANT_ID).from((TableLike)Tables.RLN_RELATIONSHIP).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.RLN_RELATIONSHIP.ANCESTOR_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).where(Tables.RLN_RELATIONSHIP.DESCENDANT_ID.in(requirementIds)).fetchSet((Field)Tables.RLN_RELATIONSHIP.DESCENDANT_ID);
    }
}

