/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl.collectors.libraries;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record4;
import org.jooq.SelectField;
import org.jooq.SelectJoinStep;
import org.jooq.SelectOnConditionStep;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.records.ProjectRecord;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TreeNodeCollector;
import org.squashtest.tm.service.internal.repository.display.impl.collectors.AbstractTreeNodeCollector;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

@Component
public abstract class AbstractLibraryCollector
extends AbstractTreeNodeCollector
implements TreeNodeCollector {
    protected AbstractLibraryCollector(DSLContext dsl, CustomFieldValueDisplayDao customFieldValueDisplayDao, ActiveMilestoneHolder activeMilestoneHolder, MilestoneDisplayDao milestoneDisplayDao) {
        super(dsl, customFieldValueDisplayDao, activeMilestoneHolder, milestoneDisplayDao);
    }

    @Override
    protected Map<Long, DataRow> doCollect(List<Long> ids) {
        SelectOnConditionStep baseQuery = this.dsl.select(this.getLibraryPrimaryKeyColumn(), (SelectField)Tables.PROJECT.PROJECT_ID.as("projectId"), (SelectField)Tables.PROJECT.NAME, (SelectField)DSL.count(this.getContentIdColumnInContentTable()).as("CHILD_COUNT")).from(this.getLibraryTable()).innerJoin((TableLike)Tables.PROJECT).using(new Field[]{this.getLibraryColumnInProjectTable()}).leftJoin(this.getLibraryContentTable()).on(this.getLibraryPrimaryKeyColumn().eq(this.getLibraryIdColumnInContentTable()));
        this.addAdditionalJoins((SelectJoinStep<Record4<Long, Long, String, Integer>>)baseQuery);
        Map<Long, DataRow> libraryRows = baseQuery.where(this.getLibraryPrimaryKeyColumn().in(ids)).groupBy(new GroupField[]{Tables.PROJECT.PROJECT_ID, this.getLibraryPrimaryKeyColumn()}).fetch().stream().collect(Collectors.toMap(tuple -> (Long)tuple.get(this.getLibraryPrimaryKeyColumn()), tuple -> {
            DataRow dataRow = new DataRow();
            dataRow.setId(new NodeReference(this.getHandledEntityType(), (Long)tuple.get(this.getLibraryPrimaryKeyColumn())).toNodeId());
            dataRow.setProjectId((Long)tuple.get("projectId", Long.class));
            dataRow.setState((Integer)tuple.get("CHILD_COUNT", Integer.class) > 0 ? DataRow.State.closed : DataRow.State.leaf);
            dataRow.setData(tuple.intoMap());
            return dataRow;
        }));
        this.appendMilestonesByProject(libraryRows);
        return libraryRows;
    }

    protected abstract TableField<ProjectRecord, Long> getLibraryColumnInProjectTable();

    protected abstract Field<Long> getLibraryIdColumnInContentTable();

    protected abstract Field<Long> getContentIdColumnInContentTable();

    protected abstract Table<?> getLibraryContentTable();

    protected abstract Table<?> getLibraryTable();

    protected abstract TableField<?, Long> getLibraryPrimaryKeyColumn();

    protected void addAdditionalJoins(SelectJoinStep<Record4<Long, Long, String, Integer>> baseQuery) {
    }
}

