/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record4;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.customreport.CustomReportTreeDefinition;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.LibraryDto;
import org.squashtest.tm.service.internal.display.dto.customreports.ChartDefinitionDto;
import org.squashtest.tm.service.internal.display.dto.customreports.CustomReportFolderDto;
import org.squashtest.tm.service.internal.repository.display.CustomReportDisplayDao;

@Repository
public class CustomReportDisplayDaoImpl
implements CustomReportDisplayDao {
    private final DSLContext dslContext;

    public CustomReportDisplayDaoImpl(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public ChartDefinitionDto findChartDefinitionByNodeId(Long customReportLibraryNodeId) {
        return (ChartDefinitionDto)this.dslContext.select((SelectField)Tables.CHART_DEFINITION.NAME, (SelectField)Tables.CHART_DEFINITION.CHART_ID.as("ID"), (SelectField)Tables.CHART_DEFINITION.PROJECT_ID, (SelectField)Tables.CUSTOM_REPORT_LIBRARY_NODE.CRLN_ID.as("CUSTOM_REPORT_LIBRARY_NODE_ID")).from((TableLike)Tables.CHART_DEFINITION).innerJoin((TableLike)Tables.CUSTOM_REPORT_LIBRARY_NODE).on(Tables.CHART_DEFINITION.CHART_ID.eq((Field)Tables.CUSTOM_REPORT_LIBRARY_NODE.ENTITY_ID)).where(Tables.CUSTOM_REPORT_LIBRARY_NODE.CRLN_ID.eq((Object)customReportLibraryNodeId)).and(Tables.CUSTOM_REPORT_LIBRARY_NODE.ENTITY_TYPE.eq((Object)CustomReportTreeDefinition.CHART.name())).fetchOneInto(ChartDefinitionDto.class);
    }

    @Override
    public LibraryDto getCustomReportLibraryDtoByNodeId(Long nodeId) {
        return (LibraryDto)((Record4)this.dslContext.select((SelectField)Tables.CUSTOM_REPORT_LIBRARY_NODE.CRLN_ID.as("ID"), (SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.DESCRIPTION, (SelectField)Tables.PROJECT.NAME).from((TableLike)Tables.CUSTOM_REPORT_LIBRARY_NODE).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.CRL_ID.eq((Field)Tables.CUSTOM_REPORT_LIBRARY_NODE.CRL_ID)).where(Tables.CUSTOM_REPORT_LIBRARY_NODE.CRLN_ID.eq((Object)nodeId)).fetchOne()).into(LibraryDto.class);
    }

    @Override
    public CustomReportFolderDto getCustomReportFolderDtoByNodeId(long nodeId) {
        return (CustomReportFolderDto)((Record4)this.dslContext.select((SelectField)Tables.CUSTOM_REPORT_LIBRARY_NODE.CRLN_ID.as("ID"), (SelectField)Tables.CUSTOM_REPORT_LIBRARY_NODE.NAME, (SelectField)Tables.CUSTOM_REPORT_FOLDER.DESCRIPTION, (SelectField)Tables.CUSTOM_REPORT_FOLDER.PROJECT_ID).from((TableLike)Tables.CUSTOM_REPORT_LIBRARY_NODE).innerJoin((TableLike)Tables.CUSTOM_REPORT_FOLDER).on(Tables.CUSTOM_REPORT_FOLDER.CRF_ID.eq((Field)Tables.CUSTOM_REPORT_LIBRARY_NODE.ENTITY_ID)).where(Tables.CUSTOM_REPORT_LIBRARY_NODE.CRLN_ID.eq((Object)nodeId)).fetchOne()).into(CustomReportFolderDto.class);
    }
}

