/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.trash;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.service.display.trash.TestCaseBinTreeService;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.TreeGridResponse;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.repository.TestCaseBinTreeDao;
import org.squashtest.tm.service.project.CustomProjectFinder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.user.UserAccountService;

@Service
@Transactional(readOnly=true)
public class TestCaseBinTreeServiceImpl
implements TestCaseBinTreeService {
    private final TestCaseBinTreeDao binTreeRepository;
    private final UserAccountService userAccountService;
    private final CustomProjectFinder projectFinder;
    private final PermissionEvaluationService permissionEvaluationService;

    public TestCaseBinTreeServiceImpl(TestCaseBinTreeDao binTreeRepository, UserAccountService userAccountService, CustomProjectFinder projectFinder, PermissionEvaluationService permissionEvaluationService) {
        this.binTreeRepository = binTreeRepository;
        this.userAccountService = userAccountService;
        this.projectFinder = projectFinder;
        this.permissionEvaluationService = permissionEvaluationService;
    }

    @Override
    public TreeGridResponse getRootBinTree() {
        List<Long> projectIds = this.getPermittedProjectIds();
        TreeGridResponse treeGridResponse = new TreeGridResponse();
        if (projectIds.isEmpty()) {
            return treeGridResponse;
        }
        List<Long> libraryIdsWithDeletedNodes = this.binTreeRepository.findLibraryIdsWithDeletedNodesByProject(projectIds);
        if (libraryIdsWithDeletedNodes.isEmpty()) {
            return treeGridResponse;
        }
        List<DataRow> dataRows = this.binTreeRepository.getLibrariesDataRows(libraryIdsWithDeletedNodes).values().stream().toList();
        treeGridResponse.setDataRows(dataRows);
        treeGridResponse.setCount(this.binTreeRepository.countDeletedNodesByLibraries(libraryIdsWithDeletedNodes));
        return treeGridResponse;
    }

    private List<Long> getPermittedProjectIds() {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        List<Long> projectIds = this.projectFinder.findAllManageableIds(currentUser);
        if (projectIds.isEmpty() && !currentUser.isAdmin()) {
            throw new AccessDeniedException("You do not have permission to access any projects.");
        }
        return projectIds;
    }

    @Override
    public TreeGridResponse findSubHierarchy(Set<NodeReference> sources, Set<NodeReference> openNodes) {
        Map<NodeType, List<NodeReference>> openNodesByType = openNodes.stream().collect(Collectors.groupingBy(NodeReference::getNodeType));
        this.checkNodesPermissions(openNodesByType);
        Map childrenByParentReference = openNodesByType.entrySet().stream().flatMap(entry -> switch ((NodeType)entry.getKey()) {
            case NodeType.TEST_CASE_LIBRARY -> this.binTreeRepository.findLibrariesChildren((List)entry.getValue()).entrySet().stream();
            case NodeType.TEST_CASE_FOLDER -> this.binTreeRepository.findFoldersChildren((List)entry.getValue()).entrySet().stream();
            default -> Stream.empty();
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (existing, replacement) -> existing, LinkedHashMap::new));
        Map<NodeReference, DataRow> nodeDataRows = this.getDataRows(childrenByParentReference.values().stream().flatMap(Collection::stream).toList(), sources);
        childrenByParentReference.forEach((parent, children) -> {
            DataRow parentRow = (DataRow)nodeDataRows.get(parent);
            if (parentRow != null) {
                parentRow.setState(DataRow.State.open);
                parentRow.setChildren(NodeReference.toNodeIds((Collection)children));
                children.forEach(child -> ((DataRow)nodeDataRows.get(child)).setParentRowId(parentRow.getId()));
            }
        });
        TreeGridResponse treeGridResponse = new TreeGridResponse();
        treeGridResponse.setDataRows(new ArrayList<DataRow>(nodeDataRows.values()));
        return treeGridResponse;
    }

    private void checkNodesPermissions(Map<NodeType, List<NodeReference>> nodesByType) {
        List<Long> projectIds = this.binTreeRepository.retrieveProjectIdsByNodes(nodesByType);
        this.permissionEvaluationService.checkPermission(projectIds, Permissions.MANAGE_PROJECT.name(), Project.class.getName());
    }

    private Map<NodeReference, DataRow> getDataRows(List<NodeReference> children, Set<NodeReference> sources) {
        HashSet<NodeReference> references = new HashSet<NodeReference>(children);
        references.addAll(sources);
        return references.stream().collect(Collectors.groupingBy(NodeReference::getNodeType, Collectors.mapping(NodeReference::getId, Collectors.toList()))).entrySet().stream().flatMap(entry -> switch ((NodeType)entry.getKey()) {
            case NodeType.TEST_CASE_LIBRARY -> this.binTreeRepository.getLibrariesDataRows((Collection)entry.getValue()).entrySet().stream();
            case NodeType.TEST_CASE_FOLDER -> this.binTreeRepository.getFoldersDataRows((Collection)entry.getValue()).entrySet().stream();
            case NodeType.TEST_CASE -> this.binTreeRepository.getTestCasesDataRows((List)entry.getValue()).entrySet().stream();
            default -> Stream.empty();
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public TreeGridResponse refreshNodes(Set<NodeReference> sources, Set<NodeReference> openNodes) {
        this.filterLibrariesWithoutDeletedNodes(sources, openNodes);
        TreeGridResponse treeGridResponse = this.findSubHierarchy(sources, openNodes);
        List<Long> projectIds = this.getPermittedProjectIds();
        treeGridResponse.setCount(this.binTreeRepository.countDeletedNodesByProjects(projectIds));
        return treeGridResponse;
    }

    private void filterLibrariesWithoutDeletedNodes(Set<NodeReference> sources, Set<NodeReference> openNodes) {
        Set<NodeReference> libraries = sources.stream().filter(nodeRef -> NodeType.TEST_CASE_LIBRARY.equals((Object)nodeRef.getNodeType())).collect(Collectors.toSet());
        if (libraries.isEmpty()) {
            return;
        }
        List<Long> librariesWithDeletedNodes = this.getLibrariesWithDeletedNodes(libraries);
        Set librariesToRemove = libraries.stream().filter(nodeRef -> !librariesWithDeletedNodes.contains(nodeRef.getId())).collect(Collectors.toSet());
        if (!librariesToRemove.isEmpty()) {
            sources.removeAll(librariesToRemove);
            openNodes.removeAll(librariesToRemove);
        }
    }

    private List<Long> getLibrariesWithDeletedNodes(Set<NodeReference> libraries) {
        List<Long> libraryIds = libraries.stream().map(NodeReference::getId).toList();
        return this.binTreeRepository.filterLibraryIdsWithDeletedNodes(libraryIds);
    }
}

