/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.clipboard;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.service.clipboard.ClipboardService;
import org.squashtest.tm.service.internal.repository.CustomReportLibraryNodeDao;
import org.squashtest.tm.service.internal.repository.JooqIterationDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateCampaignLibraryNodeDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateRequirementLibraryNodeDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateTestCaseLibraryNodeDao;

@Service
public class ClipboardServiceImpl
implements ClipboardService {
    private final CustomReportLibraryNodeDao customReportLibraryNodeDao;
    private final HibernateCampaignLibraryNodeDao campaignLibraryNodeDao;
    private final HibernateRequirementLibraryNodeDao requirementLibraryNodeDao;
    private final HibernateTestCaseLibraryNodeDao testCaseLibraryNodeDao;
    private final JooqIterationDao iterationDao;

    public ClipboardServiceImpl(CustomReportLibraryNodeDao customReportLibraryNodeDao, HibernateCampaignLibraryNodeDao campaignLibraryNodeDao, HibernateRequirementLibraryNodeDao requirementLibraryNodeDao, HibernateTestCaseLibraryNodeDao testCaseLibraryNodeDao, JooqIterationDao iterationDao) {
        this.customReportLibraryNodeDao = customReportLibraryNodeDao;
        this.campaignLibraryNodeDao = campaignLibraryNodeDao;
        this.requirementLibraryNodeDao = requirementLibraryNodeDao;
        this.testCaseLibraryNodeDao = testCaseLibraryNodeDao;
        this.iterationDao = iterationDao;
    }

    @Override
    public List<NodeReference> copyNodes(List<NodeReference> sourceNodeList) {
        return sourceNodeList.stream().collect(Collectors.collectingAndThen(Collectors.groupingBy(node -> NodeCategory.fromNodeType(node.getNodeType()), Collectors.mapping(NodeReference::getId, Collectors.toSet())), map -> map.entrySet().stream().flatMap(entry -> this.getAllChildReferences((NodeCategory)((Object)((Object)((Object)entry.getKey()))), (Set)entry.getValue()).stream()).toList()));
    }

    private List<NodeReference> getAllChildReferences(NodeCategory nodeCategory, Set<Long> ids) {
        return switch (nodeCategory) {
            case NodeCategory.CAMPAIGN_CATEGORY -> this.campaignLibraryNodeDao.findAllChildReferences(ids);
            case NodeCategory.REQUIREMENT_CATEGORY -> this.requirementLibraryNodeDao.findAllChildReferences(ids);
            case NodeCategory.TEST_CASE_CATEGORY -> this.testCaseLibraryNodeDao.findAllChildReferences(ids);
            case NodeCategory.CUSTOM_REPORT_CATEGORY -> this.customReportLibraryNodeDao.findAllChildReferenceFromFolders(ids);
            case NodeCategory.ITERATION_CATEGORY -> this.iterationDao.findAllChildReferences(ids);
            case NodeCategory.OTHER_CATEGORY -> List.of();
            default -> throw new MatchException(null, null);
        };
    }

    private static enum NodeCategory {
        CAMPAIGN_CATEGORY,
        REQUIREMENT_CATEGORY,
        TEST_CASE_CATEGORY,
        CUSTOM_REPORT_CATEGORY,
        ITERATION_CATEGORY,
        OTHER_CATEGORY;


        private static NodeCategory fromNodeType(NodeType nodeType) {
            return switch (nodeType) {
                case NodeType.CAMPAIGN_FOLDER, NodeType.CAMPAIGN, NodeType.SPRINT_GROUP -> CAMPAIGN_CATEGORY;
                case NodeType.REQUIREMENT_FOLDER, NodeType.REQUIREMENT, NodeType.HIGH_LEVEL_REQUIREMENT -> REQUIREMENT_CATEGORY;
                case NodeType.TEST_CASE_FOLDER -> TEST_CASE_CATEGORY;
                case NodeType.CUSTOM_REPORT_FOLDER -> CUSTOM_REPORT_CATEGORY;
                case NodeType.ITERATION -> ITERATION_CATEGORY;
                case NodeType.TEST_CASE, NodeType.TEST_SUITE, NodeType.SPRINT, NodeType.CHART_DEFINITION, NodeType.CUSTOM_REPORT_CUSTOM_EXPORT, NodeType.CUSTOM_REPORT_DASHBOARD, NodeType.REPORT_DEFINITION, NodeType.ACTION_WORD -> OTHER_CATEGORY;
                default -> throw new IllegalArgumentException(String.format("This type '%s' is not handled", nodeType));
            };
        }
    }
}

