/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign.export.dao;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jooq.CommonTableExpression;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.ResultQuery;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.campaign.export.dao.CampaignExportDao;
import org.squashtest.tm.service.internal.campaign.export.dao.AbstractCampaignExportDao;
import org.squashtest.tm.service.internal.dto.CustomFieldValueDto;
import org.squashtest.tm.service.internal.jooq.SubElementRecordProcessor;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

@Repository(value="squashtest.tm.service.CampaignExportSimpleDao")
public class CampaignExportSimpleDaoImpl
extends AbstractCampaignExportDao
implements CampaignExportDao {
    public CampaignExportSimpleDaoImpl(DSLContext dsl) {
        super(dsl);
    }

    @Override
    public Map<BindableEntity, List<String>> getCufHeaderQuery(Long campaignId, List<BindableEntity> bindableEntities) {
        return super.getCufHeaderQuery(campaignId, bindableEntities);
    }

    @Override
    public Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> getCufProcessors(Long campaignId) {
        return Map.of(BindableEntity.CAMPAIGN, this.getCufProcessor(this.getCampaignCufQuery(campaignId)), BindableEntity.ITERATION, this.getCufProcessor(this.getIterationCufQuery(campaignId)), BindableEntity.TEST_CASE, this.getCufProcessor(this.getTestCaseCufQuery(campaignId)));
    }

    @Override
    public ResultQuery<Record> getQuery(Long campaignId) {
        CommonTableExpression<Record> lastExecutionCte = this.getLastExecutionQueryCte(campaignId, List.of());
        CommonTableExpression<Record1<Long>> testCaseIdsCte = this.getTestCaseIdsCte(campaignId);
        Table<Record2<Long, Integer>> testCaseCoverageCountsTable = this.getTestCaseCoverageCountsTable(testCaseIdsCte);
        Table<Record2<Long, Integer>> executionIssueCountsTable = this.getExecutionIssueCountsTable(lastExecutionCte);
        Table<Record2<Long, String>> testCaseMilestoneTable = this.getTestCaseMilestone(testCaseIdsCte);
        Table<Record2<Long, String>> testSuiteTable = this.getTestSuiteNames(campaignId);
        Table<Record2<Long, String>> campaignMilestoneTable = this.getCampaignMilestones(campaignId);
        return this.dsl.with(new CommonTableExpression[]{lastExecutionCte, testCaseIdsCte}).select(new SelectFieldOrAsterisk[]{Tables.CAMPAIGN.CLN_ID, Tables.CAMPAIGN.SCHEDULED_START_DATE, Tables.CAMPAIGN.SCHEDULED_END_DATE, Tables.CAMPAIGN.ACTUAL_START_DATE, Tables.CAMPAIGN.ACTUAL_END_DATE, campaignMilestoneTable.field((Field)Tables.MILESTONE.LABEL), Tables.ITERATION.ITERATION_ID, Tables.CAMPAIGN_ITERATION.ITERATION_ORDER, Tables.ITERATION.NAME, Tables.ITERATION.SCHEDULED_START_DATE, Tables.ITERATION.SCHEDULED_END_DATE, Tables.ITERATION.ACTUAL_START_DATE, Tables.ITERATION.ACTUAL_END_DATE, testSuiteTable.field(AbstractCampaignExportDao.SUITE_NAMES), Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, Tables.TEST_PLAN_ITEM.ITEM_ORDER, Tables.TEST_PLAN_ITEM.EXECUTION_STATUS, Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON, Tables.CORE_USER.LOGIN, Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TEST_CASE_LIBRARY_NODE.NAME, Tables.TEST_CASE.REFERENCE, Tables.TEST_CASE.TC_STATUS, Tables.TEST_CASE.IMPORTANCE, AbstractCampaignExportDao.TC_NATURE_TABLE.CODE, AbstractCampaignExportDao.TC_TYPE_TABLE.CODE, Tables.DATASET.NAME, DSL.coalesce((Object)testCaseCoverageCountsTable.field(AbstractCampaignExportDao.TC_COVERAGE_COUNT), (Object[])new Serializable[]{Integer.valueOf(0)}).as(AbstractCampaignExportDao.TC_COVERAGE_COUNT), DSL.coalesce((Field)testCaseMilestoneTable.field(AbstractCampaignExportDao.TC_MILESTONE_LABELS), (Object)"").as(AbstractCampaignExportDao.TC_MILESTONE_LABELS), Tables.PROJECT.NAME, Objects.requireNonNull(lastExecutionCte.field((Field)Tables.EXECUTION.EXECUTION_ID)).as((Field)Tables.EXECUTION.EXECUTION_ID), DSL.coalesce((Object)lastExecutionCte.field(AbstractCampaignExportDao.EXECUTION_COUNT), (Object[])new Serializable[]{Integer.valueOf(0)}).as(AbstractCampaignExportDao.EXECUTION_COUNT), DSL.coalesce((Object)executionIssueCountsTable.field(AbstractCampaignExportDao.EXECUTION_ISSUE_COUNT), (Object[])new Serializable[]{Integer.valueOf(0)}).as(AbstractCampaignExportDao.EXECUTION_ISSUE_COUNT)}).from((TableLike)Tables.CAMPAIGN).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.DATASET).on(Tables.DATASET.DATASET_ID.eq((Field)Tables.TEST_PLAN_ITEM.DATASET_ID).and(Tables.DATASET.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID))).leftJoin((TableLike)Tables.CORE_USER).on(Tables.CORE_USER.LOGIN.eq((Field)Tables.TEST_PLAN_ITEM.LAST_EXECUTED_BY)).leftJoin(campaignMilestoneTable).on(Tables.CAMPAIGN.CLN_ID.eq(campaignMilestoneTable.field((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID))).leftJoin(testSuiteTable).on(Objects.requireNonNull(testSuiteTable.field((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).leftJoin(lastExecutionCte).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(lastExecutionCte.field((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID))).leftJoin(executionIssueCountsTable).on(Objects.requireNonNull(executionIssueCountsTable.field((Field)Tables.EXECUTION.EXECUTION_ID)).eq(lastExecutionCte.field((Field)Tables.EXECUTION.EXECUTION_ID))).leftJoin((TableLike)AbstractCampaignExportDao.TC_NATURE_TABLE).on(AbstractCampaignExportDao.TC_NATURE_TABLE.ITEM_ID.eq((Field)Tables.TEST_CASE.TC_NATURE)).leftJoin((TableLike)AbstractCampaignExportDao.TC_TYPE_TABLE).on(AbstractCampaignExportDao.TC_TYPE_TABLE.ITEM_ID.eq((Field)Tables.TEST_CASE.TC_TYPE)).leftJoin(testCaseMilestoneTable).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(testCaseMilestoneTable.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID))).leftJoin(testCaseCoverageCountsTable).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(testCaseCoverageCountsTable.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID))).leftJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).where(Tables.CAMPAIGN.CLN_ID.eq((Object)campaignId)).orderBy((OrderField)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER, (OrderField)Tables.TEST_PLAN_ITEM.ITEM_ORDER).fetchSize(AbstractCampaignExportDao.BATCH_SIZE.intValue());
    }
}

