/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchexport.models;

import java.util.Comparator;
import org.apache.commons.lang3.builder.ToStringBuilder;

public final class RequirementLinkModel {
    public static final Comparator<RequirementLinkModel> REQ_LINK_COMPARATOR = new Comparator<RequirementLinkModel>(){

        @Override
        public int compare(RequirementLinkModel o1, RequirementLinkModel o2) {
            int comp = o1.getReqPath().compareTo(o2.getReqPath());
            if (comp != 0) {
                return comp;
            }
            comp = o1.getReqVersion() - o2.getReqVersion();
            if (comp != 0) {
                return comp;
            }
            comp = o1.getRelReqPath().compareTo(o2.getRelReqPath());
            if (comp != 0) {
                return comp;
            }
            comp = o1.getRelReqVersion() - o2.getRelReqVersion();
            return comp;
        }
    };
    private Long reqId;
    private Long relReqId;
    private int reqVersion;
    private int relReqVersion;
    private String relatedReqRole;
    private String reqPath;
    private String relReqPath;

    public RequirementLinkModel(Long reqId, Long relReqId, int reqVersion, int relReqVersion, String relatedReqRole) {
        this.reqId = reqId;
        this.relReqId = relReqId;
        this.reqVersion = reqVersion;
        this.relReqVersion = relReqVersion;
        this.relatedReqRole = relatedReqRole;
    }

    public static RequirementLinkModel create(int reqVersion, int relReqVersion, String relatedReqRole, String reqPath, String relReqPath) {
        RequirementLinkModel model = new RequirementLinkModel(null, null, reqVersion, relReqVersion, relatedReqRole);
        model.setReqPath(reqPath);
        model.setRelReqPath(relReqPath);
        return model;
    }

    public String getReqPath() {
        return this.reqPath;
    }

    public void setReqPath(String reqPath) {
        this.reqPath = reqPath;
    }

    public String getRelReqPath() {
        return this.relReqPath;
    }

    public void setRelReqPath(String relReqPath) {
        this.relReqPath = relReqPath;
    }

    public Long getReqId() {
        return this.reqId;
    }

    public Long getRelReqId() {
        return this.relReqId;
    }

    public int getReqVersion() {
        return this.reqVersion;
    }

    public int getRelReqVersion() {
        return this.relReqVersion;
    }

    public String getRelatedReqRole() {
        return this.relatedReqRole;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("req-id", (Object)this.relReqId).append("req-path", (Object)this.reqPath).append("req-version", this.reqVersion).append("rel-req-id", (Object)this.relReqId).append("rel-req-path", (Object)this.relReqPath).append("rel-req-version", this.relReqVersion).append("rel-req-role", (Object)this.relatedReqRole).toString();
    }
}

