/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase.bdd;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.MessageSource;
import org.squashtest.tm.domain.bdd.util.ActionWordUtil;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.DatasetParamValue;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.service.internal.testcase.bdd.BddScriptWriter;

public class CucumberScriptWriter
implements BddScriptWriter {
    private static final String TAB_CHAR = "\t";
    private static final String DOUBLE_TAB_CHAR = "\t\t";
    private static final String TRIPLE_TAB_CHAR = "\t\t\t";
    private static final String NEW_LINE_CHAR = "\n";
    private static final String SPACE_CHAR = " ";
    private static final String VERTICAL_BAR = "|";
    private static final String ACROBAT_CHAR = "@";
    private static final String SCRIPT_LANGUAGE_LABEL = "# language: ";
    private static final String COMMENT_MARKER = "#";
    private static final String DOCSTRING_MARKER = "\"\"\"";
    private boolean hasTCParamInTestCase = false;

    @Override
    public String writeBddScript(KeywordTestCase testCase, MessageSource messageSource, boolean escapeArrows) {
        StringBuilder builder = new StringBuilder();
        List testSteps = testCase.getSteps();
        String testCaseName = testCase.getName();
        Locale locale = testCase.getProject().getBddScriptLanguage().getLocale();
        if (!testSteps.isEmpty()) {
            this.addAllStepsScriptWithoutScenarioToBuilder(builder, testSteps, locale, messageSource, escapeArrows);
            this.addScenarioAndDatasetToBuilder(builder, testCaseName, testCase.getDatasets(), locale, messageSource);
            this.hasTCParamInTestCase = false;
        }
        this.addLanguageAndFeatureToBuilder(builder, testCaseName, locale.toLanguageTag(), locale, messageSource);
        return builder.toString();
    }

    private void addAllStepsScriptWithoutScenarioToBuilder(StringBuilder builder, List<TestStep> testSteps, Locale locale, MessageSource messageSource, boolean escapeArrows) {
        for (TestStep step : testSteps) {
            KeywordTestStep keywordStep = (KeywordTestStep)step;
            boolean wrapParameterValuesWithDoubleQuotes = this.shouldParameterValuesBeWrappedWithDoubleQuotesByTechnology(keywordStep.getTestCase());
            String stepScript = this.writeBddStepScript(keywordStep, messageSource, locale, escapeArrows, wrapParameterValuesWithDoubleQuotes);
            this.raiseHasTCParamFlag(keywordStep.hasTCParam());
            builder.append(DOUBLE_TAB_CHAR).append(stepScript).append(NEW_LINE_CHAR);
        }
        builder.deleteCharAt(builder.length() - 1);
    }

    private boolean shouldParameterValuesBeWrappedWithDoubleQuotesByTechnology(TestCase tc) {
        if (tc == null) {
            return false;
        }
        if (tc.getAutomatedTestTechnology() != null) {
            return "Cucumber 4".equals(tc.getAutomatedTestTechnology().getName()) || "Cucumber 5+".equals(tc.getAutomatedTestTechnology().getName());
        }
        if (tc.getProject().getBddImplementationTechnology() != null) {
            return "CUCUMBER_4".equals(tc.getProject().getBddImplementationTechnology().name()) || "CUCUMBER_5_PLUS".equals(tc.getProject().getBddImplementationTechnology().name());
        }
        return false;
    }

    private void raiseHasTCParamFlag(boolean hasTCParam) {
        if (!this.hasTCParamInTestCase) {
            this.hasTCParamInTestCase = hasTCParam;
        }
    }

    private void addScenarioAndDatasetToBuilder(StringBuilder builder, String testCaseName, Set<Dataset> datasetSet, Locale locale, MessageSource messageSource) {
        if (!datasetSet.isEmpty() && this.hasTCParamInTestCase) {
            this.addScenarioToBuilder(builder, testCaseName, messageSource.getMessage("testcase.bdd.script.label.scenario-outline", null, locale));
            this.generateAllDatasetAndExamplesScript(builder, datasetSet, locale, messageSource);
        } else {
            this.addScenarioToBuilder(builder, testCaseName, messageSource.getMessage("testcase.bdd.script.label.scenario", null, locale));
        }
    }

    private void addScenarioToBuilder(StringBuilder builder, String testCaseName, String scenario) {
        StringBuilder preBuilder = new StringBuilder();
        preBuilder.append(NEW_LINE_CHAR).append(NEW_LINE_CHAR).append(TAB_CHAR).append(scenario).append(testCaseName).append(NEW_LINE_CHAR);
        builder.insert(0, preBuilder);
    }

    private void generateAllDatasetAndExamplesScript(StringBuilder builder, Set<Dataset> datasetSet, Locale locale, MessageSource messageSource) {
        Map<String, String> parameterNameToTypeMap = this.computeParameterToTypeMap(datasetSet);
        for (Dataset dataset : datasetSet) {
            String datasetScript = this.generateDatasetAndExampleScript(dataset, parameterNameToTypeMap, locale, messageSource);
            builder.append(NEW_LINE_CHAR).append(NEW_LINE_CHAR).append(datasetScript);
        }
    }

    private Map<String, String> computeParameterToTypeMap(Set<Dataset> dataSets) {
        HashMap<String, String> parameterTypeMap = new HashMap<String, String>();
        for (Dataset dataset : dataSets) {
            Set paramValues = dataset.getParameterValues();
            for (DatasetParamValue paramValue : paramValues) {
                String parameterName = paramValue.getParameter().getName();
                if (!ActionWordUtil.isNumber((String)paramValue.getParamValue())) {
                    parameterTypeMap.put(parameterName, "string");
                    continue;
                }
                if (!ActionWordUtil.isNumber((String)paramValue.getParamValue()) || parameterTypeMap.containsKey(parameterName)) continue;
                parameterTypeMap.put(parameterName, "number");
            }
        }
        return parameterTypeMap;
    }

    private String generateDatasetAndExampleScript(Dataset dataset, Map<String, String> parameterNameToTypeMap, Locale locale, MessageSource messageSource) {
        String datasetTagLine = this.generateDatasetTagLine(dataset);
        String exampleLine = DOUBLE_TAB_CHAR + messageSource.getMessage("testcase.bdd.script.label.examples", null, locale) + NEW_LINE_CHAR;
        String paramNameAndValueLines = this.generateDatasetParamNamesAndValues(dataset, parameterNameToTypeMap);
        return datasetTagLine + exampleLine + paramNameAndValueLines;
    }

    private String generateDatasetTagLine(Dataset dataset) {
        String originalStr = dataset.getName();
        String trimmedAndRemovedExtraSpacesStr = ActionWordUtil.replaceExtraSpacesInText((String)originalStr.trim());
        String replacedSpacesStr = trimmedAndRemovedExtraSpacesStr.replace(SPACE_CHAR, "_");
        return "\t\t@" + replacedSpacesStr + NEW_LINE_CHAR;
    }

    private String generateDatasetParamNamesAndValues(Dataset dataset, Map<String, String> parameterNameToTypeMap) {
        Set datasetParamValues = dataset.getParameterValues();
        Map<String, String> paramNameValueMap = datasetParamValues.stream().collect(Collectors.toMap(datasetParamValue -> datasetParamValue.getParameter().getName(), DatasetParamValue::getParamValue));
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(paramNameValueMap);
        return this.generateSortedDatasetParamNamesAndValues(sortedMap, parameterNameToTypeMap);
    }

    private String generateSortedDatasetParamNamesAndValues(TreeMap<String, String> paramNames, Map<String, String> parameterNameToTypeMap) {
        StringBuilder lineBuilder1 = new StringBuilder();
        lineBuilder1.append(DOUBLE_TAB_CHAR);
        StringBuilder lineBuilder2 = new StringBuilder();
        lineBuilder2.append(DOUBLE_TAB_CHAR);
        paramNames.forEach((paramName, paramValue) -> this.addParamNameAndValueIntoTwoBuilders(lineBuilder1, lineBuilder2, (String)paramName, (String)paramValue, parameterNameToTypeMap));
        lineBuilder1.append(VERTICAL_BAR).append(NEW_LINE_CHAR);
        lineBuilder2.append(VERTICAL_BAR);
        return lineBuilder1.append((CharSequence)lineBuilder2).toString();
    }

    private void addParamNameAndValueIntoTwoBuilders(StringBuilder lineBuilder1, StringBuilder lineBuilder2, String paramName, String paramValue, Map<String, String> parameterNameToTypeMap) {
        this.addInfoIntoBuilder(lineBuilder1, paramName);
        String trimmedParamValue = paramValue.trim();
        if ("string".equals(parameterNameToTypeMap.get(paramName))) {
            String updatedParamValue = ActionWordUtil.wrapWithDoubleQuotes((String)trimmedParamValue);
            this.addInfoIntoBuilder(lineBuilder2, updatedParamValue);
        } else {
            this.addInfoIntoBuilder(lineBuilder2, trimmedParamValue);
        }
    }

    private void addInfoIntoBuilder(StringBuilder lineBuilder, String info) {
        lineBuilder.append(VERTICAL_BAR).append(SPACE_CHAR).append(info).append(SPACE_CHAR);
    }

    private void addLanguageAndFeatureToBuilder(StringBuilder builder, String testCaseName, String language, Locale locale, MessageSource messageSource) {
        StringBuilder subBuilder = new StringBuilder();
        subBuilder.append(SCRIPT_LANGUAGE_LABEL).append(language).append(NEW_LINE_CHAR).append(messageSource.getMessage("testcase.bdd.script.label.feature", null, locale)).append(testCaseName);
        builder.insert(0, subBuilder);
    }

    public String writeBddStepScript(KeywordTestStep testStep, MessageSource messageSource, Locale locale, boolean escapeArrows, boolean wrapParameterValuesWithDoubleQuotes) {
        StringBuilder builder = new StringBuilder();
        String internationalizedKeywordScript = messageSource.getMessage(testStep.getKeyword().i18nKeywordNameKey(), null, locale);
        String actionWordScript = testStep.writeTestStepActionWordScript(escapeArrows, wrapParameterValuesWithDoubleQuotes);
        String dataTable = testStep.getDatatable();
        String docstring = testStep.getDocstring();
        String comment = testStep.getComment();
        builder.append(internationalizedKeywordScript).append(SPACE_CHAR).append(actionWordScript);
        if (!StringUtils.isBlank((CharSequence)dataTable)) {
            builder.append(NEW_LINE_CHAR).append(TRIPLE_TAB_CHAR).append(dataTable.replace(NEW_LINE_CHAR, "\n\t\t\t"));
        }
        if (!StringUtils.isBlank((CharSequence)docstring)) {
            builder.append(NEW_LINE_CHAR).append(TRIPLE_TAB_CHAR).append(DOCSTRING_MARKER).append(NEW_LINE_CHAR).append(TRIPLE_TAB_CHAR).append(docstring.replace(NEW_LINE_CHAR, "\n\t\t\t")).append(NEW_LINE_CHAR).append(TRIPLE_TAB_CHAR).append(DOCSTRING_MARKER);
        }
        if (!StringUtils.isBlank((CharSequence)comment)) {
            builder.append(NEW_LINE_CHAR).append(TRIPLE_TAB_CHAR).append(COMMENT_MARKER).append(comment.replace(NEW_LINE_CHAR, "\n\t\t\t#"));
        }
        return builder.toString();
    }
}

