/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.assistance.scoring;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.testautomation.AnalysisStatus;
import org.squashtest.tm.domain.testautomation.TestCandidateAnalysis;
import org.squashtest.tm.domain.testcase.SuggestionStatus;
import org.squashtest.tm.domain.testcase.TestAutomationCandidate;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.PreventConcurrent;
import org.squashtest.tm.service.internal.dto.testautomation.TestCandidateAnalysisDto;
import org.squashtest.tm.service.internal.repository.TestAutomationCandidateDao;
import org.squashtest.tm.service.internal.repository.TestCandidateAnalysisDao;
import org.squashtest.tm.service.internal.repository.hibernate.utils.HibernateConfig;
import org.squashtest.tm.service.internal.repository.loaders.testcase.TestCaseLoader;
import org.squashtest.tm.service.internal.testautomation.assistance.scoring.AnalysisContext;
import org.squashtest.tm.service.internal.testautomation.assistance.scoring.AnalysisContextIdCoercer;
import org.squashtest.tm.service.internal.testautomation.assistance.scoring.ExecutionStatistics;
import org.squashtest.tm.service.internal.testautomation.assistance.scoring.ProjectTestCasesExecutionsData;
import org.squashtest.tm.service.sse.ServerEventService;
import org.squashtest.tm.service.testautomation.assistance.scoring.TestCandidateScoringProcessor;

@Service
@Transactional(propagation=Propagation.REQUIRES_NEW)
public class TestCandidateScoringProcessorImpl
implements TestCandidateScoringProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCandidateScoringProcessorImpl.class);
    @PersistenceContext
    private EntityManager entityManager;
    private final TestAutomationCandidateDao testAutomationCandidateDao;
    private final TestCandidateAnalysisDao testCandidateAnalysisDao;
    private final ServerEventService serverEventService;
    private final TestCaseLoader testCaseLoader;

    public TestCandidateScoringProcessorImpl(TestAutomationCandidateDao testAutomationCandidateDao, TestCandidateAnalysisDao testCandidateAnalysisDao, ServerEventService serverEventService, TestCaseLoader testCaseLoader) {
        this.testAutomationCandidateDao = testAutomationCandidateDao;
        this.testCandidateAnalysisDao = testCandidateAnalysisDao;
        this.serverEventService = serverEventService;
        this.testCaseLoader = testCaseLoader;
    }

    @Override
    @PreventConcurrent(entityType=TestCandidateAnalysis.class, paramName="ctx", coercer=AnalysisContextIdCoercer.class)
    public void processTestCaseBatch(ProjectTestCasesExecutionsData executionData, @Id(value="ctx") AnalysisContext analysisContext) {
        LOGGER.debug("Processing batch of {} test cases in new transaction", new Object[]{executionData.testCaseIds().size()});
        Object batchTestCases = this.testCaseLoader.load(executionData.testCaseIds(), EnumSet.of(TestCaseLoader.Options.FETCH_TYPE, TestCaseLoader.Options.FETCH_NATURE));
        if (batchTestCases.isEmpty()) {
            LOGGER.debug("No test cases found for batch, skipping", new Object[0]);
            return;
        }
        List<TestAutomationCandidate> existingCandidatesForBatch = this.testAutomationCandidateDao.findSuggestedCandidatesByTestCaseIds(executionData.testCaseIds());
        Map<Long, TestAutomationCandidate> existingCandidatesMap = existingCandidatesForBatch.stream().collect(Collectors.toMap(candidate -> candidate.getTestCase().getId(), candidate -> candidate, (existing, replacement) -> existing));
        ArrayList<TestAutomationCandidate> candidatesToCreate = new ArrayList<TestAutomationCandidate>();
        ArrayList<TestAutomationCandidate> candidatesToUpdate = new ArrayList<TestAutomationCandidate>();
        Date evaluationDate = new Date();
        for (TestCase testCase : batchTestCases) {
            Long testCaseId = testCase.getId();
            int execCount = executionData.executionCounts().getOrDefault(testCaseId, 0);
            int successCount = executionData.successCountInLastExecutions().getOrDefault(testCaseId, 0);
            int successRate = this.calculateSuccessRate(execCount, successCount);
            int priorityScore = this.calculatePriorityScore(testCase, executionData.globalStats().minExecutionCount(), executionData.globalStats().maxExecutionCount(), executionData.globalStats().execCountRange(), execCount, successRate);
            TestAutomationCandidate candidate2 = existingCandidatesMap.get(testCaseId);
            if (candidate2 == null) {
                candidate2 = new TestAutomationCandidate(testCase);
                this.setCandidateProperties(candidate2, priorityScore, evaluationDate, analysisContext.evaluatedBy());
                candidatesToCreate.add(candidate2);
                continue;
            }
            if (candidate2.getSuggestionStatus() != SuggestionStatus.SUGGESTED) continue;
            this.setCandidateProperties(candidate2, priorityScore, evaluationDate, analysisContext.evaluatedBy());
            candidatesToUpdate.add(candidate2);
        }
        if (!candidatesToCreate.isEmpty() || !candidatesToUpdate.isEmpty()) {
            int currentBatchSize = candidatesToCreate.size() + candidatesToUpdate.size();
            int currentProgress = analysisContext.globalProcessedCount().addAndGet(currentBatchSize);
            LOGGER.debug("Processing batch: {} creates, {} updates - Progress: {}/{}", new Object[]{candidatesToCreate.size(), candidatesToUpdate.size(), currentProgress, analysisContext.totalTestCases()});
            this.saveCandidateBatchAndUpdateProgress(candidatesToCreate, candidatesToUpdate, analysisContext.analysisId(), currentProgress, analysisContext.totalTestCases());
        }
    }

    @Override
    public ExecutionStatistics calculateExecutionStatistics(List<Long> testCasesIds, Map<Long, Integer> executionCounts) {
        int minCount = Integer.MAX_VALUE;
        int maxCount = 0;
        for (Long testCaseId : testCasesIds) {
            int execCount = executionCounts.getOrDefault(testCaseId, 0);
            if (execCount < 4) continue;
            minCount = Math.min(minCount, execCount);
            maxCount = Math.max(maxCount, execCount);
        }
        if (minCount == Integer.MAX_VALUE) {
            minCount = 0;
        }
        LOGGER.debug("Execution statistics: min={}, max={}, range={}", new Object[]{minCount, maxCount, maxCount - minCount});
        return new ExecutionStatistics(minCount, maxCount, maxCount - minCount);
    }

    protected void saveCandidateBatchAndUpdateProgress(List<TestAutomationCandidate> batchToCreate, List<TestAutomationCandidate> batchToUpdate, Long analysisId, int totalProcessedAfterBatch, int totalCandidates) {
        int nbProcessedCandidates = batchToCreate.size() + batchToUpdate.size();
        LOGGER.debug("Processing batch: {} creates, {} updates", new Object[]{batchToCreate.size(), batchToUpdate.size()});
        HibernateConfig.enableBatch(this.entityManager, 50);
        try {
            for (TestAutomationCandidate candidate : batchToCreate) {
                this.entityManager.persist((Object)candidate);
            }
            this.entityManager.flush();
            TestCandidateAnalysis analysis = this.loadAndUpdateAnalysis(analysisId, nbProcessedCandidates);
            this.testCandidateAnalysisDao.saveAndFlush(analysis);
            this.notifyProgress(analysis);
            LOGGER.debug("Batch committed: {} candidates, progress: {}/{}", new Object[]{nbProcessedCandidates, totalProcessedAfterBatch, totalCandidates});
        }
        finally {
            HibernateConfig.disableBatch(this.entityManager);
            this.entityManager.clear();
        }
    }

    private TestCandidateAnalysis loadAndUpdateAnalysis(Long analysisId, int increment) {
        TestCandidateAnalysis analysis = (TestCandidateAnalysis)this.testCandidateAnalysisDao.findById(analysisId).orElseThrow();
        int newProcessed = Math.min(analysis.getNbOfProcessedTestCases() + increment, analysis.getNbOfTotalTestCases());
        analysis.setNbOfProcessedTestCases(newProcessed);
        if (analysis.getStatus() == AnalysisStatus.RUNNING && newProcessed >= analysis.getNbOfTotalTestCases()) {
            analysis.setStatus(AnalysisStatus.COMPLETED);
            analysis.setTerminatedOn(new Date());
        }
        return analysis;
    }

    private void notifyProgress(TestCandidateAnalysis analysis) {
        TestCandidateAnalysisDto dto = TestCandidateAnalysisDto.fromAnalysis(analysis);
        String id = analysis.getId().toString();
        if (analysis.getStatus() == AnalysisStatus.COMPLETED) {
            this.serverEventService.sendLastEvent(id, dto);
        } else {
            this.serverEventService.sendEvent(id, dto);
        }
    }

    protected void setCandidateProperties(TestAutomationCandidate candidate, int priorityScore, Date evaluationDate, String evaluatedBy) {
        try {
            candidate.setPriorityScore(Integer.valueOf(priorityScore));
            candidate.setEvaluatedOn(evaluationDate);
            candidate.setEvaluatedBy(evaluatedBy);
            candidate.setSuggestionStatus(SuggestionStatus.SUGGESTED);
        }
        catch (Exception e) {
            LOGGER.error("Error setting candidate properties for test case {}: {}", new Object[]{candidate.getTestCase().getId(), e.getMessage()});
            throw e;
        }
    }

    protected int calculatePriorityScore(TestCase testCase, int minExecutionCount, int maxExecutionCount, int execCountRange, int execCount, int successRate) {
        int score = this.calculateTypeScore(testCase);
        score += this.calculateImportanceScore(testCase);
        score += this.calculateSuccessRateScore(successRate);
        return score += this.calculateFrequencyScore(execCount, minExecutionCount, maxExecutionCount, execCountRange);
    }

    protected int calculateTypeScore(TestCase testCase) {
        return Objects.equals(testCase.getType().getCode(), "TYP_REGRESSION_TESTING") ? 10 : 0;
    }

    protected int calculateImportanceScore(TestCase testCase) {
        return switch (testCase.getImportance()) {
            case TestCaseImportance.LOW -> 5;
            case TestCaseImportance.MEDIUM -> 10;
            case TestCaseImportance.HIGH -> 20;
            case TestCaseImportance.VERY_HIGH -> 30;
            default -> throw new MatchException(null, null);
        };
    }

    protected int calculateSuccessRateScore(int successRate) {
        if (successRate <= 70) {
            return 0;
        }
        return Math.min(successRate - 70, 30);
    }

    protected int calculateFrequencyScore(int execCount, int minExecutionCount, int maxExecutionCount, int execCountRange) {
        if (execCount < 4) {
            return 0;
        }
        if (execCountRange > 0) {
            int freqScore = (int)((double)(execCount - minExecutionCount) * 30.0 / (double)execCountRange);
            return Math.max(1, Math.min(30, freqScore));
        }
        if (execCount == maxExecutionCount) {
            return 30;
        }
        return 0;
    }

    protected int calculateSuccessRate(int execCount, int successCount) {
        if (execCount < 4) {
            return 0;
        }
        int lastExecCount = Math.min(execCount, 10);
        return (int)Math.floor((double)successCount * 100.0 / (double)lastExecCount);
    }
}

