/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.sse;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.catalina.connector.ClientAbortException;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.internal.sse.ServerEventModel;
import org.squashtest.tm.service.sse.ServerEventService;

@Service
public class ServerEventServiceImpl
implements ServerEventService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerEventServiceImpl.class);
    private static final Long TIMEOUT = 3600000L;
    private final Map<String, SseEmitter> emitters = new ConcurrentHashMap<String, SseEmitter>();

    @Override
    public SseEmitter getEmitter(String id) {
        return this.emitters.computeIfAbsent(id, key -> {
            SseEmitter emitter = new SseEmitter(TIMEOUT);
            emitter.onCompletion(() -> {
                LOGGER.info("SSE emitter completed for id: {}", new Object[]{key});
                this.emitters.remove(key);
            });
            emitter.onTimeout(() -> {
                LOGGER.warn("SSE emitter timed out for id: {}", new Object[]{key});
                this.emitters.remove(key);
            });
            emitter.onError(throwable -> {
                LOGGER.error("Error in SSE emitter for id: {}", new Object[]{key, throwable});
                this.emitters.remove(key);
            });
            return emitter;
        });
    }

    @Override
    public void removeEmitter(String id) {
        SseEmitter emitter = this.emitters.remove(id);
        if (emitter != null) {
            emitter.complete();
            LOGGER.info("SSE emitter removed for id: {}", new Object[]{id});
        } else {
            LOGGER.warn("No SSE emitter found to remove for id: {}", new Object[]{id});
        }
    }

    @Override
    public void sendEvent(String id, Object data) {
        this.sendSseEvent(id, data, false);
    }

    @Override
    public void sendLastEvent(String id, Object data) {
        this.sendSseEvent(id, data, true);
    }

    private void sendSseEvent(String id, Object data, boolean isFinished) {
        SseEmitter emitter = this.emitters.get(id);
        if (emitter == null) {
            LOGGER.warn("No emitter found for id: {}", new Object[]{id});
            return;
        }
        try {
            emitter.send(SseEmitter.event().data((Object)new ServerEventModel(data, isFinished).toJsonString()).build());
            if (isFinished) {
                emitter.complete();
                this.emitters.remove(id);
            }
        }
        catch (ClientAbortException e) {
            LOGGER.warn("Client aborted sse event", (Throwable)e);
        }
        catch (Exception e) {
            emitter.completeWithError((Throwable)e);
            this.emitters.remove(id);
        }
    }
}

