/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.library;

import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.library.Library;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.service.internal.library.GenericNodeManagementService;
import org.squashtest.tm.service.internal.repository.FolderDao;
import org.squashtest.tm.service.internal.repository.LibraryDao;
import org.squashtest.tm.service.library.FolderModificationService;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Transactional
public class GenericFolderModificationService<FOLDER extends Folder<NODE>, NODE extends LibraryNode>
implements FolderModificationService<FOLDER> {
    private final PermissionEvaluationService permissionService;
    private final GenericNodeManagementService<FOLDER, NODE, FOLDER> delegate;
    private final FolderDao<FOLDER, NODE> folderDao;
    private final LibraryDao<? extends Library<NODE>, NODE> libraryDao;

    public GenericFolderModificationService(PermissionEvaluationService permissionService, FolderDao<FOLDER, NODE> folderDao, LibraryDao<? extends Library<NODE>, NODE> libraryDao) {
        this.permissionService = permissionService;
        this.folderDao = folderDao;
        this.libraryDao = libraryDao;
        this.delegate = new GenericNodeManagementService(permissionService, folderDao, folderDao, libraryDao);
    }

    @Override
    @Transactional(readOnly=true)
    @PostAuthorize(value="hasPermission(returnObject, 'READ') or hasRole('ROLE_ADMIN')")
    public FOLDER findFolder(long folderId) {
        return (FOLDER)((Folder)this.delegate.findNode(folderId));
    }

    @Override
    public void removeFolder(long folderId) {
        this.checkPermission(new SecurityCheckableItem(folderId, "folder", "DELETE"));
        this.delegate.removeNode(folderId);
    }

    @Override
    public void renameFolder(long folderId, String newName) {
        this.checkPermission(new SecurityCheckableItem(folderId, "folder", "WRITE"));
        this.delegate.renameNode(folderId, newName);
    }

    @Override
    public void updateFolderDescription(long folderId, String newDescription) {
        this.checkPermission(new SecurityCheckableItem(folderId, "folder", "WRITE"));
        this.delegate.updateNodeDescription(folderId, newDescription);
    }

    private void checkPermission(SecurityCheckableItem ... securityCheckableItems) throws AccessDeniedException {
        SecurityCheckableItem[] securityCheckableItemArray = securityCheckableItems;
        int n = securityCheckableItems.length;
        int n2 = 0;
        while (n2 < n) {
            SecurityCheckableItem item = securityCheckableItemArray[n2];
            Object domainObject = item.getKind().equals("folder") ? this.folderDao.findById(item.getId()) : this.libraryDao.findById(item.getId());
            if (!this.permissionService.hasRoleOrPermissionOnObject("ROLE_ADMIN", item.getPermission(), domainObject)) {
                throw new AccessDeniedException("Access is denied");
            }
            ++n2;
        }
    }

    private class SecurityCheckableItem {
        private static final String FOLDER = "folder";
        private static final String LIBRARY = "library";
        private final long domainObjectId;
        private String domainObjectKind;
        private final String permission;

        public SecurityCheckableItem(long domainObjectId, String domainObjectKind, String permission) {
            this.domainObjectId = domainObjectId;
            this.setKind(domainObjectKind);
            this.domainObjectKind = domainObjectKind;
            this.permission = permission;
        }

        private void setKind(String kind) {
            if (!kind.equals(FOLDER) || kind.equals(LIBRARY)) {
                throw new IllegalArgumentException("(dev note : AbstracLibraryNavigationService : manual security checks aren't correctly configured");
            }
            this.domainObjectKind = kind;
        }

        public long getId() {
            return this.domainObjectId;
        }

        public String getKind() {
            return this.domainObjectKind;
        }

        public String getPermission() {
            return this.permission;
        }
    }
}

