/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.display.search.CampaignSearchInputData;
import org.squashtest.tm.service.display.search.CampaignSearchInputDataProvider;
import org.squashtest.tm.service.internal.display.dto.UserView;
import org.squashtest.tm.service.internal.display.search.CampaignSearchInputDataProviderImpl$AjcClosure1;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.project.ProjectFinder;

@Component
@Transactional(readOnly=true)
public class CampaignSearchInputDataProviderImpl
implements CampaignSearchInputDataProvider {
    private final ProjectFinder projectFinder;
    private final ProjectDao projectDao;
    private final UserDao userDao;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public CampaignSearchInputDataProviderImpl(ProjectFinder projectFinder, ProjectDao projectDao, UserDao userDao) {
        this.projectFinder = projectFinder;
        this.projectDao = projectDao;
        this.userDao = userDao;
    }

    @Override
    public CampaignSearchInputData provide() {
        List<Long> readableProjectIds = this.projectFinder.findAllReadableIds();
        List<UserView> assignedUserViews = this.findAssignedUserViews(readableProjectIds);
        List<UserView> lastExecutedUserViews = this.findLastExecutedUserViews(readableProjectIds);
        return new CampaignSearchInputData(assignedUserViews, lastExecutedUserViews);
    }

    private List<UserView> findAssignedUserViews(List<Long> readableProjectIds) {
        List<String> usersAssignedToItpi = this.projectDao.findUsersAssignedToItpi(readableProjectIds);
        return this.findUserViewsByLogin(usersAssignedToItpi);
    }

    private List<UserView> findLastExecutedUserViews(List<Long> readableProjectIds) {
        List<String> usersExecutedItpi = this.projectDao.findUsersWhoExecutedItpi(readableProjectIds);
        return this.findUserViewsByLogin(usersExecutedItpi);
    }

    private List<UserView> findUserViewsByLogin(List<String> userLogin) {
        List<String> list = userLogin;
        UserDao userDao = this.userDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)userDao, list);
        Object[] objectArray = new Object[]{this, userDao, list, joinPoint};
        CampaignSearchInputDataProviderImpl$AjcClosure1 campaignSearchInputDataProviderImpl$AjcClosure1 = new CampaignSearchInputDataProviderImpl$AjcClosure1(objectArray);
        List users = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(campaignSearchInputDataProviderImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
        Map userViews = users.stream().map(user -> {
            UserView userView = new UserView();
            userView.setId(user.getId());
            userView.setFirstName(user.getFirstName());
            userView.setLastName(user.getLastName());
            userView.setLogin(user.getLogin());
            return userView;
        }).collect(Collectors.toMap(UserView::getLogin, Function.identity()));
        return userLogin.stream().map(login -> userViews.getOrDefault(login, new UserView((String)login))).toList();
    }

    static {
        CampaignSearchInputDataProviderImpl.ajc$preClinit();
    }

    static final /* synthetic */ List findUsersByLoginIn_aroundBody0(CampaignSearchInputDataProviderImpl campaignSearchInputDataProviderImpl, UserDao userDao, List list, JoinPoint joinPoint) {
        return userDao.findUsersByLoginIn(list);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CampaignSearchInputDataProviderImpl.java", CampaignSearchInputDataProviderImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findUsersByLoginIn", "org.squashtest.tm.service.internal.repository.UserDao", "java.util.List", "loginList", "", "java.util.List"), 73);
    }
}

