/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion.jdbc;

import jakarta.persistence.EntityManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jooq.BatchBindStep;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Query;
import org.jooq.Record3;
import org.jooq.Result;
import org.jooq.SelectSeekStep1;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableRecord;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class JdbcBatchReorderHelper {
    private final EntityManager entityManager;
    private final DSLContext dslContext;
    private final Set<String> parentColumnNames = new HashSet<String>(Arrays.asList("ANCESTOR_ID", "LIBRARY_ID"));
    private final Set<String> childrenColumnNames = new HashSet<String>(Arrays.asList("DESCENDANT_ID", "CONTENT_ID"));
    private final Set<String> orderColumnNames = new HashSet<String>(Arrays.asList("CONTENT_ORDER"));

    public JdbcBatchReorderHelper(EntityManager entityManager, DSLContext dslContext) {
        this.entityManager = entityManager;
        this.dslContext = dslContext;
    }

    public void reorder(Collection<Long> parentIds, TableField<?, Long> primaryColumn, Field<Long> parentColumn, Field<Integer> orderColumn) {
        int defaultStartIndex = 0;
        this.doReorder(parentIds, primaryColumn, parentColumn, orderColumn, defaultStartIndex);
    }

    public void reorder(Collection<Long> parentIds, TableField<?, Long> primaryColumn, Field<Long> parentColumn, Field<Integer> orderColumn, Integer startIndex) {
        this.doReorder(parentIds, primaryColumn, parentColumn, orderColumn, startIndex);
    }

    private void doReorder(Collection<Long> parentIds, TableField<?, Long> primaryColumn, Field<Long> parentColumn, Field<Integer> orderColumn, Integer startIndex) {
        this.clearPersistenceContext();
        if (parentIds.isEmpty()) {
            return;
        }
        Map<Long, Map<Long, Integer>> childrenOrderByParent = this.getToReordersItemByParentId(parentIds, primaryColumn, parentColumn, orderColumn);
        BatchBindStep batch = this.dslContext.batch((Query)DSL.update((Table)primaryColumn.getTable()).set(orderColumn, null).where(parentColumn.eq(null).and(primaryColumn.eq(null))));
        for (Map.Entry<Long, Map<Long, Integer>> entry : childrenOrderByParent.entrySet()) {
            Long parentId = entry.getKey();
            Map<Long, Integer> childrenPosition = entry.getValue();
            int position = startIndex;
            for (Map.Entry<Long, Integer> child : childrenPosition.entrySet()) {
                if (child.getValue() != position) {
                    batch.bind(new Object[]{position, parentId, child.getKey()});
                }
                ++position;
            }
        }
        batch.execute();
    }

    private Map<Long, Map<Long, Integer>> getToReordersItemByParentId(Collection<Long> parentIds, TableField<?, Long> primaryColumn, Field<Long> parentColumn, Field<Integer> orderColumn) {
        SelectSeekStep1 query = this.dslContext.select(parentColumn, primaryColumn, orderColumn).from((TableLike)primaryColumn.getTable()).where(parentColumn.in(parentIds)).orderBy(orderColumn);
        Throwable throwable = null;
        Object var7_8 = null;
        try (Stream stream = query.fetchStream();){
            return stream.collect(Collectors.groupingBy(Record3::value1, LinkedHashMap::new, Collectors.toMap(Record3::value2, Record3::value3, (a, b) -> a, LinkedHashMap::new)));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public <R extends TableRecord<R>> void reorder(Collection<Long> parentIds, Table<R> table) {
        this.clearPersistenceContext();
        if (!parentIds.isEmpty()) {
            this.findColumnsAndReorder(parentIds, table);
        }
    }

    public <R extends TableRecord<R>> void reorder(Collection<Long> parentIds, Table<R> table, Field<Long> parentColumn, Field<Long> childrenColumn, Field<Integer> orderColumn) {
        this.clearPersistenceContext();
        if (!parentIds.isEmpty()) {
            this.doReorder(parentIds, table, parentColumn, childrenColumn, orderColumn);
        }
    }

    private void clearPersistenceContext() {
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private <R extends TableRecord<R>> void findColumnsAndReorder(Collection<Long> parentIds, Table<R> table) {
        Field<Long> parentColumn = this.findCompatibleColumn(table, this.parentColumnNames, Long.class);
        Field<Long> childrenColumn = this.findCompatibleColumn(table, this.childrenColumnNames, Long.class);
        Field<Integer> orderColumn = this.findCompatibleColumn(table, this.orderColumnNames, Integer.class);
        this.doReorder(parentIds, table, parentColumn, childrenColumn, orderColumn);
    }

    private <R extends TableRecord<R>, T> Field<T> findCompatibleColumn(Table<R> table, Set<String> names, Class<T> clazz) {
        return Arrays.stream(table.fields()).filter(field -> names.contains(field.getName())).filter(field -> field.getDataType().getType().equals(clazz)).map(field -> field).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to find required fields " + String.valueOf(names) + " in table : " + String.valueOf(table)));
    }

    private <R extends TableRecord<R>> void doReorder(Collection<Long> parentIds, Table<R> table, Field<Long> parentColumn, Field<Long> childrenColumn, Field<Integer> orderColumn) {
        Map<Long, Result<R>> groups = this.findGroups(parentIds, table, parentColumn, orderColumn);
        this.deleteAllRecords(parentIds, table, parentColumn);
        this.doBatchReorder(groups, table, parentColumn, childrenColumn, orderColumn);
    }

    private <R extends TableRecord<R>> void deleteAllRecords(Collection<Long> parentIds, Table<R> table, Field<Long> parentColumn) {
        this.dslContext.delete(table).where(parentColumn.in(parentIds)).execute();
    }

    private <R extends TableRecord<R>> Map<Long, Result<R>> findGroups(Collection<Long> parentIds, Table<R> table, Field<Long> parentColumn, Field<Integer> orderColumn) {
        return this.dslContext.selectFrom(table).where(parentColumn.in(parentIds)).orderBy(orderColumn).fetchGroups(parentColumn);
    }

    private <R extends TableRecord<R>> void doBatchReorder(Map<Long, Result<R>> groups, Table<R> table, Field<Long> parentColumn, Field<Long> childrenColumn, Field<Integer> orderColumn) {
        int numberOfItems = groups.values().stream().mapToInt(List::size).sum();
        if (numberOfItems > 0) {
            BatchBindStep batch = this.dslContext.batch((Query)this.dslContext.insertInto(table, parentColumn, childrenColumn, orderColumn).values(null, null, null));
            groups.forEach((parentId, children) -> IntStream.range(0, children.size()).forEach(position -> {
                TableRecord record = (TableRecord)children.get(position);
                batch.bind(new Object[]{record.getValue(parentColumn), record.getValue(childrenColumn), position});
            }));
            batch.execute();
        }
    }
}

