/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.configuration;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.util.Map;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record2;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.event.ConfigUpdateEvent;
import org.squashtest.tm.exception.MaxSizeException;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.configuration.ConfigurationService;

@Service(value="squashtest.core.configuration.ConfigurationService")
@Transactional
public class ConfigurationServiceImpl
implements ConfigurationService {
    private static final String INSERT_KEY_SQL = "insert into CORE_CONFIG (STR_KEY, VALUE) values (?1, ?2)";
    private static final String UPDATE_KEY_SQL = "update CORE_CONFIG set VALUE = ?1 where STR_KEY = ?2";
    @PersistenceContext
    private EntityManager em;
    private DSLContext dsl;
    private ApplicationEventPublisher eventPublisher;

    public ConfigurationServiceImpl(DSLContext dsl, ApplicationEventPublisher eventPublisher) {
        this.dsl = dsl;
        this.eventPublisher = eventPublisher;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, String> findAllConfiguration() {
        return this.dsl.select(new SelectFieldOrAsterisk[0]).from((TableLike)Tables.CORE_CONFIG).fetch().intoMap((Field)Tables.CORE_CONFIG.STR_KEY, (Field)Tables.CORE_CONFIG.VALUE);
    }

    @Override
    public void createNewConfiguration(String key, String value) {
        Query sqlQuery = this.em.createNativeQuery(INSERT_KEY_SQL);
        sqlQuery.setParameter(1, (Object)key);
        sqlQuery.setParameter(2, (Object)value);
        sqlQuery.executeUpdate();
        this.eventPublisher.publishEvent((ApplicationEvent)new ConfigUpdateEvent((Object)key));
    }

    @Override
    public void updateConfiguration(String key, String value) {
        Query sqlQuery = this.em.createNativeQuery(UPDATE_KEY_SQL);
        sqlQuery.setParameter(1, (Object)value);
        sqlQuery.setParameter(2, (Object)key);
        sqlQuery.executeUpdate();
        this.eventPublisher.publishEvent((ApplicationEvent)new ConfigUpdateEvent((Object)key));
    }

    @Override
    @Transactional(readOnly=true)
    public String findConfiguration(String key) {
        return (String)this.dsl.select((SelectField)Tables.CORE_CONFIG.VALUE).from((TableLike)Tables.CORE_CONFIG).where(Tables.CORE_CONFIG.STR_KEY.eq((Object)key)).fetchOne((Field)Tables.CORE_CONFIG.VALUE);
    }

    @Override
    @Transactional(readOnly=true)
    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.findConfiguration(key));
    }

    @Override
    public void set(String key, boolean value) {
        String strVal = Boolean.toString(value);
        this.set(key, strVal);
    }

    @Override
    public void set(String key, String value) {
        if (this.findConfiguration(key) == null) {
            this.createNewConfiguration(key, value);
        } else {
            this.updateConfiguration(key, value);
        }
    }

    @Override
    public void checkSizeValidity(String key, String value) {
        Field characterMaxOctets;
        Field characterMaxLengthField = DSL.field((String)"character_maximum_length", Long.class);
        Record2 result = (Record2)this.dsl.select((SelectField)characterMaxLengthField, (SelectField)(characterMaxOctets = DSL.field((String)"character_octet_length", Long.class))).from((TableLike)DSL.table((String)"information_schema.columns")).where(DSL.field((String)"table_name").equalIgnoreCase(Tables.CORE_CONFIG.getName()).and(DSL.field((String)"column_name").equalIgnoreCase(Tables.CORE_CONFIG.VALUE.getName()))).fetchAny();
        if (result != null) {
            Long maxLength = (Long)result.component1();
            Long maxOctets = (Long)result.component2();
            if (maxLength != null && (long)value.length() > maxLength || maxOctets != null && (long)value.getBytes().length >= maxOctets) {
                throw new MaxSizeException("The maximum size is exceeded for the key : " + key);
            }
        }
    }
}

