/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.campaign.CustomSprintGroupModificationService;
import org.squashtest.tm.service.internal.library.NodeManagementService;

@Transactional
@Service(value="CustomSprintGroupModificationService")
public class CustomSprintGroupModificationServiceImpl
implements CustomSprintGroupModificationService {
    @Inject
    @Named(value="squashtest.tm.service.internal.SprintGroupManagementService")
    private NodeManagementService<SprintGroup, CampaignLibraryNode, CampaignFolder> sprintGroupManagementService;

    @Override
    @PreAuthorize(value="hasPermission(#sprintGroupId, 'org.squashtest.tm.domain.campaign.SprintGroup' ,'WRITE')  or hasRole('ROLE_ADMIN')")
    public void rename(@Id long sprintGroupId, String newName) {
        this.sprintGroupManagementService.renameNode(sprintGroupId, newName);
    }
}

