/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.File;
import java.io.IOException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.attachment.AttachmentEntity;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AttachmentPivotType;
import org.squashtest.tm.service.pivot.PivotFileManager;
import org.squashtest.tm.service.pivot.projectexporter.FolderPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.FolderPivotDao;

@Service
public class FolderPivotExporterServiceImpl
implements FolderPivotExporterService {
    private final FolderPivotDao folderPivotDao;
    private final PivotFileManager pivotFileManager;

    public FolderPivotExporterServiceImpl(FolderPivotDao folderPivotDao, PivotFileManager pivotFileManager) {
        this.folderPivotDao = folderPivotDao;
        this.pivotFileManager = pivotFileManager;
    }

    @Override
    public void generateRequirementFolderJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, File tmpAttachmentDir, Long projectId) throws IOException {
        if (!this.folderPivotDao.hasRequirementFolders(projectId)) {
            return;
        }
        File attachmentDir = this.pivotFileManager.createAttachmentDir(tmpAttachmentDir, AttachmentPivotType.REQUIREMENT_FOLDER);
        this.pivotFileManager.writePivotObjectToZip(jsonFactory, jsonGenerator -> this.handleRequirementFolders((JsonGenerator)jsonGenerator, attachmentDir, projectId), JsonImportFile.REQUIREMENT_FOLDERS, archive);
        this.pivotFileManager.addAttachmentsToZip(archive, tmpAttachmentDir, attachmentDir);
    }

    private void handleRequirementFolders(JsonGenerator jsonGenerator, File attachmentDir, Long projectId) {
        this.folderPivotDao.getRequirementFoldersByProjectId(projectId, folderPivot -> this.pivotFileManager.writePivotObject(folderPivot, jsonGenerator, JsonImportFile.REQUIREMENT_FOLDERS), attachmentPivot -> this.pivotFileManager.saveTmpSaveAttachment(attachmentDir, (AttachmentPivot)attachmentPivot));
    }

    @Override
    public void generateTestCaseFolderJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, File tmpAttachmentDir, Long projectId) throws IOException {
        if (!this.folderPivotDao.hasTestCaseFolders(projectId)) {
            return;
        }
        File attachmentDir = this.pivotFileManager.createAttachmentDir(tmpAttachmentDir, AttachmentPivotType.TEST_CASE_FOLDER);
        this.pivotFileManager.writePivotObjectToZip(jsonFactory, jsonGenerator -> this.handleTestCaseFolders((JsonGenerator)jsonGenerator, attachmentDir, projectId), JsonImportFile.TEST_CASE_FOLDERS, archive);
        this.pivotFileManager.addAttachmentsToZip(archive, tmpAttachmentDir, attachmentDir);
    }

    private void handleTestCaseFolders(JsonGenerator jsonGenerator, File attachmentDir, Long projectId) {
        this.folderPivotDao.getTestCaseFoldersByProjectId(projectId, folderPivot -> this.pivotFileManager.writePivotObject(folderPivot, jsonGenerator, JsonImportFile.TEST_CASE_FOLDERS), attachmentPivot -> this.pivotFileManager.saveTmpSaveAttachment(attachmentDir, (AttachmentPivot)attachmentPivot));
    }

    @Override
    public void generateCampaignFolderWithSprintGroupJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, File tmpAttachmentDir, Long projectId) throws IOException {
        if (!this.folderPivotDao.hasCampaignFolderOrSprintGroup(projectId)) {
            return;
        }
        File campaignFolderAttachmentDir = this.pivotFileManager.createAttachmentDir(tmpAttachmentDir, AttachmentPivotType.CAMPAIGN_FOLDER);
        File sprintGroupAttachmentDir = this.pivotFileManager.createAttachmentDir(tmpAttachmentDir, AttachmentPivotType.SPRINT_GROUP);
        this.pivotFileManager.writePivotObjectToZip(jsonFactory, jsonGenerator -> this.handleCampaignFoldersAndSprintGroups((JsonGenerator)jsonGenerator, campaignFolderAttachmentDir, sprintGroupAttachmentDir, projectId), JsonImportFile.CAMPAIGN_FOLDERS_AND_SPRINT_GROUPS, archive);
        this.pivotFileManager.addAttachmentsToZip(archive, tmpAttachmentDir, campaignFolderAttachmentDir);
        this.pivotFileManager.addAttachmentsToZip(archive, tmpAttachmentDir, sprintGroupAttachmentDir);
    }

    private void handleCampaignFoldersAndSprintGroups(JsonGenerator jsonGenerator, File campaignFolderAttachmentDir, File sprintGroupAttachmentDir, Long projectId) {
        this.folderPivotDao.getCampaignFoldersAndSprintGroupsByProjectId(projectId, folderPivot -> this.pivotFileManager.writePivotObject(folderPivot, jsonGenerator, JsonImportFile.CAMPAIGN_FOLDERS_AND_SPRINT_GROUPS), attachmentPivot -> this.saveCampaignFolderAndSprintGroupAttachment((AttachmentPivot)attachmentPivot, campaignFolderAttachmentDir, sprintGroupAttachmentDir));
    }

    private void saveCampaignFolderAndSprintGroupAttachment(AttachmentPivot attachmentPivot, File campaignFolderAttachmentDir, File sprintGroupAttachmentDir) {
        if (AttachmentEntity.CAMPAIGN_FOLDER.equals((Object)attachmentPivot.getAttachmentEntity())) {
            this.pivotFileManager.saveTmpSaveAttachment(campaignFolderAttachmentDir, attachmentPivot);
        } else {
            this.pivotFileManager.saveTmpSaveAttachment(sprintGroupAttachmentDir, attachmentPivot);
        }
    }
}

