/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.excel;

import org.apache.poi.ss.usermodel.Cell;
import org.squashtest.tm.service.internal.batchimport.excel.AbstractTypeBasedCellValueCoercer;
import org.squashtest.tm.service.internal.batchimport.excel.CannotCoerceException;
import org.squashtest.tm.service.internal.batchimport.excel.CellValueCoercer;

public class LiberalBooleanCellCoercer
extends AbstractTypeBasedCellValueCoercer<Boolean>
implements CellValueCoercer<Boolean> {
    public static final LiberalBooleanCellCoercer INSTANCE = new LiberalBooleanCellCoercer();

    protected LiberalBooleanCellCoercer() {
    }

    @Override
    protected Boolean coerceBooleanCell(Cell cell) {
        return cell.getBooleanCellValue();
    }

    @Override
    protected Boolean coerceStringCell(Cell cell) {
        int intValue = this.liberallyParseInt(cell.getStringCellValue());
        return this.coerceDouble(intValue);
    }

    @Override
    protected Boolean coerceNumericCell(Cell cell) {
        double val = cell.getNumericCellValue();
        return this.coerceDouble(val);
    }

    private boolean coerceDouble(double val) throws CannotCoerceException {
        return switch (this.round(val)) {
            case 0 -> false;
            case 1 -> true;
            default -> throw new CannotCoerceException("Cannot coerce cell value " + val + " into a boolean. Rounded value should either be 0 or 1", "message.import.log.error.field.notBoolean");
        };
    }
}

