/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.artificialintelligence.common.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;

public final class BmpToPngBase64Converter {
    private BmpToPngBase64Converter() {
    }

    public static String convert(String bmpBase64) {
        try {
            byte[] bmpBytes = BmpToPngBase64Converter.decodeBase64(bmpBase64);
            BufferedImage image = BmpToPngBase64Converter.readBmpImage(bmpBytes);
            byte[] pngBytes = BmpToPngBase64Converter.convertToPng(image);
            return Base64.getEncoder().encodeToString(pngBytes);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to process image.", e);
        }
    }

    private static byte[] decodeBase64(String base64) {
        try {
            return Base64.getDecoder().decode(base64);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Input is not valid Base64", e);
        }
    }

    private static BufferedImage readBmpImage(byte[] bmpBytes) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bmpBytes);){
            BufferedImage image = ImageIO.read(bis);
            if (image == null) {
                throw new IllegalArgumentException("Failed to decode BMP image: content is not a valid BMP.");
            }
            return image;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static byte[] convertToPng(BufferedImage image) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)image, "png", bos);
            return bos.toByteArray();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

