/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.user;

import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.utils.CurrentUserHelper;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.projectfilter.ProjectFilter;
import org.squashtest.tm.service.project.CustomProjectFinder;
import org.squashtest.tm.service.project.ProjectFilterModificationService;

@Service(value="squash.api.CurrentUserHelper")
@Transactional
public class CurrentUserHelperImpl
implements CurrentUserHelper {
    private final CustomProjectFinder projectFinder;
    private final ProjectFilterModificationService filterModificationService;

    public CurrentUserHelperImpl(CustomProjectFinder projectFinder, ProjectFilterModificationService filterModificationService) {
        this.projectFinder = projectFinder;
        this.filterModificationService = filterModificationService;
    }

    public List<Long> findReadableProjectIds() {
        return this.projectFinder.findAllReadableIds();
    }

    public List<Long> findFilteredReadableProjectIds() {
        ProjectFilter projectFilter = this.filterModificationService.findProjectFilterByUserLogin();
        if (projectFilter != null && projectFilter.getActivated()) {
            List<Long> readableProjectIds = this.findReadableProjectIds();
            return projectFilter.getProjects().stream().map(GenericProject::getId).filter(readableProjectIds::contains).toList();
        }
        return this.findReadableProjectIds();
    }
}

