/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.user;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.exception.user.LoginAlreadyExistsException;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.user.LoginValidatorService;

@Service
@Transactional
public class LoginValidatorServiceImpl
implements LoginValidatorService {
    private final FeatureManager features;
    private final UserDao userDao;

    public LoginValidatorServiceImpl(FeatureManager features, UserDao userDao) {
        this.features = features;
        this.userDao = userDao;
    }

    @Override
    public void checkLoginAvailability(String login) {
        boolean caseInsensitive = this.features.isEnabled(FeatureManager.Feature.CASE_INSENSITIVE_LOGIN);
        if (caseInsensitive && this.userDao.findUserByLoginIgnoreCase(login) != null || !caseInsensitive && this.userDao.findUserByLogin(login) != null) {
            throw new LoginAlreadyExistsException("User " + login + " cannot be created because it already exists");
        }
    }
}

