/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.Set;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.campaign.ExploratorySessionOverviewReviewStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.execution.ExploratorySessionOverviewView;
import org.squashtest.tm.service.internal.repository.display.TestPlanExploratorySessionOverviewDisplayDao;

@Repository
public class TestPlanExploratorySessionOverviewDisplayDaoImpl
implements TestPlanExploratorySessionOverviewDisplayDao {
    private final DSLContext dslContext;

    public TestPlanExploratorySessionOverviewDisplayDaoImpl(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public ExploratorySessionOverviewView findById(long id) {
        return (ExploratorySessionOverviewView)this.dslContext.select((SelectField)Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.as("ID"), (SelectField)Tables.EXPLORATORY_SESSION_OVERVIEW.NAME, (SelectField)Tables.EXPLORATORY_SESSION_OVERVIEW.CHARTER, (SelectField)Tables.EXPLORATORY_SESSION_OVERVIEW.SESSION_DURATION, (SelectField)Tables.EXPLORATORY_SESSION_OVERVIEW.REFERENCE, (SelectField)Tables.EXPLORATORY_SESSION_OVERVIEW.DUE_DATE, (SelectField)Tables.EXPLORATORY_SESSION_OVERVIEW.SESSION_STATUS, (SelectField)Tables.EXPLORATORY_SESSION_OVERVIEW.COMMENTS, (SelectField)Tables.EXPLORATORY_SESSION_OVERVIEW.ATTACHMENT_LIST_ID, (SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (SelectField)Tables.TEST_PLAN_ITEM.CREATED_BY, (SelectField)Tables.TEST_PLAN_ITEM.CREATED_ON, (SelectField)Tables.TEST_PLAN_ITEM.LAST_MODIFIED_BY, (SelectField)Tables.TEST_PLAN_ITEM.LAST_MODIFIED_ON, (SelectField)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS, (SelectField)DSL.countDistinct((Field)Tables.SESSION_NOTE.NOTE_ID).as("NB_NOTES"), (SelectField)Tables.TEST_PLAN_ITEM.TCLN_ID).from((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.OVERVIEW_ID.eq((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID)).leftJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).leftJoin((TableLike)Tables.SESSION_NOTE).on(Tables.SESSION_NOTE.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).join((TableLike)Tables.TEST_PLAN).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN.TEST_PLAN_ID)).join((TableLike)Tables.CAMPAIGN_LIBRARY).on(Tables.CAMPAIGN_LIBRARY.CL_ID.eq((Field)Tables.TEST_PLAN.CL_ID)).join((TableLike)Tables.PROJECT).on(Tables.PROJECT.CL_ID.eq((Field)Tables.CAMPAIGN_LIBRARY.CL_ID)).where(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Object)id)).groupBy(new GroupField[]{Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID, Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, Tables.PROJECT.PROJECT_ID}).fetchOneInto(ExploratorySessionOverviewView.class);
    }

    @Override
    public String inferReviewStatus(long overviewId) {
        Set executionReviewStatuses = this.dslContext.selectDistinct((SelectField)Tables.EXPLORATORY_EXECUTION.REVIEWED).from((TableLike)Tables.EXPLORATORY_EXECUTION).innerJoin((TableLike)Tables.EXECUTION).on(Tables.EXPLORATORY_EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).innerJoin((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).on(Tables.TEST_PLAN_ITEM.OVERVIEW_ID.eq((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID)).where(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Object)overviewId)).fetchSet((Field)Tables.EXPLORATORY_EXECUTION.REVIEWED);
        if (executionReviewStatuses.size() == 1 && executionReviewStatuses.contains(true)) {
            return ExploratorySessionOverviewReviewStatus.DONE.name();
        }
        if (executionReviewStatuses.size() == 1 && executionReviewStatuses.contains(false) || executionReviewStatuses.isEmpty()) {
            return ExploratorySessionOverviewReviewStatus.TO_DO.name();
        }
        return ExploratorySessionOverviewReviewStatus.RUNNING.name();
    }

    @Override
    public TestPlanExploratorySessionOverviewDisplayDao.NameAndReference findNameAndReferenceByExecutionId(long executionId) {
        return (TestPlanExploratorySessionOverviewDisplayDao.NameAndReference)this.dslContext.select((SelectField)Tables.EXPLORATORY_SESSION_OVERVIEW.NAME, (SelectField)Tables.EXPLORATORY_SESSION_OVERVIEW.REFERENCE).from((TableLike)Tables.EXECUTION).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).join((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).on(Tables.TEST_PLAN_ITEM.OVERVIEW_ID.eq((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID)).where(Tables.EXECUTION.EXECUTION_ID.eq((Object)executionId)).fetchOneInto(TestPlanExploratorySessionOverviewDisplayDao.NameAndReference.class);
    }
}

