/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.testcase.DataSetDto;
import org.squashtest.tm.service.internal.repository.display.DatasetDisplayDao;

@Repository
public class DatasetDisplayDaoImpl
implements DatasetDisplayDao {
    @Inject
    private DSLContext dsl;

    @Override
    public List<DataSetDto> findAllByTestCaseId(Long testCaseId) {
        return this.dsl.select((SelectField)Tables.DATASET.DATASET_ID.as("ID"), (SelectField)Tables.DATASET.NAME).from((TableLike)Tables.DATASET).where(Tables.DATASET.TEST_CASE_ID.eq((Object)testCaseId)).orderBy((OrderField)Tables.DATASET.NAME).fetchInto(DataSetDto.class);
    }

    @Override
    public Map<Long, List<DataSetDto>> findAllByTestCaseIds(List<Long> testCaseIds) {
        return this.dsl.select((SelectField)Tables.DATASET.TEST_CASE_ID, (SelectField)Tables.DATASET.DATASET_ID, (SelectField)Tables.DATASET.NAME).from((TableLike)Tables.DATASET).where(Tables.DATASET.TEST_CASE_ID.in(testCaseIds)).groupBy(new GroupField[]{Tables.DATASET.TEST_CASE_ID, Tables.DATASET.DATASET_ID}).orderBy((OrderField)Tables.DATASET.NAME).fetch().stream().collect(Collectors.groupingBy(tuple -> (Long)tuple.get((Field)Tables.DATASET.TEST_CASE_ID), Collectors.mapping(tuple -> {
            DataSetDto dto = new DataSetDto();
            dto.setId((Long)tuple.get((Field)Tables.DATASET.DATASET_ID));
            dto.setName((String)tuple.get((Field)Tables.DATASET.NAME));
            return dto;
        }, Collectors.toList())));
    }
}

