/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.environmentvariable;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.environmentvariable.EnvironmentVariable;
import org.squashtest.tm.domain.environmentvariable.EnvironmentVariableOption;
import org.squashtest.tm.domain.environmentvariable.SingleSelectEnvironmentVariable;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.RequiredFieldException;
import org.squashtest.tm.exception.customfield.StringDoesNotMatchesPatternException;
import org.squashtest.tm.service.denormalizedenvironment.DenormalizedEnvironmentVariableManagerService;
import org.squashtest.tm.service.environmentvariable.EnvironmentVariableBindingService;
import org.squashtest.tm.service.environmentvariable.EnvironmentVariableBindingValueService;
import org.squashtest.tm.service.environmentvariable.EnvironmentVariableManagerService;
import org.squashtest.tm.service.internal.repository.EnvironmentVariableDao;

@Transactional
@Service(value="EnvironmentVariableManagerService")
public class EnvironmentVariableManagerServiceImpl
implements EnvironmentVariableManagerService {
    private final EnvironmentVariableDao environmentVariableDao;
    private final EnvironmentVariableBindingService environmentVariableBindingService;
    private final EnvironmentVariableBindingValueService environmentVariableValueService;
    private final DenormalizedEnvironmentVariableManagerService denormalizedEnvironmentVariableManagerService;

    public EnvironmentVariableManagerServiceImpl(EnvironmentVariableDao environmentVariableDao, EnvironmentVariableBindingService environmentVariableBindingService, EnvironmentVariableBindingValueService environmentVariableValueService, DenormalizedEnvironmentVariableManagerService denormalizedEnvironmentVariableManagerService) {
        this.environmentVariableDao = environmentVariableDao;
        this.environmentVariableBindingService = environmentVariableBindingService;
        this.environmentVariableValueService = environmentVariableValueService;
        this.denormalizedEnvironmentVariableManagerService = denormalizedEnvironmentVariableManagerService;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void persist(EnvironmentVariable environmentVariable) {
        EnvironmentVariable environmentVariable2 = environmentVariable;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)environmentVariable2);
        this.checkDuplicateName(environmentVariable.getName());
        this.checkNameMatchPattern(environmentVariable.getName());
        this.environmentVariableDao.save(environmentVariable);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteEnvironmentVariable(List<Long> environmentVariableIds) {
        environmentVariableIds.forEach(id -> {
            this.environmentVariableBindingService.unbindByEnvironmentVariableId((Long)id);
            EnvironmentVariable environmentVariable = (EnvironmentVariable)this.environmentVariableDao.getReferenceById(id);
            this.denormalizedEnvironmentVariableManagerService.handleEnvironmentVariableDeletion(environmentVariable);
            this.environmentVariableDao.delete(environmentVariable);
        });
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeName(Long evId, String newName) {
        String trimmedNewName = newName.trim();
        EnvironmentVariable environmentVariable = (EnvironmentVariable)this.environmentVariableDao.getReferenceById(evId);
        String oldName = environmentVariable.getName();
        if (StringUtils.equals((CharSequence)oldName, (CharSequence)trimmedNewName)) {
            return;
        }
        this.checkNameMatchPattern(newName);
        this.checkDuplicateName(newName);
        environmentVariable.setName(trimmedNewName);
    }

    private void checkNameMatchPattern(String newName) {
        if (!newName.matches("^[A-Za-z0-9_]*$")) {
            throw new StringDoesNotMatchesPatternException(newName, "^[A-Za-z0-9_]*$", "name");
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeOptionLabel(long environmentVariableId, String optionLabel, String newLabel) {
        if (newLabel == null || newLabel.trim().isEmpty()) {
            throw new RequiredFieldException("label");
        }
        SingleSelectEnvironmentVariable environmentVariable = this.environmentVariableDao.findSingleSelectEnvironmentVariableById(environmentVariableId);
        environmentVariable.changeOptionLabel(optionLabel, newLabel);
        this.environmentVariableValueService.replaceAllExistingValuesByEvId(environmentVariableId, optionLabel, newLabel);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void addOption(long evId, String option) {
        SingleSelectEnvironmentVariable environmentVariable = this.environmentVariableDao.findSingleSelectEnvironmentVariableById(evId);
        EnvironmentVariableOption environmentVariableOption = new EnvironmentVariableOption(option);
        environmentVariable.addOption(environmentVariableOption);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void removeOptions(Long evId, List<String> optionLabels) {
        optionLabels.forEach(optionLabel -> {
            SingleSelectEnvironmentVariable environmentVariable = this.environmentVariableDao.findSingleSelectEnvironmentVariableById(evId);
            environmentVariable.removeOptionAndReorderList(optionLabel);
        });
        this.environmentVariableValueService.reinitializeEnvironmentVariableValuesByValueAndEvId(optionLabels, evId);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeOptionsPosition(Long environmentVariableId, Integer position, List<String> labels) {
        SingleSelectEnvironmentVariable environmentVariable = this.environmentVariableDao.findSingleSelectEnvironmentVariableById(environmentVariableId);
        environmentVariable.moveOptions(position.intValue(), labels);
    }

    private void checkDuplicateName(String name) {
        EnvironmentVariable nameDuplicate = this.environmentVariableDao.findByName(name);
        if (nameDuplicate != null) {
            throw new NameAlreadyInUseException("EnvironmentVariable", HtmlUtils.htmlEscape((String)name));
        }
    }
}

