/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.campaign;

import java.sql.Timestamp;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.Record4;
import org.jooq.Record6;
import org.jooq.Record8;
import org.jooq.SelectField;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOnConditionStep;
import org.jooq.impl.DSL;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.campaign.testplan.TestPlan;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.CoreUser;
import org.squashtest.tm.jooq.domain.tables.records.TestPlanItemRecord;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.campaign.AbstractTestPlanGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;
import org.squashtest.tm.service.internal.repository.display.IterationDisplayDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;

public class IterationTestPlanGrid
extends AbstractTestPlanGrid<TestPlanItemRecord> {
    private static final String TEST_SUITES_TABLE = "TEST_SUITES";
    private final Long testPlanId;
    private final IterationDisplayDao iterationDisplayDao;
    private final PermissionEvaluationService permissionEvaluationService;

    public IterationTestPlanGrid(Long testPlanId, String userLoginToRestrictTo, IterationDisplayDao iterationDisplayDao, PermissionEvaluationService permissionEvaluationService) {
        super(userLoginToRestrictTo);
        this.testPlanId = testPlanId;
        this.iterationDisplayDao = iterationDisplayDao;
        this.permissionEvaluationService = permissionEvaluationService;
    }

    @Override
    protected TableField<TestPlanItemRecord, Long> getItemIdColumn() {
        return Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID;
    }

    @Override
    protected TableField<TestPlanItemRecord, Long> getAssigneeIdColumn() {
        return Tables.TEST_PLAN_ITEM.ASSIGNEE_ID;
    }

    @Override
    protected TableField<TestPlanItemRecord, Long> getTestCaseIdColumn() {
        return Tables.TEST_PLAN_ITEM.TCLN_ID;
    }

    @Override
    protected TableOnConditionStep<Record> getItemTable() {
        return Tables.TEST_PLAN_ITEM.innerJoin((TableLike)Tables.TEST_PLAN).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN.TEST_PLAN_ID));
    }

    @Override
    protected Condition getSourceEntityCondition() {
        return Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Object)this.testPlanId);
    }

    @Override
    protected Long countRows(DSLContext dslContext, GridRequest request) {
        if (request.getFilterValues().isEmpty() && this.currentUserCanReadUnassigned(this.testPlanId)) {
            return this.iterationDisplayDao.getTestPlanItemCount(this.testPlanId, this.userLoginToRestrictTo);
        }
        return super.countRows(dslContext, request);
    }

    @Override
    protected List<GridColumn> getSpecificColumns() {
        return List.of(new GridColumn((Field<?>)Tables.ITERATION.ITERATION_ID), new GridColumn(DSL.coalesce((Field)DSL.field((Name)DSL.name((String[])new String[]{"INFERRED_EXECUTION_MODE", "INFERRED_EXECUTION_MODE"})), (Object)DSL.field((Name)DSL.name((String[])new String[]{"LAST_EXECUTION", "LAST_EXECUTION_MODE"}))).as("INFERRED_EXECUTION_MODE")), new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{"MILESTONE_DATES", "MILESTONE_MIN_DATE"}))), new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{"MILESTONE_DATES", "MILESTONE_MAX_DATE"}))), new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{"MILESTONE_DATES", "MILESTONE_LABELS"}))), new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{"BLOCKED_MILESTONE", "ITEM_ID"})).isNotNull().as("BOUND_TO_BLOCKING_MILESTONE")), new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{TEST_SUITES_TABLE, TEST_SUITES_TABLE}))));
    }

    @Override
    protected Table<?> getTable() {
        Table<Record8<Long, String, Long, String, String, String, String, String>> testCaseTable = this.getTestCaseTable();
        CoreUser executorUser = this.getExecutorUser();
        CoreUser assigneeUser = this.getAssigneeUser();
        Table<Record2<Long, String>> inferredExecutionModeTable = this.getAutomationFields();
        Table<Record6<Long, Long, String, String, Timestamp, String>> lastestExecutionTable = this.getLatestExecutionTable();
        Table<Record1<Long>> hasExecutableSteps = this.getHasExecutableSteps();
        Table<Record2<Long, String>> testSuites = this.getTestSuites();
        Table<Record1<Long>> boundToLockedMilestone = this.getBoundToBlockingMilestone();
        Table<Record4<Long, Timestamp, Timestamp, String>> milestoneDates = this.getMilestoneDates();
        return Tables.TEST_PLAN_ITEM.innerJoin((TableLike)Tables.ITERATION).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin(testCaseTable).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(testCaseTable.field("ITEM_ID", Long.class))).leftJoin((TableLike)assigneeUser).on(Tables.TEST_PLAN_ITEM.ASSIGNEE_ID.eq(assigneeUser.field("PARTY_ID", Long.class))).leftJoin((TableLike)executorUser).on(Tables.TEST_PLAN_ITEM.LAST_EXECUTED_BY.eq(executorUser.field("LOGIN", String.class))).leftJoin(inferredExecutionModeTable).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(inferredExecutionModeTable.field("ITEM_ID", Long.class))).leftJoin(testSuites).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(testSuites.field("ITEM_ID", Long.class))).leftJoin(lastestExecutionTable).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(lastestExecutionTable.field("ITEM_ID", Long.class))).leftJoin(hasExecutableSteps).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(hasExecutableSteps.field("ITEM_ID", Long.class))).leftJoin(milestoneDates).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(milestoneDates.field("ITEM_ID", Long.class))).leftJoin(boundToLockedMilestone).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(boundToLockedMilestone.field("ITEM_ID", Long.class))).leftJoin((TableLike)Tables.DATASET).on(Tables.TEST_PLAN_ITEM.DATASET_ID.eq((Field)Tables.DATASET.DATASET_ID).and(Tables.DATASET.TEST_CASE_ID.eq(testCaseTable.field("TEST_CASE_ID", Long.class)))).leftJoin((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).on(Tables.TEST_PLAN_ITEM.OVERVIEW_ID.eq((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID));
    }

    @Override
    protected Field<?> getIdentifier() {
        return Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID;
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID;
    }

    @Override
    protected SortField<?> getDefaultOrder() {
        return Tables.TEST_PLAN_ITEM.ITEM_ORDER.asc();
    }

    private Table<Record2<Long, String>> getTestSuites() {
        return DSL.select((SelectField)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.as("ITEM_ID"), (SelectField)DSL.listAgg((Field)Tables.TEST_SUITE.NAME, (String)", ").withinGroupOrderBy(new OrderField[]{Tables.TEST_SUITE_TEST_PLAN_ITEM.TEST_PLAN_ORDER}).as(TEST_SUITES_TABLE)).from((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).innerJoin((TableLike)Tables.TEST_SUITE).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Field)Tables.TEST_SUITE.ID)).innerJoin((TableLike)Tables.ITERATION_TEST_SUITE).on(Tables.TEST_SUITE.ID.eq((Field)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID)).innerJoin((TableLike)Tables.ITERATION).on(Tables.ITERATION_TEST_SUITE.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).where(Tables.ITERATION.TEST_PLAN_ID.eq((Object)this.testPlanId)).groupBy(new GroupField[]{Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID}).asTable(TEST_SUITES_TABLE);
    }

    private boolean currentUserCanReadUnassigned(Long testPlanId) {
        return this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.READ_UNASSIGNED.name(), testPlanId, TestPlan.class.getCanonicalName());
    }
}

