/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.artificialintelligence;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.exception.AuthenticationException;
import dev.langchain4j.exception.TimeoutException;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.service.Result;
import java.util.List;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.exception.artificialintelligence.server.AiServerAuthenticationErrorException;
import org.squashtest.tm.exception.artificialintelligence.server.InvalidJsonPathException;
import org.squashtest.tm.exception.artificialintelligence.server.MaxTokenLimitReachedException;
import org.squashtest.tm.exception.artificialintelligence.testcasegeneration.AiServerGenericErrorException;
import org.squashtest.tm.exception.artificialintelligence.testcasegeneration.AiServerTimeoutException;
import org.squashtest.tm.service.internal.artificialintelligence.AiAssistant;
import org.squashtest.tm.service.internal.artificialintelligence.AiServerSecurityService;
import org.squashtest.tm.service.internal.artificialintelligence.common.AbstractContentChunk;
import org.squashtest.tm.service.internal.artificialintelligence.common.ContentChunkConverter;
import org.squashtest.tm.service.internal.display.dto.aiserver.AiServerDto;

public class AiChatClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AiChatClient.class);
    private final AiAssistant aiAssistant;
    private final AiServerSecurityService aiServerSecurityService;
    private final AiServerDto aiServerDto;
    private final ChatModel chatModel;

    public AiChatClient(AiAssistant aiAssistant, AiServerSecurityService aiServerSecurityService, AiServerDto aiServerDto, ChatModel chatModel) {
        this.aiAssistant = aiAssistant;
        this.aiServerSecurityService = aiServerSecurityService;
        this.aiServerDto = aiServerDto;
        this.chatModel = chatModel;
    }

    public Result<String> doChatTextMessage(String userMessage) {
        Result<String> response;
        try {
            response = this.aiAssistant.doChat(userMessage);
        }
        catch (InvalidJsonPathException e) {
            LOGGER.error("The JSON path is not valid", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while sending request to AI server", (Throwable)e);
            throw this.aiServerSecurityService.sanitizeException(HtmlUtils.htmlEscape((String)e.getMessage()), this.aiServerDto);
        }
        this.checkIfMaxLimitTokenReached(response);
        return response;
    }

    public String doChatMultimodalMessage(List<AbstractContentChunk> chunks, String systemPrompt) {
        String response;
        ChatResponse chatResponse;
        List<Content> contents = ContentChunkConverter.convert(chunks);
        UserMessage multimodalMessage = UserMessage.from(contents);
        SystemMessage systemMessage = SystemMessage.from((String)systemPrompt);
        try {
            chatResponse = this.chatModel.chat(new ChatMessage[]{systemMessage, multimodalMessage});
            response = chatResponse.aiMessage().text();
        }
        catch (TimeoutException e) {
            LOGGER.error("AI request timed out", (Throwable)e);
            throw new AiServerTimeoutException();
        }
        catch (AuthenticationException e) {
            LOGGER.error("Authentication failed", (Throwable)e);
            throw new AiServerAuthenticationErrorException();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while sending request to AI server", (Throwable)e);
            throw new AiServerGenericErrorException();
        }
        this.checkIfMaxLimitTokenReached(chatResponse);
        return response;
    }

    private void checkIfMaxLimitTokenReached(Result<String> response) {
        if (FinishReason.LENGTH == response.finishReason()) {
            throw new MaxTokenLimitReachedException();
        }
    }

    private void checkIfMaxLimitTokenReached(ChatResponse response) {
        if (FinishReason.LENGTH == response.finishReason()) {
            throw new MaxTokenLimitReachedException();
        }
    }
}

