/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.tf;

import com.google.common.base.Strings;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.collection.ColumnFiltering;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequest;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.tf.IllegalAutomationRequestStatusException;
import org.squashtest.tm.service.audit.AuditModificationService;
import org.squashtest.tm.service.internal.repository.AutomationRequestDao;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.internal.repository.loaders.testcase.TestCaseLoader;
import org.squashtest.tm.service.internal.testautomation.UnsecuredAutomatedTestManagerService;
import org.squashtest.tm.service.internal.tf.event.AutomationRequestStatusChangeEvent;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.UserContextService;
import org.squashtest.tm.service.testautomation.model.AutomationRequestInfo;
import org.squashtest.tm.service.testautomation.model.TestAutomationProjectContent;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.service.tf.AutomationRequestFinderService;
import org.squashtest.tm.service.tf.AutomationRequestModificationService;

@Service
@Transactional
public class AutomationRequestManagementServiceImpl
implements AutomationRequestFinderService,
AutomationRequestModificationService {
    private static final String CAN_READ_REQUEST_OR_ADMIN = "hasPermission(#requestId, 'org.squashtest.tm.domain.tf.automationrequest.AutomationRequest', 'READ')  or hasRole('ROLE_ADMIN')";
    private static final String CAN_READ_TESTCASE_OR_ADMIN = "hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ') or hasRole('ROLE_ADMIN')";
    private static final String STATUS_NOT_PERMITTED = "Unknown status";
    private static final Logger LOGGER = LoggerFactory.getLogger(AutomationRequestManagementServiceImpl.class);
    @Inject
    private AutomationRequestDao requestDao;
    @Inject
    private UserDao userDao;
    @Inject
    private UserContextService userCtxt;
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private ApplicationEventPublisher eventPublisher;
    @Inject
    private TestCaseDao testCaseDao;
    @Inject
    private TestCaseModificationService testCaseModificationService;
    @Inject
    private UnsecuredAutomatedTestManagerService taService;
    @Inject
    private IterationTestPlanDao iterationTestPlanDao;
    @Inject
    private AuditModificationService auditModificationService;
    @Inject
    private TestCaseLoader testCaseLoader;

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasPermission(#requestId, 'org.squashtest.tm.domain.tf.automationrequest.AutomationRequest', 'READ')  or hasRole('ROLE_ADMIN')")
    public AutomationRequest findRequestById(long requestId) {
        return (AutomationRequest)this.requestDao.getReferenceById(requestId);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ') or hasRole('ROLE_ADMIN')")
    public AutomationRequest findRequestByTestCaseId(long testCaseId) {
        return this.requestDao.findByTestCaseId(testCaseId);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<AutomationRequest> findRequests(Pageable pageable) {
        List<Long> projectIds = this.projectFinder.findAllReadableIds();
        return this.requestDao.findAll(pageable, projectIds);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<AutomationRequest> findRequests(Pageable pageable, ColumnFiltering filtering) {
        List<Long> projectIds = this.projectFinder.findAllReadableIds();
        return this.requestDao.findAll(pageable, filtering, projectIds);
    }

    @Override
    public Page<AutomationRequest> findRequestsAssignedToCurrentUser(Pageable pageable, ColumnFiltering filtering) {
        List<Long> projectIds = this.projectFinder.findAllReadableIdsForAutomationWriter();
        String username = this.userCtxt.getUsername();
        return this.requestDao.findAllForAssignee(username, pageable, filtering, projectIds);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<AutomationRequest> findRequestsWithTransmittedStatus(Pageable pageble, ColumnFiltering filtering) {
        List<Long> projectIds = this.projectFinder.findAllReadableIdsForAutomationWriter();
        return this.requestDao.findAllTransmitted(pageble, filtering, projectIds);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<AutomationRequest> findRequestsForGlobal(Pageable pageable, ColumnFiltering filtering) {
        List<Long> projectIds = this.projectFinder.findAllReadableIdsForAutomationWriter();
        return this.requestDao.findAllForGlobal(pageable, filtering, projectIds);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<AutomationRequest> findRequestsToTransmitted(Pageable pageable, ColumnFiltering filtering) {
        List<Long> projectIds = this.projectFinder.findAllReadableIds();
        return this.requestDao.findAllValid(pageable, filtering, projectIds);
    }

    @Override
    public Page<AutomationRequest> findRequestsToValidate(Pageable pageable, ColumnFiltering filtering) {
        List<Long> projectIds = this.projectFinder.findAllReadableIds();
        return this.requestDao.findAllToValidate(pageable, filtering, projectIds);
    }

    @Override
    public Map<Long, String> getTcLastModifiedByToAutomationRequestNotAssigned(List<String> requestStatus) {
        List<Long> projectIds = this.projectFinder.findAllReadableIds();
        return this.requestDao.getTcLastModifiedByToAutomationRequestNotAssigned(requestStatus, projectIds);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteRequestByProjectId(long projectId) {
        this.requestDao.batchDeleteByProjectId(projectId);
    }

    @Override
    public void unassignRequests(List<Long> tcIds) {
        List requestIds = this.requestDao.getReqIdsByTcIds(tcIds);
        this.permissionEvaluationService.checkPermission(requestIds, Permissions.WRITE_AS_AUTOMATION.name(), AutomationRequest.class.getName());
        this.requestDao.unassignRequests(requestIds);
    }

    @Override
    @Transactional(readOnly=true)
    public Map<Long, String> getTcLastModifiedByForCurrentUser(List<String> requestStatus) {
        String userName = this.userCtxt.getUsername();
        List<Long> projectIds = this.projectFinder.findAllReadableIds();
        return this.requestDao.getTransmittedByForCurrentUser(this.userDao.findUserByLogin(userName).getId(), requestStatus, projectIds);
    }

    @Override
    @Transactional(readOnly=true)
    public Map<Long, String> getTcLastModifiedByForAutomationRequests(List<String> requestStatus) {
        List<Long> projectIds = this.projectFinder.findAllReadableIds();
        return this.requestDao.getTransmittedByForCurrentUser(null, requestStatus, projectIds);
    }

    @Override
    @Transactional(readOnly=true)
    public Map<Long, String> getAssignedToForAutomationRequests() {
        List<Long> projectIds = this.projectFinder.findAllReadableIds();
        return this.requestDao.getAssignedToForAutomationRequests(projectIds);
    }

    @Override
    public Integer countAutomationRequestForCurrentUser() {
        String userName = this.userCtxt.getUsername();
        return this.requestDao.countAutomationRequestForCurrentUser(this.userDao.findUserByLogin(userName).getId());
    }

    @Override
    public void assignedToRequest(List<Long> tcIds) {
        String username = this.userCtxt.getUsername();
        User user = this.userDao.findUserByLogin(username);
        List requestIds = this.requestDao.getReqIdsByTcIds(tcIds);
        this.permissionEvaluationService.checkPermission(requestIds, Permissions.WRITE_AS_AUTOMATION.name(), AutomationRequest.class.getName());
        this.requestDao.assignedToRequestIds(requestIds, user);
    }

    @Override
    public AutomationRequestModificationService.ChangeAutomatedRequestStatusResult changeAutomationRequestStatus(List<Long> tcIds, AutomationRequestStatus automationRequestStatus) {
        List<Long> testCaseIdsWithLockedMilestone = this.findAllTCIdsWithLockedMilestone(tcIds);
        tcIds.removeAll(testCaseIdsWithLockedMilestone);
        List eligibleTestCaseIds = this.testCaseDao.findAllEligibleTestCaseIds(tcIds);
        if (eligibleTestCaseIds.isEmpty()) {
            return new AutomationRequestModificationService.ChangeAutomatedRequestStatusResult(Collections.emptyMap(), tcIds, Collections.emptyList());
        }
        ArrayList<Long> transmittedAutomationRequestIds = new ArrayList();
        String username = this.userCtxt.getUsername();
        User user = this.userDao.findUserByLogin(username);
        List reqIds = this.requestDao.getReqIdsByTcIds(eligibleTestCaseIds);
        List automationRequestInfoList = this.requestDao.getAllAutomReqInfoByTcIds(eligibleTestCaseIds);
        HashMap<Long, String> noTAScriptTestCases = new HashMap();
        switch (automationRequestStatus) {
            case REJECTED: {
                this.permissionEvaluationService.checkPermission(reqIds, Permissions.WRITE_AS_AUTOMATION.name(), AutomationRequest.class.getName());
                this.requestDao.updateAutomationRequestStatus(reqIds, AutomationRequestStatus.REJECTED, Arrays.asList(AutomationRequestStatus.REJECTED, AutomationRequestStatus.AUTOMATION_IN_PROGRESS, AutomationRequestStatus.TRANSMITTED, AutomationRequestStatus.AUTOMATED));
                break;
            }
            case AUTOMATION_IN_PROGRESS: {
                this.permissionEvaluationService.checkPermission(reqIds, Permissions.WRITE_AS_AUTOMATION.name(), AutomationRequest.class.getName());
                this.requestDao.updateAutomationRequestStatus(reqIds, AutomationRequestStatus.AUTOMATION_IN_PROGRESS, Arrays.asList(AutomationRequestStatus.AUTOMATION_IN_PROGRESS, AutomationRequestStatus.AUTOMATED, AutomationRequestStatus.TRANSMITTED, AutomationRequestStatus.REJECTED));
                break;
            }
            case AUTOMATED: {
                this.checkPermissionForAutomationStatus(reqIds, automationRequestInfoList);
                noTAScriptTestCases = this.updateToAutomatedStatus(reqIds, automationRequestInfoList);
                break;
            }
            case TRANSMITTED: {
                this.permissionEvaluationService.checkPermission(reqIds, Permissions.WRITE_AS_FUNCTIONAL.name(), AutomationRequest.class.getName());
                transmittedAutomationRequestIds = this.requestDao.updateStatusToTransmitted(automationRequestInfoList, user);
                noTAScriptTestCases = this.updateTAScript(eligibleTestCaseIds);
                break;
            }
            case WORK_IN_PROGRESS: {
                this.permissionEvaluationService.checkPermission(reqIds, Permissions.WRITE_AS_FUNCTIONAL.name(), AutomationRequest.class.getName());
                this.requestDao.updateAutomationRequestStatus(reqIds, AutomationRequestStatus.WORK_IN_PROGRESS, Arrays.asList(AutomationRequestStatus.values()));
                break;
            }
            case SUSPENDED: {
                this.permissionEvaluationService.checkPermission(reqIds, Permissions.WRITE_AS_FUNCTIONAL.name(), AutomationRequest.class.getName());
                this.requestDao.updateAutomationRequestStatus(reqIds, AutomationRequestStatus.SUSPENDED, Arrays.asList(AutomationRequestStatus.values()));
                break;
            }
            case READY_TO_TRANSMIT: {
                this.permissionEvaluationService.checkPermission(reqIds, Permissions.WRITE_AS_FUNCTIONAL.name(), AutomationRequest.class.getName());
                this.requestDao.updateAutomationRequestStatus(reqIds, AutomationRequestStatus.READY_TO_TRANSMIT, Arrays.asList(AutomationRequestStatus.values()));
                break;
            }
            default: {
                throw new IllegalAutomationRequestStatusException(STATUS_NOT_PERMITTED);
            }
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new AutomationRequestStatusChangeEvent(reqIds, automationRequestStatus));
        List listTestCases = this.testCaseLoader.load(eligibleTestCaseIds);
        for (TestCase tc : listTestCases) {
            this.auditModificationService.updateAuditable((AuditableMixin)tc);
        }
        return new AutomationRequestModificationService.ChangeAutomatedRequestStatusResult(noTAScriptTestCases, tcIds, transmittedAutomationRequestIds);
    }

    private void checkPermissionForAutomationStatus(List<Long> reqIds, List<AutomationRequestInfo> automationRequestInfoList) {
        List<AutomationRequestInfo> withoutNativeSimplifiedAutomationRequestInfoList = automationRequestInfoList.stream().filter(automationRequest -> !automationRequest.isNativeSimplified()).toList();
        if (!withoutNativeSimplifiedAutomationRequestInfoList.isEmpty()) {
            this.permissionEvaluationService.checkPermission(reqIds, Permissions.WRITE_AS_AUTOMATION.name(), AutomationRequest.class.getName());
        }
    }

    private List<Long> findAllTCIdsWithLockedMilestone(List<Long> testCaseIds) {
        if (testCaseIds.isEmpty()) {
            return new ArrayList<Long>();
        }
        return this.testCaseDao.filterTestCaseIdsWithLockedMilestone(testCaseIds);
    }

    private Map<Long, String> updateToAutomatedStatus(List<Long> reqIds, List<AutomationRequestInfo> automationRequestInfoList) {
        List automationRequests = this.requestDao.findAllById(reqIds);
        Map<Object, Object> noTAScriptTestCases = new HashMap();
        List<Long> testCaseIdsEligibleToTA = automationRequests.stream().filter(automationRequest -> {
            TestCase testCase = automationRequest.getTestCase();
            return this.hasAtLeastOneEmptyAutomField(testCase);
        }).map(automationRequest -> automationRequest.getTestCase().getId()).toList();
        if (testCaseIdsEligibleToTA.isEmpty()) {
            this.requestDao.updateStatusToAutomated(automationRequestInfoList, AutomationRequestStatus.AUTOMATED, Arrays.asList(AutomationRequestStatus.TRANSMITTED, AutomationRequestStatus.WORK_IN_PROGRESS, AutomationRequestStatus.AUTOMATION_IN_PROGRESS, AutomationRequestStatus.AUTOMATED));
        } else {
            noTAScriptTestCases = this.updateTAScript(testCaseIdsEligibleToTA);
            if (noTAScriptTestCases.isEmpty() || this.checkIfUniqueTestCaseWithNoTaScriptIsNativeSimplifiedWorkflow(noTAScriptTestCases)) {
                this.requestDao.updateStatusToAutomated(automationRequestInfoList, AutomationRequestStatus.AUTOMATED, Arrays.asList(AutomationRequestStatus.TRANSMITTED, AutomationRequestStatus.WORK_IN_PROGRESS, AutomationRequestStatus.AUTOMATION_IN_PROGRESS, AutomationRequestStatus.AUTOMATED));
            }
        }
        return noTAScriptTestCases;
    }

    private boolean checkIfUniqueTestCaseWithNoTaScriptIsNativeSimplifiedWorkflow(Map<Long, String> noTAScriptTestCases) {
        if (noTAScriptTestCases.size() == 1) {
            Long testCaseId = (Long)((Map.Entry)noTAScriptTestCases.entrySet().stream().findFirst().get()).getKey();
            return AutomationWorkflowType.NATIVE_SIMPLIFIED.equals((Object)this.testCaseDao.findProjectAutomationWorkflowByTestCaseId(testCaseId));
        }
        return false;
    }

    private boolean hasAtLeastOneEmptyAutomField(TestCase testcase) {
        return testcase.getAutomatedTestTechnology() == null || testcase.getScmRepository() == null || Strings.isNullOrEmpty((String)testcase.getAutomatedTestReference());
    }

    @Override
    public void changePriority(List<Long> tcIds, Integer priority) {
        List reqIds = this.requestDao.getReqIdsByTcIds(tcIds);
        this.permissionEvaluationService.checkPermission(reqIds, Permissions.WRITE_AS_FUNCTIONAL.name(), AutomationRequest.class.getName());
        this.requestDao.updatePriority(tcIds, priority);
        List listTestCases = this.testCaseDao.findAllByIds(tcIds);
        for (TestCase tc : listTestCases) {
            this.auditModificationService.updateAuditable((AuditableMixin)tc);
        }
    }

    @Override
    public Integer countAutomationRequestValid() {
        List<Long> projectIds = this.projectFinder.findAllReadableIds();
        return this.requestDao.countAutomationRequestValid(projectIds);
    }

    @Override
    public Map<Long, String> updateTAScript(List<Long> tcIds) {
        LOGGER.debug("Update TA script of the following test cases: {}", new Object[]{tcIds.toString()});
        HashMap<Long, String> noTAScriptTestCases = new HashMap<Long, String>();
        List testCases = this.testCaseDao.findAllByIdsWithProject(tcIds);
        List<TestAutomationProject> testAutomationProjects = testCases.stream().flatMap(tc -> tc.getProject().getTestAutomationProjects().stream()).filter(AutomationRequestManagementServiceImpl.distinctByKey(tap -> Arrays.asList(tap.getServer().getId(), tap.getJobName()))).toList();
        Collection<TestAutomationProjectContent> taProjectContents = this.taService.listTestsFromRemoteServers(testAutomationProjects);
        testCases.stream().filter(tc -> tc.getProject().getTestAutomationServer() != null).forEach(tc -> {
            if (!tc.getProject().isAllowAutomationWorkflow() || !TestCaseAutomatable.Y.equals((Object)tc.getAutomatable())) {
                throw new IllegalArgumentException();
            }
            List<TestAutomationProjectContent> testAutomationProjectContentsFilteredByTestCaseAutomationServer = taProjectContents.stream().filter(tapc -> tapc.getProject().getServer().getId().equals(tc.getProject().getTestAutomationServer().getId())).toList();
            this.doTAScriptAssignation((TestCase)tc, (Collection<TestAutomationProjectContent>)testAutomationProjectContentsFilteredByTestCaseAutomationServer, (Map<Long, String>)noTAScriptTestCases);
        });
        return noTAScriptTestCases;
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    private void doTAScriptAssignation(TestCase testCase, Collection<TestAutomationProjectContent> testAutomationProjectContents, Map<Long, String> noTAScriptTestCases) {
        List<AutomatedTest> assignableAutomatedTestList = this.extractAssignableAutomatedTestList(testCase, testAutomationProjectContents);
        if (!assignableAutomatedTestList.isEmpty()) {
            if (assignableAutomatedTestList.size() == 1) {
                this.addOrEditAutomatedScript(testCase, assignableAutomatedTestList.get(0));
            } else {
                this.manageConflictAssociation(testCase, assignableAutomatedTestList, noTAScriptTestCases);
            }
        } else {
            this.manageNoScript(testCase, noTAScriptTestCases);
        }
    }

    private List<AutomatedTest> extractAssignableAutomatedTestList(TestCase testCase, Collection<TestAutomationProjectContent> testAutomationProjectContents) {
        return testAutomationProjectContents.stream().map(TestAutomationProjectContent::getTests).flatMap(Collection::stream).filter(automatedTest -> automatedTest.getLinkedTC().contains(testCase.getUuid())).toList();
    }

    private void manageConflictAssociation(TestCase tc, List<AutomatedTest> automatedTestList, Map<Long, String> losingTAScriptTestCases) {
        LOGGER.debug("Conflict of TA Script association detected for test case {}", new Object[]{tc.getId().toString()});
        this.requestDao.updateIsManual(tc.getId(), false);
        if (tc.getAutomatedTest() != null) {
            this.testCaseModificationService.removeAutomation(tc.getId());
        }
        losingTAScriptTestCases.put(tc.getId(), tc.getName());
        StringJoiner stringJoiner = new StringJoiner("#");
        automatedTestList.stream().map(AutomatedTest::getFullName).forEach(stringJoiner::add);
        this.requestDao.updateConflictAssociation(tc.getId(), stringJoiner.toString());
    }

    private void addOrEditAutomatedScript(TestCase tc, AutomatedTest automatedTest) {
        LOGGER.debug("Add TA Script {} to test case {}", new Object[]{automatedTest.getName(), tc.getId().toString()});
        TestAutomationProject trueAutomationProject = tc.getProject().getTestAutomationProjects().stream().filter(tap -> tap.getJobName().equals(automatedTest.getProject().getJobName())).findFirst().get();
        this.requestDao.updateIsManual(tc.getId(), false);
        if (tc.getAutomationRequest().getConflictAssociation() != null && !tc.getAutomationRequest().getConflictAssociation().isEmpty()) {
            this.requestDao.updateConflictAssociation(tc.getId(), "");
        }
        this.testCaseModificationService.bindAutomatedTestAutomatically(tc.getId(), trueAutomationProject.getId(), automatedTest.getName());
    }

    private void manageNoScript(TestCase tc, Map<Long, String> noTAScriptTestCases) {
        LOGGER.debug("No TA script associated with test case {}", new Object[]{tc.getId().toString()});
        if (!tc.getAutomationRequest().isManual()) {
            if (tc.getAutomatedTest() != null) {
                this.testCaseModificationService.removeAutomation(tc.getId());
            } else if (tc.getAutomationRequest().getConflictAssociation() != null && !tc.getAutomationRequest().getConflictAssociation().isEmpty()) {
                this.requestDao.updateConflictAssociation(tc.getId(), "");
            }
            this.requestDao.updateIsManual(tc.getId(), false);
            noTAScriptTestCases.put(tc.getId(), tc.getName());
        } else if (tc.getAutomatedTest() == null) {
            noTAScriptTestCases.put(tc.getId(), tc.getName());
        }
    }

    @Override
    public Map<Long, String> updateTAScriptForIteration(Long iterationId) {
        LOGGER.debug("Update TA script for following iteration's ITPI: {}", new Object[]{iterationId.toString()});
        Map<Long, String> result = new HashMap<Long, String>();
        List<TestPlanItem> items = this.iterationTestPlanDao.findAllByIterationIdWithTCAutomated(iterationId);
        if (!items.isEmpty()) {
            result = this.doItpiTAScriptUpdate(items);
        }
        return result;
    }

    @Override
    public Map<Long, String> updateTAScriptForTestSuite(Long testSuiteId) {
        LOGGER.debug("Update TA script for following test suite's ITPI: {}", new Object[]{testSuiteId.toString()});
        Map<Long, String> result = new HashMap<Long, String>();
        List<TestPlanItem> items = this.iterationTestPlanDao.findAllByTestSuiteIdWithTCAutomated(testSuiteId);
        if (!items.isEmpty()) {
            result = this.doItpiTAScriptUpdate(items);
        }
        return result;
    }

    @Override
    public Map<Long, String> updateTAScriptForItems(List<Long> testPlanIds) {
        LOGGER.debug("Update TA script of the following ITPI: {}", new Object[]{testPlanIds.toString()});
        Map<Long, String> result = new HashMap<Long, String>();
        List<TestPlanItem> items = this.iterationTestPlanDao.findAllByItemsIdWithTCAutomated(testPlanIds);
        if (!items.isEmpty()) {
            result = this.doItpiTAScriptUpdate(items);
        }
        return result;
    }

    private Map<Long, String> doItpiTAScriptUpdate(List<TestPlanItem> itpisToUpdate) {
        List<Long> tcIds = this.getListTcIdsFromListItems(itpisToUpdate);
        Map<Long, String> mapTcIdTcNameInConflict = this.updateTAScript(tcIds);
        return this.getListItpiIdNameTc(itpisToUpdate, mapTcIdTcNameInConflict);
    }

    private Map<Long, String> getListItpiIdNameTc(List<TestPlanItem> items, Map<Long, String> mapTcIdTcNameInConflict) {
        HashMap<Long, String> mapItpiIdTcNameInConflict = new HashMap<Long, String>();
        items.forEach(itpi -> {
            if (mapTcIdTcNameInConflict.containsKey(itpi.getReferencedTestCase().getId())) {
                mapItpiIdTcNameInConflict.put(itpi.getId(), (String)mapTcIdTcNameInConflict.get(itpi.getReferencedTestCase().getId()));
            }
        });
        return mapItpiIdTcNameInConflict;
    }

    private List<Long> getListTcIdsFromListItems(List<TestPlanItem> items) {
        return items.stream().map(itpi -> itpi.getReferencedTestCase().getId()).toList();
    }
}

