/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.resultpublisher;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.exception.EntityDoesNotExistException;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.service.internal.repository.AutomatedSuiteDao;
import org.squashtest.tm.service.testautomation.model.AutomatedExecutionState;
import org.squashtest.tm.service.testautomation.resultpublisher.ExecutionService;
import org.squashtest.tm.service.testautomation.resultpublisher.ResultPublicationService;

@Service(value="resultPublicationService")
@Transactional
public class ResultPublicationServiceImpl
implements ResultPublicationService {
    private final AutomatedSuiteDao autoSuiteDao;
    private final ExecutionService executionService;

    public ResultPublicationServiceImpl(AutomatedSuiteDao autoSuiteDao, ExecutionService executionService) {
        this.autoSuiteDao = autoSuiteDao;
        this.executionService = executionService;
    }

    @Override
    public void publishResult(String uuid, long testId, AutomatedExecutionState stateChange) {
        AutomatedSuite automatedSuite = this.autoSuiteDao.findByUuid(uuid).orElseThrow(() -> new EntityDoesNotExistException("AUTOMATED_SUITE", uuid));
        this.executionService.updateExecutionAndClearSession(testId, automatedSuite.getId(), stateChange);
    }
}

