/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.persistence.NoResultException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.api.plugin.PluginName;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestPlanStatistics;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.statistics.CountOnEnum;

@Repository
public class HibernateIterationDao
extends HibernateEntityDao<Iteration>
implements IterationDao {
    @Override
    public List<Iteration> findAllIterationContainingTestCase(long testCaseId) {
        return this.entityManager.createQuery("select it\nfrom Iteration it\njoin it.testPlan.testPlanItems tps\nwhere tps.referencedTestCase.id = :id", Iteration.class).setParameter("id", (Object)testCaseId).getResultList();
    }

    @UsedInPlugin(names={PluginName.API_REST})
    public TestPlanStatistics getIterationStatisticsByItpiIds(List<Long> itpiIds) {
        List result = this.entityManager.createQuery("select tp.executionStatus, count(tp)\nfrom TestPlanItem tp\nwhere tp.id in (:itpiIds)\ngroup by tp.executionStatus", Object[].class).setParameter("itpiIds", itpiIds).getResultList();
        LinkedHashMap<ExecutionStatus, Integer> canonicalStatusMap = CountOnEnum.fromTuples(result, ExecutionStatus.class).getStatistics(ExecutionStatus::getCanonicalStatus, ExecutionStatus.getCanonicalStatusSet());
        return new TestPlanStatistics(canonicalStatusMap);
    }

    @Override
    public Iteration findByUUID(String targetUUID) {
        return (Iteration)this.entityManager.createQuery("SELECT i FROM Iteration i WHERE i.uuid = :uuid", Iteration.class).setParameter("uuid", (Object)targetUUID).getSingleResult();
    }

    @Override
    public Long getProjectId(long iterationId) {
        return (Long)this.entityManager.createQuery("select it.campaign.project.id from Iteration it where it.id = :id", Long.class).setParameter("id", (Object)iterationId).getSingleResult();
    }

    @Override
    public List<Long> findTestPlanIds(long iterationId) {
        return this.entityManager.createQuery("select tp.id from Iteration it join it.testPlan.testPlanItems tp where it.id = :id", Long.class).setParameter("id", (Object)iterationId).getResultList();
    }

    @Override
    public List<Iteration> loadContainersForPaste(Collection<Long> ids) {
        List iterations = this.entityManager.createQuery("    select it\n    from Iteration it\n    left join fetch it.testSuites\n    where it.id in (:ids)\n", Iteration.class).setParameter("ids", ids).getResultList();
        this.entityManager.createQuery("    select it\n    from Iteration it\n    join fetch it.testPlan tp\n    left join fetch tp.testPlanItems tpi\n    left join fetch tpi.referencedTestCase\n    where it.id in (:ids)\n", Iteration.class).setParameter("ids", ids).getResultList();
        return iterations;
    }

    @Override
    public Iteration loadContainerForPaste(long id) {
        return (Iteration)this.loadContainersForPaste(List.of(Long.valueOf(id))).stream().findFirst().orElseThrow(NoResultException::new);
    }

    @Override
    public List<Iteration> loadNodeForPaste(Collection<Long> ids) {
        List iterations = this.entityManager.createQuery("select i\nfrom Iteration i\njoin fetch i.campaign\njoin fetch i.attachmentList al\nleft join fetch al.attachments a\nwhere i.id in :ids", Iteration.class).setParameter("ids", ids).getResultList();
        this.entityManager.createQuery("select i\nfrom Iteration i\njoin fetch i.testPlan tp\nleft join fetch tp.testPlanItems tpi\nleft join fetch tpi.referencedTestCase\nleft join fetch tpi.exploratorySessionOverview eso\nleft join fetch eso.attachmentList al\nleft join fetch al.attachments a\nwhere i.id in :ids", Iteration.class).setParameter("ids", ids).getResultList();
        this.entityManager.createQuery("select i\nfrom Iteration i\njoin fetch i.testSuites ts\nleft join fetch ts.testPlanItems\nleft join fetch ts.attachmentList al\nleft join fetch al.attachments a\nwhere i.id in :ids", Iteration.class).setParameter("ids", ids).getResultList();
        return iterations;
    }

    @Override
    public boolean hasDeletedTestCaseInTestPlan(long iterationId) {
        return (Boolean)this.entityManager.createQuery("select count(i) > 0\nfrom Iteration i\njoin i.testPlan tp\njoin tp.testPlanItems item\nwhere i.id = :id and item.referencedTestCase is null", Boolean.class).setParameter("id", (Object)iterationId).getSingleResult();
    }

    @Override
    public Iteration loadForExecutionResume(long iterationId) {
        List itemIds = this.entityManager.createQuery("select item.id\nfrom Iteration it\njoin it.testPlan tp\njoin tp.testPlanItems item\nwhere it.id = :id", Long.class).setParameter("id", (Object)iterationId).getResultList();
        if (!itemIds.isEmpty()) {
            this.entityManager.createQuery("select distinct tpi\nfrom TestPlanItem tpi\nleft join fetch tpi.executions exec\nleft join fetch exec.steps\nleft join fetch exec.automatedExecutionExtender\nwhere tpi.id in :itemIds", TestPlanItem.class).setParameter("itemIds", (Object)itemIds).getResultList();
            this.entityManager.createQuery("select distinct tc\nfrom TestCase tc\nleft join fetch tc.steps\nwhere tc.id in (\n    select tpi.referencedTestCase.id\n    from TestPlanItem tpi\n    where tpi.id in :itemIds\n    and tpi.referencedTestCase is not null\n)", TestCase.class).setParameter("itemIds", (Object)itemIds).getResultList();
        }
        return (Iteration)this.entityManager.createQuery("select distinct it\nfrom Iteration it\nleft join fetch it.testPlan tp\nleft join fetch tp.testPlanItems item\nwhere it.id = :id", Iteration.class).setParameter("id", (Object)iterationId).getSingleResult();
    }

    @Override
    public Iteration loadWithTestSuites(long iterationId) {
        return (Iteration)this.entityManager.createQuery("select it\nfrom Iteration it\nleft join fetch it.testSuites ts\nwhere it.id = :id", Iteration.class).setParameter("id", (Object)iterationId).getSingleResult();
    }

    @Override
    public long countTestSuitesInIterations(List<Long> iterationsIds) {
        return (Long)this.entityManager.createQuery("select count(ts)\nfrom Iteration it\njoin it.testSuites ts\nwhere it.id in :ids", Long.TYPE).setParameter("ids", iterationsIds).getSingleResult();
    }

    @Override
    public List<Long> getTestPlanItemIdsAssignedToUser(long testPlanOwnerId, String testerLogin) {
        return this.entityManager.createQuery("select tpi.id\nfrom Iteration it\njoin it.testPlan.testPlanItems tpi\njoin tpi.assignee assignee\nwhere it.id = :id and assignee.login = :login", Long.class).setParameter("id", (Object)testPlanOwnerId).setParameter("login", (Object)testerLogin).getResultList();
    }
}

