/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.File;
import java.io.IOException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.stereotype.Service;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.TestPlanItemPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotMetaDataModel;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AttachmentPivotType;
import org.squashtest.tm.service.pivot.PivotFileManager;
import org.squashtest.tm.service.pivot.projectexporter.ExecutionPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.ExecutionWsPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.SprintPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.CampaignPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.IterationPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.TestSuitePivotDao;

@Service
public class ExecutionWsPivotExporterServiceImpl
implements ExecutionWsPivotExporterService {
    private final CampaignPivotDao campaignPivotDao;
    private final IterationPivotDao iterationPivotDao;
    private final PivotFileManager pivotFileManager;
    private final TestSuitePivotDao testSuitePivotDao;
    private final ExecutionPivotDao executionPivotDao;
    private final SprintPivotDao sprintPivotDao;

    public ExecutionWsPivotExporterServiceImpl(CampaignPivotDao campaignPivotDao, IterationPivotDao iterationPivotDao, PivotFileManager pivotFileManager, TestSuitePivotDao testSuitePivotDao, ExecutionPivotDao executionPivotDao, SprintPivotDao sprintPivotDao) {
        this.campaignPivotDao = campaignPivotDao;
        this.iterationPivotDao = iterationPivotDao;
        this.pivotFileManager = pivotFileManager;
        this.testSuitePivotDao = testSuitePivotDao;
        this.executionPivotDao = executionPivotDao;
        this.sprintPivotDao = sprintPivotDao;
    }

    @Override
    public void generateCampaignJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, File tmpAttachmentDir, Long projectId) throws IOException {
        if (!this.campaignPivotDao.hasCampaignByProjectId(projectId)) {
            return;
        }
        File attachmentDir = this.pivotFileManager.createAttachmentDir(tmpAttachmentDir, AttachmentPivotType.CAMPAIGN);
        this.pivotFileManager.writePivotObjectToZip(jsonFactory, jsonGenerator -> this.handleCampaigns((JsonGenerator)jsonGenerator, attachmentDir, projectId), JsonImportFile.CAMPAIGNS, archive);
        this.pivotFileManager.addAttachmentsToZip(archive, tmpAttachmentDir, attachmentDir);
    }

    private void handleCampaigns(JsonGenerator jsonGenerator, File attachmentDir, Long projectId) {
        this.campaignPivotDao.getCampaignByProjectId(projectId, campaignPivot -> this.pivotFileManager.writePivotObject(campaignPivot, jsonGenerator, JsonImportFile.CAMPAIGNS), attachmentPivot -> this.pivotFileManager.saveTmpSaveAttachment(attachmentDir, (AttachmentPivot)attachmentPivot));
    }

    @Override
    public void generateIterationJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, File tmpAttachmentDir, Long projectId, PivotMetaDataModel pivotMetaDataModel) throws IOException {
        if (!this.iterationPivotDao.hasIterationByProjectId(projectId)) {
            return;
        }
        File attachmentDir = this.pivotFileManager.createAttachmentDir(tmpAttachmentDir, AttachmentPivotType.ITERATION);
        this.pivotFileManager.writePivotObjectToZip(jsonFactory, jsonGenerator -> this.handleIteration((JsonGenerator)jsonGenerator, attachmentDir, projectId, pivotMetaDataModel), JsonImportFile.ITERATIONS, archive);
        this.pivotFileManager.addAttachmentsToZip(archive, tmpAttachmentDir, attachmentDir);
    }

    private void handleIteration(JsonGenerator jsonGenerator, File attachmentDir, Long projectId, PivotMetaDataModel pivotMetaDataModel) {
        this.iterationPivotDao.getIterationByProjectId(projectId, iterationPivot -> {
            iterationPivot.getTestPlanItems().forEach(testPlanItemPivot -> this.saveExecutionStatus((TestPlanItemPivot)testPlanItemPivot, pivotMetaDataModel));
            this.pivotFileManager.writePivotObject(iterationPivot, jsonGenerator, JsonImportFile.ITERATIONS);
        }, attachmentPivot -> this.pivotFileManager.saveTmpSaveAttachment(attachmentDir, (AttachmentPivot)attachmentPivot));
    }

    @Override
    public void generateTestSuiteJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, File tmpAttachmentDir, Long projectId, PivotMetaDataModel pivotMetaDataModel) throws IOException {
        if (!this.testSuitePivotDao.hasTestSuiteByProjectId(projectId)) {
            return;
        }
        File attachmentDir = this.pivotFileManager.createAttachmentDir(tmpAttachmentDir, AttachmentPivotType.TEST_SUITE);
        this.pivotFileManager.writePivotObjectToZip(jsonFactory, jsonGenerator -> this.handleTestSuite((JsonGenerator)jsonGenerator, attachmentDir, projectId, pivotMetaDataModel), JsonImportFile.TEST_SUITES, archive);
        this.pivotFileManager.addAttachmentsToZip(archive, tmpAttachmentDir, attachmentDir);
    }

    private void handleTestSuite(JsonGenerator jsonGenerator, File attachmentDir, Long projectId, PivotMetaDataModel pivotMetaDataModel) {
        this.testSuitePivotDao.getTestSuiteByProjectId(projectId, testSuitePivot -> {
            pivotMetaDataModel.addExecutionStatusConflicts(testSuitePivot.getStatus());
            this.pivotFileManager.writePivotObject(testSuitePivot, jsonGenerator, JsonImportFile.TEST_SUITES);
        }, attachmentPivot -> this.pivotFileManager.saveTmpSaveAttachment(attachmentDir, (AttachmentPivot)attachmentPivot));
    }

    @Override
    public void generateExecutionJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, File tmpAttachmentDir, Long projectId, PivotMetaDataModel pivotMetaDataModel) throws IOException {
        if (!this.executionPivotDao.hasExecutionByProjectId(projectId)) {
            return;
        }
        File attachmentDir = this.pivotFileManager.createAttachmentDir(tmpAttachmentDir, AttachmentPivotType.EXECUTION);
        this.pivotFileManager.writePivotObjectToZip(jsonFactory, jsonGenerator -> this.handleExecution((JsonGenerator)jsonGenerator, attachmentDir, projectId, pivotMetaDataModel), JsonImportFile.EXECUTIONS, archive);
        this.pivotFileManager.addAttachmentsToZip(archive, tmpAttachmentDir, attachmentDir);
    }

    private void handleExecution(JsonGenerator jsonGenerator, File attachmentDir, Long projectId, PivotMetaDataModel pivotMetaDataModel) {
        this.executionPivotDao.getExecutionByProjectId(projectId, executionPivot -> {
            pivotMetaDataModel.addExecutionStatusConflicts(executionPivot.getStatus());
            executionPivot.getExecutionSteps().forEach(steps -> pivotMetaDataModel.addExecutionStatusConflicts(steps.getStatus()));
            this.pivotFileManager.writePivotObject(executionPivot, jsonGenerator, JsonImportFile.EXECUTIONS);
        }, attachmentPivot -> this.pivotFileManager.saveTmpSaveAttachment(attachmentDir, (AttachmentPivot)attachmentPivot));
    }

    @Override
    public void generateSprintJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, File tmpAttachmentDir, Long projectId, PivotMetaDataModel pivotMetaDataModel) throws IOException {
        if (!this.sprintPivotDao.hasSprintByProjectId(projectId)) {
            return;
        }
        File attachmentDir = this.pivotFileManager.createAttachmentDir(tmpAttachmentDir, AttachmentPivotType.SPRINT);
        this.pivotFileManager.writePivotObjectToZip(jsonFactory, jsonGenerator -> this.handleSprint((JsonGenerator)jsonGenerator, attachmentDir, projectId, pivotMetaDataModel), JsonImportFile.SPRINTS, archive);
        this.pivotFileManager.addAttachmentsToZip(archive, tmpAttachmentDir, attachmentDir);
    }

    private void handleSprint(JsonGenerator jsonGenerator, File attachmentDir, Long projectId, PivotMetaDataModel pivotMetaDataModel) {
        this.sprintPivotDao.getSprintByProjectId(projectId, sprintPivot -> {
            sprintPivot.getSprintReqVersions().stream().flatMap(srv -> srv.getTestPlanItems().stream()).forEach(testPlanItemPivot -> this.saveExecutionStatus((TestPlanItemPivot)testPlanItemPivot, pivotMetaDataModel));
            this.pivotFileManager.writePivotObject(sprintPivot, jsonGenerator, JsonImportFile.SPRINTS);
        }, attachmentPivot -> this.pivotFileManager.saveTmpSaveAttachment(attachmentDir, (AttachmentPivot)attachmentPivot));
    }

    private void saveExecutionStatus(TestPlanItemPivot testPlanItemPivot, PivotMetaDataModel pivotMetaDataModel) {
        pivotMetaDataModel.addExecutionStatusConflicts(testPlanItemPivot.getExecutionStatus());
    }
}

