/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign.export.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.Record5;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.WindowSpecification;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomFieldValueType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.InfoListItem;
import org.squashtest.tm.service.internal.attachment.AttachmentHelper;
import org.squashtest.tm.service.internal.dto.CustomFieldValueDto;
import org.squashtest.tm.service.internal.dto.NumericCufHelper;
import org.squashtest.tm.service.internal.jooq.SubElementRecordProcessor;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

public abstract class AbstractCampaignExportDao {
    protected static final Integer BATCH_SIZE = 200;
    protected static final String TAG_SEPARATOR = " | ";
    protected static final String MILESTONE_SEPARATOR = "|";
    protected static final String SUITE_NAME_SEPARATOR = ",";
    protected static final String LAST_EXECUTION_CTE = "last_execution_cte";
    protected static final InfoListItem TC_NATURE_TABLE = Tables.INFO_LIST_ITEM.as("test_case_nature");
    protected static final InfoListItem TC_TYPE_TABLE = Tables.INFO_LIST_ITEM.as("test_case_type");
    protected static final Field<Integer> EXECUTION_POSITION = DSL.field((String)"execution_position", Integer.class);
    public static final Field<Long> EXECUTION_COUNT = DSL.field((String)"execution_count", Long.class);
    public static final Field<Long> TC_COVERAGE_COUNT = DSL.field((String)"tc_coverage_count", Long.class);
    public static final Field<Long> TS_COVERAGE_COUNT = DSL.field((String)"ts_coverage_count", Long.class);
    public static final Field<Long> EXECUTION_ISSUE_COUNT = DSL.field((String)"execution_issue_count", Long.class);
    public static final Field<Long> EXECUTION_STEP_ISSUE_COUNT = DSL.field((String)"execution_step_issue_count", Long.class);
    public static final Field<String> TC_MILESTONE_LABELS = DSL.field((String)"test_case_milestone_labels", String.class);
    public static final Field<String> SUITE_NAMES = DSL.field((String)"test_suite_names", String.class);
    public static final Field<String> TC_NATURE_CODE = AbstractCampaignExportDao.TC_NATURE_TABLE.CODE;
    public static final Field<String> TC_TYPE_CODE = AbstractCampaignExportDao.TC_TYPE_TABLE.CODE;
    public static final Field<String> IT_STANDARD = DSL.field((String)"it_standard", String.class);
    public static final Field<String> EXECUTION_RATE = DSL.field((String)"execution_rate", String.class);
    protected final DSLContext dsl;

    protected AbstractCampaignExportDao(DSLContext dsl) {
        this.dsl = dsl;
    }

    private Select<Record> getLastExecutionTable(Long campaignId, List<Field<?>> fields) {
        ArrayList selectFields = new ArrayList(fields);
        Field position = DSL.rowNumber().over((WindowSpecification)DSL.partitionBy((GroupField[])new GroupField[]{Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID}).orderBy(new OrderField[]{Tables.EXECUTION.EXECUTION_ORDER.desc()})).as(EXECUTION_POSITION);
        selectFields.add(position);
        Table executionTable = DSL.select(selectFields).from((TableLike)Tables.CAMPAIGN_ITERATION).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).join((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId)).asTable();
        List<Field> aliasFields = fields.stream().map(arg_0 -> ((Table)executionTable).field(arg_0)).toList();
        return this.dsl.select(aliasFields).from((TableLike)executionTable).where(EXECUTION_POSITION.eq((Object)1));
    }

    protected CommonTableExpression<Record> getLastExecutionQueryCte(Long campaignId, List<Field<?>> additionalFields) {
        Field executionCountField = DSL.count().over((WindowSpecification)DSL.partitionBy((GroupField[])new GroupField[]{Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID})).as(EXECUTION_COUNT);
        ArrayList fields = new ArrayList(List.of(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, Tables.EXECUTION.EXECUTION_ID, executionCountField));
        fields.addAll(additionalFields);
        return DSL.name((String)LAST_EXECUTION_CTE).as(this.getLastExecutionTable(campaignId, fields));
    }

    private Table<Record> getLastExecutionCufTable(Long campaignId) {
        List<TableField> fields = List.of(Tables.CAMPAIGN_ITERATION.ITERATION_ORDER, Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, Tables.TEST_PLAN_ITEM.ITEM_ORDER, Tables.EXECUTION.EXECUTION_ID);
        return this.getLastExecutionTable(campaignId, fields).asTable();
    }

    protected Table<Record2<Long, Integer>> getExecutionIssueCountsTable(CommonTableExpression<Record> lastExecutionCte) {
        return DSL.select((SelectField)Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID.as((Field)Tables.EXECUTION.EXECUTION_ID), (SelectField)DSL.count((Field)Tables.EXECUTION_ISSUES_CLOSURE.ISSUE_ID).as(EXECUTION_ISSUE_COUNT)).from(lastExecutionCte).join((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).on(Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID.eq(lastExecutionCte.field((Field)Tables.EXECUTION.EXECUTION_ID))).groupBy(new GroupField[]{Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID}).asTable();
    }

    protected Table<Record2<Long, Integer>> getExecutionStepIssueCountsTable(CommonTableExpression<Record> lastExecutionCte) {
        return DSL.select((SelectField)Tables.EXECUTION_STEP.EXECUTION_STEP_ID, (SelectField)DSL.count((Field)Tables.ISSUE.ISSUE_ID).as(EXECUTION_STEP_ISSUE_COUNT)).from(lastExecutionCte).join((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq(lastExecutionCte.field((Field)Tables.EXECUTION.EXECUTION_ID))).join((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_STEP.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID)).join((TableLike)Tables.ISSUE).on(Tables.ISSUE.ISSUE_LIST_ID.eq((Field)Tables.EXECUTION_STEP.ISSUE_LIST_ID)).groupBy(new GroupField[]{Tables.EXECUTION_STEP.EXECUTION_STEP_ID}).asTable();
    }

    protected Table<Record2<Long, String>> getTestSuiteNames(Long campaignId) {
        return this.dsl.select((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (SelectField)DSL.groupConcat((Field)Tables.TEST_SUITE.NAME).separator(SUITE_NAME_SEPARATOR).as(SUITE_NAMES)).from((TableLike)Tables.CAMPAIGN_ITERATION).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).join((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).join((TableLike)Tables.TEST_SUITE).on(Tables.TEST_SUITE.ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID)).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId)).groupBy(new GroupField[]{Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID}).asTable();
    }

    protected CommonTableExpression<Record1<Long>> getTestCaseIdsCte(Long campaignId) {
        return DSL.name((String)"test_case_ids_cte").as((ResultQuery)DSL.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).from((TableLike)Tables.CAMPAIGN_ITERATION).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TCLN_ID)).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId)).and(ConditionsConstants.TCLN_NOT_IN_BIN).groupBy(new GroupField[]{Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID}));
    }

    protected Table<Record2<Long, Integer>> getTestCaseCoverageCountsTable(CommonTableExpression<? extends Record> testCaseIds) {
        return DSL.select((SelectField)testCaseIds.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID), (SelectField)DSL.count((Field)Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID).as(TC_COVERAGE_COUNT)).from(testCaseIds).join((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq(testCaseIds.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID))).groupBy(new GroupField[]{testCaseIds.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)}).asTable();
    }

    protected Table<Record2<Long, String>> getTestCaseMilestone(CommonTableExpression<? extends Record> testCaseIds) {
        return this.dsl.select((SelectField)Objects.requireNonNull(testCaseIds.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)), (SelectField)DSL.groupConcat((Field)Tables.MILESTONE.LABEL).separator(MILESTONE_SEPARATOR).as(TC_MILESTONE_LABELS)).from(testCaseIds).join((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq(testCaseIds.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID))).join((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_TEST_CASE.MILESTONE_ID)).groupBy(new GroupField[]{testCaseIds.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)}).asTable();
    }

    protected Table<Record2<Long, String>> getCampaignMilestones(Long campaignId) {
        return this.dsl.select((SelectField)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID, (SelectField)DSL.groupConcat((Field)Tables.MILESTONE.LABEL).separator(MILESTONE_SEPARATOR).as((Field)Tables.MILESTONE.LABEL)).from((TableLike)Tables.CAMPAIGN_ITERATION).join((TableLike)Tables.MILESTONE_CAMPAIGN).on(Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).join((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_CAMPAIGN.MILESTONE_ID)).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId)).groupBy(new GroupField[]{Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID}).asTable();
    }

    protected Map<BindableEntity, List<String>> getCufHeaderQuery(Long campaignId, List<BindableEntity> bindableEntities) {
        List<String> bindableEntityNames = bindableEntities.stream().map(Enum::name).toList();
        Table cufTable = DSL.select((SelectField)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY, (SelectField)Tables.CUSTOM_FIELD.CODE).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CUSTOM_FIELD_BINDING).on(Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID)).join((TableLike)Tables.CUSTOM_FIELD).on(Tables.CUSTOM_FIELD.CF_ID.eq((Field)Tables.CUSTOM_FIELD_BINDING.CF_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Object)campaignId)).and(Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY.in(bindableEntityNames)).union((Select)DSL.select((SelectField)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY, (SelectField)Tables.CUSTOM_FIELD.CODE).from((TableLike)Tables.CAMPAIGN_ITERATION).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TCLN_ID)).join((TableLike)Tables.CUSTOM_FIELD_BINDING).on(Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).join((TableLike)Tables.CUSTOM_FIELD).on(Tables.CUSTOM_FIELD.CF_ID.eq((Field)Tables.CUSTOM_FIELD_BINDING.CF_ID)).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId)).and(Tables.TEST_PLAN_ITEM.TCLN_ID.isNotNull()).and(Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY.eq((Object)BindableEntity.TEST_CASE.name()))).asTable();
        return this.dsl.select((SelectField)Objects.requireNonNull(cufTable.field((Field)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY)).as((Field)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY), (SelectField)Objects.requireNonNull(cufTable.field((Field)Tables.CUSTOM_FIELD.CODE)).as((Field)Tables.CUSTOM_FIELD.CODE)).from((TableLike)cufTable).groupBy(new GroupField[]{cufTable.field((Field)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY), cufTable.field((Field)Tables.CUSTOM_FIELD.CODE)}).fetchGroups(record -> BindableEntity.valueOf((String)((String)record.get((Field)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY))), record -> (String)record.get((Field)Tables.CUSTOM_FIELD.CODE));
    }

    private <R extends Record> ResultQuery<Record5<Long, Long, String, String, String>> getCufQuery(Table<R> entityTable, Field<Long> entityIdField, BindableEntity bindableEntity, List<Field<?>> orderFields) {
        ArrayList<Object> groupByFields = new ArrayList<Object>();
        groupByFields.add(entityIdField);
        groupByFields.add(Tables.CUSTOM_FIELD_VALUE.CFV_ID);
        groupByFields.add(Tables.CUSTOM_FIELD.CODE);
        groupByFields.add(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE);
        groupByFields.addAll(orderFields);
        return this.dsl.select((SelectField)entityIdField.as("ID"), (SelectField)Tables.CUSTOM_FIELD_VALUE.CFV_ID, (SelectField)Tables.CUSTOM_FIELD.CODE, (SelectField)Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE, (SelectField)DSL.when((Condition)Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)CustomFieldValueType.CF.name()), (Field)CustomFieldValueType.CF.getValueColumn()).when(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)CustomFieldValueType.RTF.name()), CustomFieldValueType.RTF.getValueColumn()).when(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)CustomFieldValueType.NUM.name()), DSL.coalesce((Field)CustomFieldValueType.NUM.getValueColumn(), (Object)"")).when(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)CustomFieldValueType.TAG.name()), (Field)DSL.groupConcat((Field)Tables.CUSTOM_FIELD_VALUE_OPTION.LABEL).separator(TAG_SEPARATOR)).otherwise((Object)"").as((Field)Tables.CUSTOM_FIELD_VALUE.VALUE)).from(entityTable).join((TableLike)Tables.CUSTOM_FIELD_VALUE).on(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.eq(entityIdField)).join((TableLike)Tables.CUSTOM_FIELD).on(Tables.CUSTOM_FIELD.CF_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE.CF_ID)).leftJoin((TableLike)Tables.CUSTOM_FIELD_VALUE_OPTION).on(Tables.CUSTOM_FIELD_VALUE_OPTION.CFV_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE.CFV_ID)).where(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE.eq((Object)bindableEntity.name())).groupBy(groupByFields).orderBy(orderFields).fetchSize(BATCH_SIZE.intValue());
    }

    public ResultQuery<Record5<Long, Long, String, String, String>> getCampaignCufQuery(Long campaignId) {
        Table table = DSL.select((SelectField)Tables.CAMPAIGN.CLN_ID).from((TableLike)Tables.CAMPAIGN).where(Tables.CAMPAIGN.CLN_ID.eq((Object)campaignId)).asTable();
        return this.getCufQuery(table, (Field<Long>)Objects.requireNonNull(table.field((Field)Tables.CAMPAIGN.CLN_ID)), BindableEntity.CAMPAIGN, List.of());
    }

    public ResultQuery<Record5<Long, Long, String, String, String>> getIterationCufQuery(Long campaignId) {
        Table table = DSL.select((SelectField)Tables.CAMPAIGN_ITERATION.ITERATION_ID, (SelectField)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER).from((TableLike)Tables.CAMPAIGN_ITERATION).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId)).asTable();
        return this.getCufQuery(table, (Field<Long>)Objects.requireNonNull(table.field((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)), BindableEntity.ITERATION, List.of(Objects.requireNonNull(table.field((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER))));
    }

    public ResultQuery<Record5<Long, Long, String, String, String>> getTestCaseCufQuery(Long campaignId) {
        Table table = DSL.select((SelectField)Tables.TEST_PLAN_ITEM.TCLN_ID, (SelectField)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER, (SelectField)Tables.TEST_PLAN_ITEM.ITEM_ORDER).from((TableLike)Tables.CAMPAIGN_ITERATION).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId)).and(Tables.TEST_PLAN_ITEM.TCLN_ID.isNotNull()).asTable();
        return this.getCufQuery(table, (Field<Long>)Objects.requireNonNull(table.field((Field)Tables.TEST_PLAN_ITEM.TCLN_ID)), BindableEntity.TEST_CASE, List.of(Objects.requireNonNull(table.field((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER)), Objects.requireNonNull(table.field((Field)Tables.TEST_PLAN_ITEM.ITEM_ORDER))));
    }

    public ResultQuery<Record5<Long, Long, String, String, String>> getExecutionCufQuery(Long campaignId) {
        Table<Record> lastExecution = this.getLastExecutionCufTable(campaignId);
        return this.getCufQuery(lastExecution, (Field<Long>)Objects.requireNonNull(lastExecution.field((Field)Tables.EXECUTION.EXECUTION_ID)), BindableEntity.EXECUTION, List.of(Objects.requireNonNull(lastExecution.field((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER)), Objects.requireNonNull(lastExecution.field((Field)Tables.TEST_PLAN_ITEM.ITEM_ORDER))));
    }

    public ResultQuery<Record5<Long, Long, String, String, String>> getExecutionStepCufQuery(Long campaignId) {
        Table<Record> lastExecution = this.getLastExecutionCufTable(campaignId);
        Table table = DSL.select((SelectField)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID, (SelectField)lastExecution.field((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER), (SelectField)lastExecution.field((Field)Tables.TEST_PLAN_ITEM.ITEM_ORDER), (SelectField)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER).from(lastExecution).join((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq(lastExecution.field((Field)Tables.EXECUTION.EXECUTION_ID))).asTable();
        return this.getCufQuery(table, (Field<Long>)Objects.requireNonNull(table.field((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID)), BindableEntity.EXECUTION_STEP, List.of(Objects.requireNonNull(table.field((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER)), Objects.requireNonNull(table.field((Field)Tables.TEST_PLAN_ITEM.ITEM_ORDER)), Objects.requireNonNull(table.field((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER))));
    }

    protected CustomFieldValueDto toCustomFieldValueDto(Record record) {
        String value = (String)record.get((Field)Tables.CUSTOM_FIELD_VALUE.VALUE);
        if (CustomFieldValueType.NUM.name().equals(record.get((Field)Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE))) {
            value = NumericCufHelper.formatOutputNumericCufValue(value);
        } else if (CustomFieldValueType.RTF.name().equals(record.get((Field)Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE))) {
            value = AttachmentHelper.adaptHtmlImageExport(value);
        }
        return new CustomFieldValueDto((Long)record.get((Field)Tables.CUSTOM_FIELD_VALUE.CFV_ID), (Long)record.get(DSL.field((String)"ID", Long.class)), value, (String)record.get((Field)Tables.CUSTOM_FIELD.CODE));
    }

    protected <R extends Record> SubElementRecordProcessor<CustomFieldValueDto> getCufProcessor(ResultQuery<R> query) {
        return new SubElementRecordProcessor<CustomFieldValueDto>(query, (Field<Long>)DSL.field((String)"ID", Long.class), (Field<Long>)Tables.CUSTOM_FIELD_VALUE.CFV_ID, this::toCustomFieldValueDto, CustomFieldValueDto.class);
    }
}

