/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.hibernate.HibernateQuery;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.Session;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record1;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.True;
import org.jooq.impl.DSL;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.squashtest.tm.core.foundation.collection.ColumnFiltering;
import org.squashtest.tm.core.foundation.collection.SimpleColumnFiltering;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.IdCollector;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQueryFactory;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.project.QProject;
import org.squashtest.tm.domain.testcase.QTestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequest;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.domain.tf.automationrequest.QAutomationRequest;
import org.squashtest.tm.domain.users.QUser;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.testautomation.MissingTransmissionDateException;
import org.squashtest.tm.exception.tf.IllegalAutomationRequestStatusException;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.helper.PagingToQueryDsl;
import org.squashtest.tm.service.internal.repository.CustomAutomationRequestDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;
import org.squashtest.tm.service.testautomation.model.AutomationRequestInfo;

public class AutomationRequestDaoImpl
implements CustomAutomationRequestDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutomationRequestDaoImpl.class);
    private static final String ILLEGAL_STATUS = "One or more AutomationRequest do not have the expected status";
    private static final String DEFAULT_TRANSMITTED_STATUS_FILTER = String.join((CharSequence)";", AutomationRequestStatus.AUTOMATION_IN_PROGRESS.toString(), AutomationRequestStatus.TRANSMITTED.toString());
    private static final String DEFAULT_TO_VALIDATE_FILTER = String.join((CharSequence)";", AutomationRequestStatus.SUSPENDED.toString(), AutomationRequestStatus.WORK_IN_PROGRESS.toString(), AutomationRequestStatus.REJECTED.toString());
    private static final String ASSIGNED_TO = "assignedTo";
    private static final String ASSIGNED_TO_LOGIN = "assignedTo.login";
    private static final String REQ_IDS = "reqIds";
    private static final String REQUEST_IDS = "requestIds";
    private static final String REQUEST_STATUS = "requestStatus";
    private static final String TRANSMITTED_BY = "transmittedBy";
    private static final String TRANSMITTED_ON = "transmittedOn";
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private DSLContext dslContext;

    @Override
    public Page<AutomationRequest> findAll(Pageable pageable, Collection<Long> inProjectIds) {
        LOGGER.debug("searching for automation requests, paged", new Object[0]);
        return this.innerFindAll(pageable, (ColumnFiltering)new SimpleColumnFiltering(), null, inProjectIds);
    }

    @Override
    public Page<AutomationRequest> findAll(Pageable pageable, ColumnFiltering filtering, Collection<Long> inProjectIds) {
        LOGGER.debug("searching for automation requests, paged and filtered", new Object[0]);
        return this.innerFindAll(pageable, filtering, null, inProjectIds);
    }

    @Override
    public Page<AutomationRequest> findAllForAssignee(String username, Pageable pageable, ColumnFiltering filtering, Collection<Long> inProjectIds) {
        LOGGER.debug("searching for automation requests, paged and filtered for user : '{}'", new Object[]{username});
        SimpleColumnFiltering filterWithAssignee = new SimpleColumnFiltering(filtering).addFilter(ASSIGNED_TO_LOGIN, username);
        return this.innerFindAll(pageable, (ColumnFiltering)filterWithAssignee, converter -> {
            PagingToQueryDsl.ColumnFilteringConverter columnFilteringConverter = converter.compare(ASSIGNED_TO_LOGIN).withEquality();
        }, inProjectIds);
    }

    @Override
    public Page<AutomationRequest> findAllTransmitted(Pageable pageable, ColumnFiltering columnFiltering, Collection<Long> inProjectIds) {
        ColumnFiltering filterWithTraitment = this.overrideStatusAndAssignedToFilter(columnFiltering, DEFAULT_TRANSMITTED_STATUS_FILTER, null);
        return this.innerFindAll(pageable, filterWithTraitment, converter -> {
            PagingToQueryDsl.ColumnFilteringConverter columnFilteringConverter = converter.compare(REQUEST_STATUS).withIn().compare(ASSIGNED_TO).isNull();
        }, inProjectIds);
    }

    @Override
    public Page<AutomationRequest> findAllForGlobal(Pageable pageable, ColumnFiltering filtering, Collection<Long> inProjectIds) {
        LOGGER.debug("searching for automation requests, paged and filtered", new Object[0]);
        return this.innerFindAll(pageable, filtering, converter -> {
            PagingToQueryDsl.ColumnFilteringConverter columnFilteringConverter = converter.compare(ASSIGNED_TO_LOGIN).withEquality();
        }, inProjectIds);
    }

    @Override
    public Page<AutomationRequest> findAllValid(Pageable pageable, ColumnFiltering filtering, Collection<Long> inProjectIds) {
        ColumnFiltering filterWithAssignee = this.overrideStatusFilter(filtering, AutomationRequestStatus.READY_TO_TRANSMIT.toString());
        return this.innerFindAll(pageable, filterWithAssignee, null, inProjectIds);
    }

    @Override
    public Page<AutomationRequest> findAllToValidate(Pageable pageable, ColumnFiltering filtering, Collection<Long> inProjectIds) {
        ColumnFiltering effective = this.withStatusFilterOrDefault(filtering, DEFAULT_TO_VALIDATE_FILTER);
        return this.innerFindAll(pageable, effective, converter -> {
            PagingToQueryDsl.ColumnFilteringConverter columnFilteringConverter = converter.compare(REQUEST_STATUS).withIn();
        }, inProjectIds);
    }

    @Override
    public Integer countAutomationRequestForCurrentUser(Long idUser) {
        return (Integer)((Record1)this.dslContext.selectCount().from((TableLike)Tables.AUTOMATION_REQUEST).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).where(Tables.AUTOMATION_REQUEST.ASSIGNED_TO.eq((Object)idUser)).and(Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.isTrue()).and(Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.toString())).fetchOne()).value1();
    }

    @Override
    public Map<Long, String> getTransmittedByForCurrentUser(Long idUser, List<String> requestStatus, List<Long> projectIds) {
        True condition = DSL.trueCondition();
        if (idUser != null) {
            condition = Tables.AUTOMATION_REQUEST.ASSIGNED_TO.eq((Object)idUser);
        }
        return this.dslContext.selectDistinct((SelectField)Tables.CORE_USER.PARTY_ID, (SelectField)Tables.CORE_USER.LOGIN).from((TableLike)Tables.CORE_USER).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.CORE_USER.LOGIN.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY).and(ConditionsConstants.TCLN_NOT_IN_BIN)).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).innerJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).where((Condition)condition).and(Tables.AUTOMATION_REQUEST.REQUEST_STATUS.in(requestStatus)).and(Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name())).and(Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.isTrue()).and(Tables.PROJECT.PROJECT_ID.in(projectIds)).orderBy((OrderField)Tables.CORE_USER.LOGIN).fetch().intoMap((Field)Tables.CORE_USER.PARTY_ID, (Field)Tables.CORE_USER.LOGIN);
    }

    @Override
    public Map<Long, String> getTcLastModifiedByToAutomationRequestNotAssigned(List<String> requestStatus, List<Long> projectIds) {
        return this.dslContext.selectDistinct((SelectField)Tables.CORE_USER.PARTY_ID, (SelectField)Tables.CORE_USER.LOGIN).from((TableLike)Tables.CORE_USER).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.CORE_USER.LOGIN.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY).and(ConditionsConstants.TCLN_NOT_IN_BIN)).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).innerJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).where(Tables.AUTOMATION_REQUEST.ASSIGNED_TO.isNull()).and(Tables.AUTOMATION_REQUEST.REQUEST_STATUS.in(requestStatus)).and(Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name())).and(Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.isTrue()).and(Tables.PROJECT.PROJECT_ID.in(projectIds)).orderBy((OrderField)Tables.CORE_USER.LOGIN).fetch().intoMap((Field)Tables.CORE_USER.PARTY_ID, (Field)Tables.CORE_USER.LOGIN);
    }

    @Override
    public Map<Long, String> getAssignedToForAutomationRequests(List<Long> projectIds) {
        return this.dslContext.selectDistinct((SelectField)Tables.CORE_USER.PARTY_ID, (SelectField)Tables.CORE_USER.LOGIN).from((TableLike)Tables.CORE_USER).innerJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.CORE_USER.PARTY_ID.eq((Field)Tables.AUTOMATION_REQUEST.ASSIGNED_TO)).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID.eq((Field)Tables.TEST_CASE.AUTOMATION_REQUEST_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.isTrue()).and(Tables.PROJECT.PROJECT_ID.in(projectIds)).and(Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name())).orderBy((OrderField)Tables.CORE_USER.LOGIN.asc()).fetch().intoMap((Field)Tables.CORE_USER.PARTY_ID, (Field)Tables.CORE_USER.LOGIN);
    }

    @Override
    public void updateAutomationRequestStatus(List<Long> reqIds, AutomationRequestStatus requestStatus, List<AutomationRequestStatus> allowedStatuses) {
        int automationRequestUpdates = this.entityManager.createQuery("UPDATE AutomationRequest req SET req.requestStatus = :requestStatus where req.id in :reqIds and req.requestStatus in :allowedStatuses").setParameter(REQUEST_STATUS, (Object)requestStatus).setParameter(REQ_IDS, reqIds).setParameter("allowedStatuses", allowedStatuses).executeUpdate();
        if (reqIds.size() != automationRequestUpdates) {
            throw new IllegalAutomationRequestStatusException(ILLEGAL_STATUS);
        }
    }

    @Override
    public void updatePriority(List<Long> tcIds, Integer priority) {
        this.entityManager.createQuery("UPDATE AutomationRequest req SET req.automationPriority = :priority WHERE req.id in (select tc.automationRequest.id from TestCase tc where tc.id in :tcIds)").setParameter("priority", (Object)priority).setParameter("tcIds", tcIds).executeUpdate();
    }

    @Override
    public void unassignRequests(List<Long> requestIds) {
        this.entityManager.createQuery("update AutomationRequest ar set ar.assignedTo = NULL, ar.assignmentDate = NULL where ar.id in :requestIds").setParameter(REQUEST_IDS, requestIds).executeUpdate();
    }

    @Override
    public List<Long> getReqIdsByTcIds(List<Long> tcIds) {
        return this.dslContext.selectDistinct((SelectField)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID).from((TableLike)Tables.AUTOMATION_REQUEST).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID.eq((Field)Tables.TEST_CASE.AUTOMATION_REQUEST_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.TEST_CASE.TCLN_ID.in(tcIds)).fetch((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID);
    }

    @Override
    public List<AutomationRequestInfo> getAllAutomReqInfoByTcIds(List<Long> tcIds) {
        return this.dslContext.select((SelectField)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID.as("ID"), (SelectField)Tables.PROJECT.AUTOMATION_WORKFLOW_TYPE.as("WORKFLOW_TYPE"), (SelectField)Tables.PROJECT.SCM_REPOSITORY_ID.as("SCM_REPOSITORY_ID"), (SelectField)DSL.when((Condition)Tables.SCRIPTED_TEST_CASE.TCLN_ID.isNotNull(), (Object)TestCaseKind.GHERKIN.name()).when(Tables.KEYWORD_TEST_CASE.TCLN_ID.isNotNull(), (Object)TestCaseKind.KEYWORD.name()).otherwise((Object)TestCaseKind.STANDARD.name()).as("KIND"), (SelectField)Tables.AUTOMATION_REQUEST.TRANSMITTED_ON.as("TRANSMISSION_DATE")).from((TableLike)Tables.PROJECT).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID.eq((Field)Tables.TEST_CASE.AUTOMATION_REQUEST_ID)).leftJoin((TableLike)Tables.SCRIPTED_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.SCRIPTED_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.KEYWORD_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.KEYWORD_TEST_CASE.TCLN_ID)).where(Tables.TEST_CASE.TCLN_ID.in(tcIds)).fetchInto(AutomationRequestInfo.class);
    }

    @Override
    public List<Long> updateStatusToTransmitted(List<AutomationRequestInfo> automationRequestInfoList, User transmittedBy) {
        List<Long> reqIds = automationRequestInfoList.stream().filter(AutomationRequestInfo::canBeTransmitted).map(AutomationRequestInfo::getId).toList();
        int automationRequestUpdates = this.entityManager.createQuery("UPDATE AutomationRequest ar SET ar.transmissionDate = :transmittedOn, ar.requestStatus = :requestStatus, ar.transmittedBy = :transmittedBy where ar.id in :requestIds").setParameter(TRANSMITTED_ON, (Object)new Timestamp(new Date().getTime())).setParameter(REQUEST_STATUS, (Object)AutomationRequestStatus.TRANSMITTED).setParameter(TRANSMITTED_BY, (Object)transmittedBy).setParameter(REQUEST_IDS, reqIds).executeUpdate();
        if (reqIds.size() != automationRequestUpdates) {
            throw new IllegalAutomationRequestStatusException(ILLEGAL_STATUS);
        }
        return reqIds;
    }

    @Override
    public void updateConflictAssociation(Long testCaseId, String newValue) {
        this.entityManager.createNamedQuery("AutomationRequest.updateConflictAssociation").setParameter("conflictAssociation", (Object)newValue).setParameter("testCaseId", (Object)testCaseId).executeUpdate();
    }

    @Override
    public void updateIsManual(Long testCaseId, boolean newValue) {
        this.entityManager.createNamedQuery("AutomationRequest.updateIsManual").setParameter("isManual", (Object)newValue).setParameter("testCaseId", (Object)testCaseId).executeUpdate();
    }

    @Override
    public void updateStatusToAutomated(List<AutomationRequestInfo> automationRequestInfoList, AutomationRequestStatus requestStatus, List<AutomationRequestStatus> initialStatus) {
        List<Long> nonTransmittableNativeSimpleReqIds = automationRequestInfoList.stream().filter(automationRequestInfo -> !automationRequestInfo.canBeTransmitted()).map(AutomationRequestInfo::getId).toList();
        if (!nonTransmittableNativeSimpleReqIds.isEmpty()) {
            this.doUpdateStatusToAutomated(nonTransmittableNativeSimpleReqIds, requestStatus, initialStatus);
        } else {
            List<AutomationRequestInfo> transmittableAutomRequestInfo = automationRequestInfoList.stream().filter(AutomationRequestInfo::canBeTransmitted).toList();
            List<Long> updatableAutoRequestIds = transmittableAutomRequestInfo.stream().filter(automationRequestInfo -> automationRequestInfo.getTransmissionDate() != null).map(AutomationRequestInfo::getId).toList();
            this.doUpdateStatusToAutomated(updatableAutoRequestIds, requestStatus, initialStatus);
            this.alertIfTransmissionDateIsMissing(transmittableAutomRequestInfo);
        }
    }

    private void doUpdateStatusToAutomated(List<Long> reqIds, AutomationRequestStatus requestStatus, List<AutomationRequestStatus> initialStatus) {
        int automationRequestUpdateCount = this.entityManager.createQuery("UPDATE AutomationRequest req SET req.requestStatus = :requestStatus where req.id in :reqIds and req.requestStatus in :initialStatus").setParameter(REQUEST_STATUS, (Object)requestStatus).setParameter(REQ_IDS, reqIds).setParameter("initialStatus", initialStatus).executeUpdate();
        if (reqIds.size() != automationRequestUpdateCount) {
            throw new IllegalAutomationRequestStatusException(ILLEGAL_STATUS);
        }
    }

    private void alertIfTransmissionDateIsMissing(List<AutomationRequestInfo> automationRequestInfoList) {
        List<AutomationRequestInfo> missingTransmissionDateAutomRequests = automationRequestInfoList.stream().filter(AutomationRequestInfo::canBeTransmitted).filter(transmittableAutomRequest -> transmittableAutomRequest.getTransmissionDate() == null).toList();
        if (!missingTransmissionDateAutomRequests.isEmpty()) {
            throw new MissingTransmissionDateException();
        }
    }

    private Page<AutomationRequest> innerFindAll(Pageable pageable, ColumnFiltering filtering, FilterOverride filterOverride, Collection<Long> inProjectIds) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("searching in projects : {}", new Object[]{inProjectIds});
            LOGGER.trace("page size : {}, page num : {}, filter by : {}", new Object[]{pageable.getPageSize(), pageable.getPageNumber(), filtering.getFilteredAttributes()});
        }
        HibernateQuery<AutomationRequest> baseQuery = this.createFindAllBaseQuery(inProjectIds);
        Predicate predicate = this.toQueryDslPredicate(filtering, filterOverride);
        baseQuery.where(predicate);
        LOGGER.trace("fetching automation requests", new Object[0]);
        List<AutomationRequest> requests = this.findRequests(baseQuery, pageable);
        LOGGER.trace("counting automation requests", new Object[0]);
        long count = this.countRequests(baseQuery);
        return new PageImpl(requests, pageable, count);
    }

    @Override
    public Integer countAutomationRequestValid(List<Long> readableIds) {
        return (Integer)((Record1)this.dslContext.selectCount().from((TableLike)Tables.AUTOMATION_REQUEST).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).where(Tables.AUTOMATION_REQUEST.REQUEST_STATUS.eq((Object)AutomationRequestStatus.READY_TO_TRANSMIT.toString())).and(Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.isTrue()).and(Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.toString())).and(Tables.PROJECT.PROJECT_ID.in(readableIds)).fetchOne()).value1();
    }

    @Override
    public void assignedToRequestIds(List<Long> reqIds, User user) {
        int automationRequestUpdates = this.entityManager.createQuery("UPDATE AutomationRequest ar SET ar.assignedTo = :assignee, ar.assignmentDate = :assignedOn where ar.id in :reqIds").setParameter("assignee", (Object)user).setParameter(REQ_IDS, reqIds).setParameter("assignedOn", (Object)new Timestamp(new Date().getTime())).executeUpdate();
        if (reqIds.size() != automationRequestUpdates) {
            throw new IllegalAutomationRequestStatusException(ILLEGAL_STATUS);
        }
    }

    private List<AutomationRequest> findRequests(HibernateQuery<AutomationRequest> baseQuery, Pageable pageable) {
        HibernateQuery fetchRequest = (HibernateQuery)baseQuery.clone();
        ((HibernateQuery)fetchRequest.offset(pageable.getOffset())).limit((long)pageable.getPageSize());
        OrderSpecifier<?>[] orderSpecifiers = this.toQueryDslSorting(pageable.getSort());
        fetchRequest.orderBy(orderSpecifiers);
        List requests = fetchRequest.fetch();
        if (LOGGER.isTraceEnabled()) {
            List ids = IdCollector.collect((Collection)requests);
            LOGGER.trace("found {} automation requests, ids are : {}", new Object[]{requests.size(), ids});
        }
        return requests;
    }

    private long countRequests(HibernateQuery<AutomationRequest> baseQuery) {
        HibernateQuery countRequest = (HibernateQuery)baseQuery.clone();
        return countRequest.fetchCount();
    }

    private HibernateQuery<AutomationRequest> createFindAllBaseQuery(Collection<Long> inProjectIds) {
        QAutomationRequest request = QAutomationRequest.automationRequest;
        QTestCase testCase = QTestCase.testCase;
        QProject project = QProject.project1;
        QUser assignedTo = new QUser(ASSIGNED_TO);
        QUser transmittedBy = new QUser(TRANSMITTED_BY);
        QUser createdBy = new QUser("createdBy");
        return (HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)new ExtendedHibernateQueryFactory(this.getSession()).from((EntityPath)request).leftJoin((EntityPath)request.testCase, (Path)testCase)).leftJoin((EntityPath)testCase.project, (Path)project)).leftJoin((EntityPath)request.assignedTo, (Path)assignedTo)).leftJoin((EntityPath)request.transmittedBy, (Path)transmittedBy)).leftJoin((EntityPath)request.createdBy, (Path)createdBy)).where((Predicate)project.id.in(inProjectIds).and((Predicate)request.testCase.automatable.eq((Object)TestCaseAutomatable.Y)).and((Predicate)project.allowAutomationWorkflow.isTrue()).and((Predicate)project.automationWorkflowType.eq((Object)AutomationWorkflowType.NATIVE)));
    }

    private Predicate toQueryDslPredicate(ColumnFiltering filtering, FilterOverride override) {
        PagingToQueryDsl.ColumnFilteringConverter converter = PagingToQueryDsl.filterConverter(AutomationRequest.class).from(filtering).typeFor(REQUEST_STATUS).isClass(AutomationRequestStatus.class).typeFor("testCase.kind").isClass(TestCaseKind.class).typeFor("id", "automationPriority").isClass(Long.class).typeFor("testCase.id").isClass(Long.class).typeFor("createdBy", TRANSMITTED_BY, ASSIGNED_TO).isClass(Long.class).compare("transmissionDate", "assignmentDate").withDates().compare("id", "automationPriority", "testCase.audit.lastModifiedBy").withEquality();
        if (override != null) {
            override.accept(converter);
        }
        return converter.build();
    }

    private ColumnFiltering withStatusFilterOrDefault(ColumnFiltering filtering, String statusFilter) {
        ColumnFiltering effective = filtering;
        if (filtering.getFilter(REQUEST_STATUS).isEmpty()) {
            effective = this.overrideStatusFilter(filtering, statusFilter);
        }
        return effective;
    }

    private ColumnFiltering overrideStatusFilter(ColumnFiltering filtering, String statusFilter) {
        return new SimpleColumnFiltering(filtering).addFilter(REQUEST_STATUS, statusFilter);
    }

    private ColumnFiltering overrideStatusAndAssignedToFilter(ColumnFiltering filtering, String statusFilter, String userID) {
        SimpleColumnFiltering effective = null;
        effective = filtering.getFilter(REQUEST_STATUS).isEmpty() ? new SimpleColumnFiltering(filtering).addFilter(REQUEST_STATUS, statusFilter).addFilter(ASSIGNED_TO, userID) : new SimpleColumnFiltering(filtering).addFilter(REQUEST_STATUS, filtering.getFilter(REQUEST_STATUS)).addFilter(ASSIGNED_TO, userID);
        return effective;
    }

    private OrderSpecifier<?>[] toQueryDslSorting(Sort sort) {
        return PagingToQueryDsl.sortConverter(AutomationRequest.class).from(sort).typeFor(REQUEST_STATUS).isClass(AutomationRequestStatus.class).build();
    }

    private Session getSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    private static interface FilterOverride
    extends Consumer<PagingToQueryDsl.ColumnFilteringConverter> {
    }
}

