/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.repository.display.TestCaseResearchDisplayDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

@Repository
public class TestCaseResearchDisplayDaoImpl
implements TestCaseResearchDisplayDao {
    private static final String ID_ALIAS = "ID";
    private static final String ITEMS_ALIAS = "ITERATIONS";
    private static final String SPRINTS_ALIAS = "NB_SPRINTS";
    private static final String MILESTONES_ALIAS = "MILESTONES";
    private static final String NATURE_ALIAS = "NATURE";
    private static final String REQ_MILESTONE_LOCKED = "REQ_MILESTONE_LOCKED";
    private static final String STATUS_ALIAS = "STATUS";
    private static final String STEPS_ALIAS = "STEPS";
    private static final String TC_MILESTONE_LOCKED = "TC_MILESTONE_LOCKED";
    private static final String TYPE_ALIAS = "TYPE";
    private static final String ITERATION_LIST = "ITERATION_LIST";
    private static final String TEST_SUITE_LIST = "TEST_SUITE_LIST";
    private static final String CAMPAIGN_LIST = "CAMPAIGN_LIST";
    private static final String DATASETS_ALIAS = "DATASETS";
    private static final String PARAMETER_ALIAS = "PARAM_COUNT";
    private static final String CALL_STEP_COUNT_ALIAS = "CALL_STEP_COUNT";
    private static final String TEST_CASE_ENTITY_TYPE = "TEST_CASE";
    private static final String TEST_CASE_SEARCH = "test-case-search";
    private final DSLContext jooq;

    public TestCaseResearchDisplayDaoImpl(DSLContext jooq) {
        this.jooq = jooq;
    }

    @Override
    public GridResponse getRows(List<Long> testCaseIds, GridRequest gridRequest) {
        GridResponse gridResponse = new GridResponse();
        List<SelectConditionStep<?>> countQueries = this.getCountFields();
        SelectSelectStep selectBaseColumns = this.jooq.select(this.getFields());
        List<String> simplifiedColumnDisplayGridIds = gridRequest.getSimplifiedColumnDisplayGridIds();
        SelectSelectStep selectAllColumns = !simplifiedColumnDisplayGridIds.contains(TEST_CASE_SEARCH) ? selectBaseColumns.select(new SelectFieldOrAsterisk[]{countQueries.get(0).asField(MILESTONES_ALIAS), countQueries.get(1).asField("COVERAGES"), countQueries.get(2).asField(STEPS_ALIAS), countQueries.get(3).asField(ITEMS_ALIAS), countQueries.get(4).asField("ATTACHMENTS"), countQueries.get(5).asField(DATASETS_ALIAS), countQueries.get(6).asField(PARAMETER_ALIAS), countQueries.get(7).asField(CALL_STEP_COUNT_ALIAS), countQueries.get(8).asField("EXECUTION_COUNT"), countQueries.get(9).asField("ISSUE_COUNT"), countQueries.get(10).asField(SPRINTS_ALIAS)}) : selectBaseColumns.select(new SelectFieldOrAsterisk[]{DSL.value(null).as(MILESTONES_ALIAS), DSL.value(null).as("COVERAGES"), DSL.value(null).as(STEPS_ALIAS), DSL.value(null).as(ITEMS_ALIAS), DSL.value(null).as("ATTACHMENTS"), DSL.value(null).as(DATASETS_ALIAS), DSL.value(null).as(PARAMETER_ALIAS), DSL.value(null).as(CALL_STEP_COUNT_ALIAS), DSL.value(null).as("EXECUTION_COUNT"), DSL.value(null).as("ISSUE_COUNT"), DSL.value(null).as(SPRINTS_ALIAS)});
        this.getCufFields((SelectSelectStep<Record>)selectAllColumns, simplifiedColumnDisplayGridIds);
        selectAllColumns.from(this.getTable()).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.in(testCaseIds)).groupBy(new GroupField[]{Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as(ID_ALIAS), Tables.TEST_CASE.TCLN_ID, Tables.PROJECT.PROJECT_ID, Tables.AUTOMATION_REQUEST.AUTOMATION_PRIORITY, Tables.AUTOMATION_REQUEST.TRANSMITTED_ON, Tables.AUTOMATION_REQUEST.REQUEST_STATUS, Tables.SCRIPTED_TEST_CASE.TCLN_ID, Tables.KEYWORD_TEST_CASE.TCLN_ID, Tables.EXPLORATORY_TEST_CASE.TCLN_ID, Tables.SCRIPTED_TEST_CASE.SCRIPT, Tables.AUTOMATED_TEST_TECHNOLOGY.NAME}).stream().forEach(record -> {
            DataRow dataRow = new DataRow();
            dataRow.setId(((Long)record.get(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as(ID_ALIAS))).toString());
            dataRow.setProjectId((Long)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID));
            Map rawData = record.intoMap();
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (Map.Entry entry : rawData.entrySet()) {
                data.put(this.convertField((String)entry.getKey()), entry.getValue());
            }
            dataRow.setData(data);
            gridResponse.addDataRow(dataRow);
        });
        return gridResponse;
    }

    private List<Field<?>> getFields() {
        return Arrays.asList(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as(ID_ALIAS), Tables.TEST_CASE_LIBRARY_NODE.NAME, Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID, Tables.TEST_CASE_LIBRARY_NODE.CREATED_BY, Tables.TEST_CASE_LIBRARY_NODE.CREATED_ON, Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY, Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_ON, DSL.decode((Object)Tables.TEST_CASE_LIBRARY_NODE.DESCRIPTION, (Object)"", (Object)false, (Object[])new Object[]{true}).as((Field)Tables.TEST_CASE_LIBRARY_NODE.DESCRIPTION), Tables.TEST_CASE.REFERENCE, Tables.TEST_CASE.IMPORTANCE, Tables.TEST_CASE.IMPORTANCE_AUTO, Tables.TEST_CASE.TC_NATURE.as(NATURE_ALIAS), Tables.TEST_CASE.TC_TYPE.as(TYPE_ALIAS), Tables.TEST_CASE.TC_STATUS.as(STATUS_ALIAS), DSL.when((Condition)Tables.SCRIPTED_TEST_CASE.TCLN_ID.isNotNull(), (Object)TestCaseKind.GHERKIN.name()).when(Tables.KEYWORD_TEST_CASE.TCLN_ID.isNotNull(), (Object)TestCaseKind.KEYWORD.name()).when(Tables.EXPLORATORY_TEST_CASE.TCLN_ID.isNotNull(), (Object)TestCaseKind.EXPLORATORY.name()).otherwise((Object)TestCaseKind.STANDARD.name()).as("KIND"), Tables.TEST_CASE.AUTOMATABLE, Tables.TEST_CASE.DRAFTED_BY_AI, Tables.AUTOMATION_REQUEST.AUTOMATION_PRIORITY, Tables.AUTOMATION_REQUEST.TRANSMITTED_ON, Tables.AUTOMATION_REQUEST.REQUEST_STATUS, DSL.decode((Object)Tables.TEST_CASE.TA_TEST, null, (Object)false, (Object[])new Object[]{true}).as("HAS_AUTO_SCRIPT"), Tables.AUTOMATED_TEST_TECHNOLOGY.NAME.as("AUTOMATED_TEST_TECHNOLOGY"), DSL.decode((Object)Tables.TEST_CASE.SCM_REPOSITORY_ID, null, (Object)false, (Object[])new Object[]{true}).as("HAS_BOUND_SCM_REPOSITORY"), DSL.decode((Object)Tables.TEST_CASE.AUTOMATED_TEST_REFERENCE, null, (Object)false, (Object[])new Object[]{true}).as("HAS_BOUND_AUTOMATED_TEST_REFERENCE"), Tables.PROJECT.NAME.as("PROJECT_NAME"), DSL.groupConcat((Field)Tables.MILESTONE.LABEL).orderBy(new OrderField[]{Tables.MILESTONE.LABEL}).separator(", ").as("MILESTONE_LABELS"), DSL.groupConcat((Field)Tables.MILESTONE.STATUS).orderBy(new OrderField[]{Tables.MILESTONE.LABEL}).separator(", ").as("MILESTONE_STATUS"), DSL.groupConcat((Field)Tables.MILESTONE.END_DATE).orderBy(new OrderField[]{Tables.MILESTONE.LABEL}).separator(", ").as("MILESTONE_END_DATE"), DSL.select((SelectField)DSL.countDistinct((Field)Tables.MILESTONE.MILESTONE_ID)).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).join((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID)).join((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).and(Tables.MILESTONE.STATUS.eq((Object)"LOCKED")).asField(REQ_MILESTONE_LOCKED), DSL.select((SelectField)DSL.groupConcatDistinct((Field)Tables.ITERATION.ITERATION_ID)).from((TableLike)Tables.ITERATION).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).where(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).asField(ITERATION_LIST), DSL.select((SelectField)DSL.groupConcatDistinct((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID)).from((TableLike)Tables.TEST_PLAN_ITEM).join((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).asField(TEST_SUITE_LIST), DSL.select((SelectField)DSL.groupConcatDistinct((Field)Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID)).from((TableLike)Tables.CAMPAIGN_TEST_PLAN_ITEM).where(Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).asField(CAMPAIGN_LIST), DSL.select((SelectField)DSL.countDistinct((Field)Tables.MILESTONE.MILESTONE_ID)).from((TableLike)Tables.MILESTONE_TEST_CASE).join((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_TEST_CASE.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).and(Tables.MILESTONE.STATUS.eq((Object)"LOCKED")).asField(TC_MILESTONE_LOCKED));
    }

    private List<SelectConditionStep<?>> getCountFields() {
        ArrayList countQueries = new ArrayList();
        countQueries.add(DSL.selectCount().from((TableLike)Tables.MILESTONE_TEST_CASE).where(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)));
        countQueries.add(DSL.selectCount().from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)));
        countQueries.add(DSL.selectCount().from((TableLike)Tables.TEST_CASE_STEPS).where(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)));
        countQueries.add(DSL.select((SelectField)DSL.countDistinct((Field)Tables.ITERATION.ITERATION_ID)).from((TableLike)Tables.ITERATION).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).where(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)));
        countQueries.add(DSL.selectCount().from((TableLike)Tables.ATTACHMENT).where(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.ATTACHMENT_LIST_ID)));
        countQueries.add(DSL.selectCount().from((TableLike)Tables.DATASET).where(Tables.DATASET.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)));
        countQueries.add(DSL.selectCount().from((TableLike)Tables.PARAMETER).where(Tables.PARAMETER.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)));
        countQueries.add(DSL.selectCount().from((TableLike)Tables.TEST_CASE_STEPS).join((TableLike)Tables.CALL_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID)).where(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)));
        countQueries.add(DSL.selectCount().from((TableLike)Tables.EXECUTION).where(Tables.EXECUTION.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)));
        countQueries.add(DSL.select((SelectField)DSL.countDistinct((Field)Tables.ISSUE.REMOTE_ISSUE_ID)).from((TableLike)Tables.ISSUE).join((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).on(Tables.EXECUTION_ISSUES_CLOSURE.ISSUE_ID.eq((Field)Tables.ISSUE.ISSUE_ID)).join((TableLike)Tables.EXECUTION).on(Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).where(Tables.EXECUTION.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)));
        countQueries.add(DSL.select((SelectField)DSL.countDistinct((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID)).from((TableLike)Tables.SPRINT_REQ_VERSION).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).where(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)));
        return countQueries;
    }

    private Table<?> getTable() {
        return Tables.TEST_CASE_LIBRARY_NODE.innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftOuterJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).leftOuterJoin((TableLike)Tables.SCRIPTED_TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.SCRIPTED_TEST_CASE.TCLN_ID)).leftOuterJoin((TableLike)Tables.KEYWORD_TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.KEYWORD_TEST_CASE.TCLN_ID)).leftOuterJoin((TableLike)Tables.AUTOMATED_TEST_TECHNOLOGY).on(Tables.TEST_CASE.AUTOMATED_TEST_TECHNOLOGY.eq((Field)Tables.AUTOMATED_TEST_TECHNOLOGY.AT_TECHNOLOGY_ID)).leftOuterJoin((TableLike)Tables.EXPLORATORY_TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.EXPLORATORY_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_TEST_CASE.MILESTONE_ID));
    }

    private String convertField(String fieldName) {
        if (fieldName.startsWith("cuf|")) {
            return fieldName;
        }
        Converter converter = CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL);
        return (String)converter.convert((Object)fieldName);
    }

    private void getCufFields(SelectSelectStep<Record> selectBaseColumns, List<String> simplifiedColumnDisplayGridIds) {
        List cufIds = this.jooq.selectDistinct((SelectField)Tables.CUSTOM_FIELD.CF_ID).from((TableLike)Tables.CUSTOM_FIELD).innerJoin((TableLike)Tables.CUSTOM_FIELD_BINDING).on(Tables.CUSTOM_FIELD.CF_ID.eq((Field)Tables.CUSTOM_FIELD_BINDING.CF_ID)).where(Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY.eq((Object)TEST_CASE_ENTITY_TYPE)).fetchInto(Long.class);
        if (!simplifiedColumnDisplayGridIds.contains(TEST_CASE_SEARCH)) {
            for (Long cufId : cufIds) {
                selectBaseColumns.select(new SelectFieldOrAsterisk[]{DSL.select((SelectField)DSL.when((Condition)Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)String.valueOf(InputType.TAG)), (Field)DSL.groupConcat((Field)Tables.CUSTOM_FIELD_VALUE_OPTION.LABEL).separator(", ")).otherwise((Field)Tables.CUSTOM_FIELD_VALUE.VALUE)).from((TableLike)Tables.CUSTOM_FIELD_VALUE).leftOuterJoin((TableLike)Tables.CUSTOM_FIELD_VALUE_OPTION).on(Tables.CUSTOM_FIELD_VALUE.CFV_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE_OPTION.CFV_ID)).where(Tables.CUSTOM_FIELD_VALUE.CF_ID.eq((Object)cufId)).and(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).and(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE.eq((Object)TEST_CASE_ENTITY_TYPE)).groupBy(new GroupField[]{Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE, Tables.CUSTOM_FIELD_VALUE.VALUE}).asField("cuf|" + String.valueOf(cufId))});
            }
        } else {
            for (Long cufId : cufIds) {
                selectBaseColumns.select(new SelectFieldOrAsterisk[]{DSL.value(null).as("CUF_" + String.valueOf(cufId))});
            }
        }
    }
}

