/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.quicktest;

import java.time.LocalDate;
import java.util.Date;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.quicktest.QuickTest;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.internal.repository.QuickTestDao;
import org.squashtest.tm.service.internal.repository.SprintReqVersionDao;
import org.squashtest.tm.service.quicktest.QuickTestCreationService;

@Service
public class QuickTestCreationServiceImpl
implements QuickTestCreationService {
    private final QuickTestDao quickTestDao;
    private final SprintReqVersionDao sprintReqVersionDao;
    private final MessageSource messageSource;

    public QuickTestCreationServiceImpl(QuickTestDao quickTestDao, SprintReqVersionDao sprintReqVersionDao, MessageSource messageSource) {
        this.quickTestDao = quickTestDao;
        this.sprintReqVersionDao = sprintReqVersionDao;
        this.messageSource = messageSource;
    }

    private Locale currentLocale() {
        return LocaleContextHolder.getLocale();
    }

    @Override
    public QuickTest createQuickTest(long sprintReqVersionId) {
        SprintReqVersion sprintReqVersion = (SprintReqVersion)this.sprintReqVersionDao.getReferenceById(sprintReqVersionId);
        QuickTest quickTest = new QuickTest();
        quickTest.setName(this.generateNameWithDateLocalSensitive());
        quickTest.setSprintReqVersion(sprintReqVersion);
        quickTest.setCreatedOn(new Date());
        quickTest.setCreatedBy(UserContextHolder.getUsername());
        sprintReqVersion.setLastModifiedBy(UserContextHolder.getUsername());
        sprintReqVersion.setLastModifiedOn(new Date());
        this.quickTestDao.save(quickTest);
        return quickTest;
    }

    private String generateNameWithDateLocalSensitive() {
        LocalDate date = LocalDate.now();
        Locale locale = this.currentLocale();
        int day = date.getDayOfMonth();
        int month = date.getMonthValue();
        String formattedDate = "en".equals(locale.getLanguage()) ? String.format("%02d/%02d", month, day) : String.format("%02d/%02d", day, month);
        String prefix = this.messageSource.getMessage("campaign.sprint.quick-test.name.label.prefix", null, LocaleContextHolder.getLocale());
        return String.join((CharSequence)" ", prefix, formattedDate);
    }
}

